function MRI = avw2brainstorm(avw, machine);
%AVW2BRAINSTORM - : Converts an AVW MRI structure (from D. Weber's EEGToolbox) to BRAINSTORM MRI format
% function MRI = avw2brainstorm(avw, machine);
% Reads out an avw structure obtained using the avw_img_read tool from D.
% Weber's EEGToolbox to a BrainStorm MRI structure
% Inputs-
% awv : an AWV structure (see avw_img_read.m in the EEGToolbox)
% machine: is either 'ieee-be' or 'ieee-le' for big and little-endian
% binary data encoding respectively on current machine
% Output:
% MRI : a BrainStorm MRI structure
% See also: avw_img_read.m and help_data_image.m

%<autobegin> ---------------------- 14-Jun-2004 17:09:45 -----------------------
% --------- Automatically Generated Comments Block Using AUTO_COMMENTS ---------
%
% CATEGORY: Utility - General
%
% Alphabetical list of external functions (non-Matlab):
%   toolbox\bst_message_window.m
%
% At Check-in: $Author: Mosher $  $Revision: 3 $  $Date: 6/14/04 3:37p $
%
% This software is part of BrainStorm Toolbox Version 2.0 (Alpha) 14-Jun-2004
% 
% Principal Investigators and Developers:
% ** Richard M. Leahy, PhD, Signal & Image Processing Institute,
%    University of Southern California, Los Angeles, CA
% ** John C. Mosher, PhD, Biophysics Group,
%    Los Alamos National Laboratory, Los Alamos, NM
% ** Sylvain Baillet, PhD, Cognitive Neuroscience & Brain Imaging Laboratory,
%    CNRS, Hopital de la Salpetriere, Paris, France
% 
% See BrainStorm website at http://neuroimage.usc.edu for further information.
% 
% Copyright (c) 2004 BrainStorm by the University of Southern California
% This software distributed  under the terms of the GNU General Public License
% as published by the Free Software Foundation. Further details on the GPL
% license can be found at http://www.gnu.org/copyleft/gpl.html .
% 
% FOR RESEARCH PURPOSES ONLY. THE SOFTWARE IS PROVIDED "AS IS," AND THE
% UNIVERSITY OF SOUTHERN CALIFORNIA AND ITS COLLABORATORS DO NOT MAKE ANY
% WARRANTY, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO WARRANTIES OF
% MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, NOR DO THEY ASSUME ANY
% LIABILITY OR RESPONSIBILITY FOR THE USE OF THIS SOFTWARE.
%<autoend> ------------------------ 14-Jun-2004 17:09:45 -----------------------

% /---Script Author--------------------------------------\
% |                                                      |
% | *** Sylvain Baillet, Ph.D.                           |
% | Cognitive Neuroscience & Brain Imaging Laboratory    |
% | CNRS UPR640 - LENA                                   | 
% | Hopital de la Salpetriere, Paris, France             |
% | sylvain.baillet@chups.jussieu.fr                     |
% \------------------------------------------------------/
%  
% Date of creation: June 2004

switch(deblank(avw.hdr.dime.vox_units))
    case 'mm'
        factor = 1;
    case 'm'
        factor = 1000;
    otherwise
        errordlg(sprintf(...
            'Unrecognized ANALYZE voxel units: %s',...
            deblank(avw.hdr.dime.vox_units)))
        return
end

MRI.Cube = avw.img;
MRI.Voxsize = (double(avw.hdr.dime.pixdim([2:4]))*factor);

MRI.header = 0; % Now for BrainStorm format

switch double(avw.hdr.dime.bitpix),
    case  1,   precision = 'bit1';
    case  8,   precision = 'uchar';
    case 16,   precision = 'int16';
    case 32,
        if     isequal(avw.hdr.dime.datatype, 8), precision = 'int32';
        else                                      precision = 'single';
        end
    case 64,   precision = 'double';
    otherwise,
        precision = 'uchar';
        bst_message_window('...precision undefined in header, using ''uchar''\n');
end
MRI.DataClass = precision;

switch double(avw.hdr.hist.orient),
    case 0
        MRI.scantype = 'axial';
    case 1 
        MRI.scantype = 'coronal';
    case 2
        MRI.scantype = 'sagittal';
end

