function B = blk_lex(A,n);
%BLK_LEX - Lexicographically order the submatrices in A
% function B = blk_lex(A,n);
% Form B from the first n columns of A.  Concatenate below B the next n
%  columns of A.  Repeat for all submatrices of size n.
% Effectively a block form of A(:), such that A(:) == blk_lex(A,1);
% If A is m x b*n, where b is the number of submatrices, 
%  then B =blk_lex(A,n) is m*b x n.
% The reverse operation is A = blk_lex(B',m)';
%
% See also BLK_RESHAPE, BLK_TRANS

%<autobegin> ---------------------- 14-Jun-2004 17:09:49 -----------------------
% --------- Automatically Generated Comments Block Using AUTO_COMMENTS ---------
%
% CATEGORY: Utility - Numeric
%
% At Check-in: $Author: Mosher $  $Revision: 16 $  $Date: 6/14/04 3:37p $
%
% This software is part of BrainStorm Toolbox Version 2.0 (Alpha) 14-Jun-2004
% 
% Principal Investigators and Developers:
% ** Richard M. Leahy, PhD, Signal & Image Processing Institute,
%    University of Southern California, Los Angeles, CA
% ** John C. Mosher, PhD, Biophysics Group,
%    Los Alamos National Laboratory, Los Alamos, NM
% ** Sylvain Baillet, PhD, Cognitive Neuroscience & Brain Imaging Laboratory,
%    CNRS, Hopital de la Salpetriere, Paris, France
% 
% See BrainStorm website at http://neuroimage.usc.edu for further information.
% 
% Copyright (c) 2004 BrainStorm by the University of Southern California
% This software distributed  under the terms of the GNU General Public License
% as published by the Free Software Foundation. Further details on the GPL
% license can be found at http://www.gnu.org/copyleft/gpl.html .
% 
% FOR RESEARCH PURPOSES ONLY. THE SOFTWARE IS PROVIDED "AS IS," AND THE
% UNIVERSITY OF SOUTHERN CALIFORNIA AND ITS COLLABORATORS DO NOT MAKE ANY
% WARRANTY, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO WARRANTIES OF
% MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, NOR DO THEY ASSUME ANY
% LIABILITY OR RESPONSIBILITY FOR THE USE OF THIS SOFTWARE.
%<autoend> ------------------------ 14-Jun-2004 17:09:49 -----------------------

% ----------------------------- Script History ---------------------------------
% Author: John C. Mosher, Ph.D.
% September 6, 1995 author
% JCM 19-May-2004  Comments cleaning
% ----------------------------- Script History ---------------------------------

nA = size(A,2);			% how many columns in A
if(rem(nA,n)),
  error('Matrix does not have an integral number of submatrices.')
end

ndx = [1:nA]'; 			% indexing each column
blocks = nA/n;			% how many submatrices
% Form such that the ith row corresponds to the set of ith columns in each
%  submatrix.
ndx = reshape(ndx,n,blocks);
% transpose and lexicographically order.
ndx = ndx';
ndx = ndx(:)';
% The ith set of blocks columns corresponds to the ith column of each block
B = A(:,ndx);
% now reshape for final result
B = reshape(B,size(A,1)*blocks,n);

return
