function brainstorm_reset;
%BRAINSTORM_RESET - Clear Matlab BrainStorm preferences, remove default data
% function brainstorm_reset;
% Command line to clear Preference 'BrainStorm' and clear the
%  default database in the BrainStorm home directory.
% Does not delete other existing data.

%<autobegin> ---------------------- 14-Jun-2004 17:09:50 -----------------------
% --------- Automatically Generated Comments Block Using AUTO_COMMENTS ---------
%
% CATEGORY: Utility - General
%
% Alphabetical list of external functions (non-Matlab):
%   toolbox\make_default_database.m
%
% Group : Preference data and their calls in this file:
%   BST_ROOT = getpref('BrainStorm','brainstormHomeDir');
%   UserDB = getpref('BrainStorm','UserDataBase');
%
% At Check-in: $Author: Mosher $  $Revision: 14 $  $Date: 6/14/04 3:37p $
%
% This software is part of BrainStorm Toolbox Version 2.0 (Alpha) 14-Jun-2004
% 
% Principal Investigators and Developers:
% ** Richard M. Leahy, PhD, Signal & Image Processing Institute,
%    University of Southern California, Los Angeles, CA
% ** John C. Mosher, PhD, Biophysics Group,
%    Los Alamos National Laboratory, Los Alamos, NM
% ** Sylvain Baillet, PhD, Cognitive Neuroscience & Brain Imaging Laboratory,
%    CNRS, Hopital de la Salpetriere, Paris, France
% 
% See BrainStorm website at http://neuroimage.usc.edu for further information.
% 
% Copyright (c) 2004 BrainStorm by the University of Southern California
% This software distributed  under the terms of the GNU General Public License
% as published by the Free Software Foundation. Further details on the GPL
% license can be found at http://www.gnu.org/copyleft/gpl.html .
% 
% FOR RESEARCH PURPOSES ONLY. THE SOFTWARE IS PROVIDED "AS IS," AND THE
% UNIVERSITY OF SOUTHERN CALIFORNIA AND ITS COLLABORATORS DO NOT MAKE ANY
% WARRANTY, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO WARRANTIES OF
% MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, NOR DO THEY ASSUME ANY
% LIABILITY OR RESPONSIBILITY FOR THE USE OF THIS SOFTWARE.
%<autoend> ------------------------ 14-Jun-2004 17:09:50 -----------------------


% ------- History ---------------
% JCM 20-Aug-2003 first build
% JCM 11-Sep-2003 also removing default data sets
% JCM 15-Nov-2003 try and catch error handling
% -------------------------------

yn = input('Removes your existing preferences and default data, continue (y/n): ','s');

if ~strcmp(yn,'y'), % strict response of 'y'
   disp('No action taken');
   return
end

% assume yes from here

if ~ispref('BrainStorm'),
   disp('No BrainStorm preference found in Matlab.');
   disp('Please manually remove default data from BrainStorm home directory,');
   disp(' then type ''startup'' from the BrainStorm directory.');
   return
end

try
   BST_ROOT = getpref('BrainStorm','brainstormHomeDir');
catch
   BST_ROOT = fileparts(which('startup.m'));
end

UserDefault = make_default_database(0,1); % returns default names

% get rid of the defaults

if ispc,
   
   disp('Deleting your default databases . . .');
   
   try
      UserDB = getpref('BrainStorm','UserDataBase'); % the existing database
   catch
      disp('No BrainStorm database preference present');
      disp('Please manually remove default data from BrainStorm home directory,');
      disp([' ' UserDefault.SUBJECTS])
      disp('then type ''startup'' from the BrainStorm directory.');
      return
   end
   
   isValidDir = logical(ones(1,length(UserDB))); % initialize valid directories
   
   for i = 1:length(UserDB),
      
      if exist(UserDB(i).STUDIES,'dir'),
         cd(UserDB(i).STUDIES) % the root name
         try
            dos(sprintf('rmdir /s /q %s',UserDefault.StudyName));
         catch
         end
      else
         isValidDir(i) = logical(0);
      end
      
      if exist(UserDB(i).SUBJECTS,'dir'),
         cd(UserDB(i).SUBJECTS)
         try
            dos(sprintf('rmdir /s /q %s',UserDefault.SubjectName));
         catch
         end
      else
         isValidDir(i) = logical(0);
      end
      
   end
   
   cd(BST_ROOT);
   
   % now remove the default database
   try
      dos(sprintf('rmdir /s /q %s',UserDefault.STUDIES));
   catch
   end
   
   try
      dos(sprintf('rmdir /s /q %s',UserDefault.SUBJECTS)); % may be the same file, with inconsequential error msg
   catch
   end
   
   
else
   
   % not pc 
   disp('Please manually remove all default databases from your computer.');
   disp(sprintf('The BrainStorm default subject is in %s.',UserDefault.SUBJECTS));
   disp(sprintf('The default study is in %s.', UserDefault.STUDIES));
   disp('Remove any other copies of these files found in your other databases.')
   
end


close('all')
close('all','hidden')% close all figures, windows
clear all % clear all memory

if(ispref('BrainStorm')),
   rmpref('BrainStorm');
   disp('Preference BrainStorm deleted.');
end

disp('Database deleted, Preferences purged. Type ''startup'' from the ')
disp('BrainStorm home directory to reinitialize.');
