function [Cmap,map]=c_activ(FV,connectivity_cell,prop_thres,ref_map,acti,cmap);
%C_ACTIV - Finding a colormap to code deepness and activation
% function [Cmap,map]=c_activ(FV,connectivity_cell,prop_thres,ref_map,acti,cmap);
%
%  Finding a colormap to code deepness and activation
%
%  inputs : FV : Face Vertex Data, connectivity_cell : neighbors of the vertices (result of vertices_connectivity)
%           prop_thres : percentage of gyri and sulci, ref_map : colors for gyri and sulci,
%           acti : vector containing activation, cmap : colormap containing deepness coding on the vertices, if it has already been done.
%  outputs : Cmap : colormap containing deepness coding [and activation coding] on the vertices, map : colormap for activation coding
%

%<autobegin> ---------------------- 26-May-2004 11:29:56 -----------------------
% --------- Automatically Generated Comments Block Using AUTO_COMMENTS ---------
%
% CATEGORY: Visualization
%
% Alphabetical list of external functions (non-Matlab):
%   toolbox\catci.m
%   toolbox\contraste.m
%   toolbox\separation.m
%
% At Check-in: $Author: Mosher $  $Revision: 14 $  $Date: 5/26/04 9:59a $
%
% This software is part of BrainStorm Toolbox Version 2.0 (Alpha) 24-May-2004
% 
% Principal Investigators and Developers:
% ** Richard M. Leahy, PhD, Signal & Image Processing Institute,
%    University of Southern California, Los Angeles, CA
% ** John C. Mosher, PhD, Biophysics Group,
%    Los Alamos National Laboratory, Los Alamos, NM
% ** Sylvain Baillet, PhD, Cognitive Neuroscience & Brain Imaging Laboratory,
%    CNRS, Hopital de la Salpetriere, Paris, France
% 
% See BrainStorm website at http://neuroimage.usc.edu for further information.
% 
% Copyright (c) 2004 BrainStorm by the University of Southern California
% This software distributed  under the terms of the GNU General Public License
% as published by the Free Software Foundation. Further details on the GPL
% license can be found at http://www.gnu.org/copyleft/gpl.html .
% 
% FOR RESEARCH PURPOSES ONLY. THE SOFTWARE IS PROVIDED "AS IS," AND THE
% UNIVERSITY OF SOUTHERN CALIFORNIA AND ITS COLLABORATORS DO NOT MAKE ANY
% WARRANTY, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO WARRANTIES OF
% MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, NOR DO THEY ASSUME ANY
% LIABILITY OR RESPONSIBILITY FOR THE USE OF THIS SOFTWARE.
%<autoend> ------------------------ 26-May-2004 11:29:56 -----------------------



% tic
if nargin<=3	% default parameters
 	%BEST ref_map=[0.6 0.6 0.6;0.2 0.2 0.2];
   % ref_map=[0.8 0.8 0.8;0.4 0.4 0.4];
    ref_map = [0.35 0.35 0.35;0.2 0.2 0.2];

    if nargin==2
		prop_thres=0.6;
	end
end
maxicm=max(max(ref_map));

vu=FV.vertices;
fu=FV.faces;

% centering of the brain
v(:,1)=vu(:,1)-sum(sum(vu(:,1)))/size(vu,1).*ones(size(vu,1),1);
v(:,2)=vu(:,2)-sum(sum(vu(:,2)))/size(vu,1).*ones(size(vu,1),1);
v(:,3)=vu(:,3)-sum(sum(vu(:,3)))/size(vu,1).*ones(size(vu,1),1);
clear vu;

% find short and long axes
larg1=max(max(v(:,1)))-min(min(v(:,1)));
larg2=max(max(v(:,2)))-min(min(v(:,2)));
if larg1<larg2
	short_axe=1;
else
	short_axe=2;
end

[I_pos,I_neg]=separation(v,connectivity_cell);
v_pos=zeros(size(v,1),3);
v_neg=zeros(size(v,1),3);
v_pos(I_pos,:)=v(I_pos,:);
v_neg(I_neg,:)=v(I_neg,:);
v_neg(I_neg,short_axe)=v_neg(I_neg,short_axe)-min(min(v(I_neg,short_axe)))/2;
v_pos(I_pos,short_axe)=v_pos(I_pos,short_axe)-max(max(v(I_pos,short_axe)))/2;

if nargin <= 4
	Cmap=contraste(v,v_pos,v_neg,connectivity_cell,I_pos,I_neg,prop_thres,ref_map);
    map = [];
elseif nargin==5
	Cmap=contraste(v,v_pos,v_neg,connectivity_cell,I_pos,I_neg,prop_thres,ref_map);
	[Cmap,map]=catci(acti,Cmap);
elseif nargin==6
	Cmap=cmap;
	[Cmap,map]=catci(acti,Cmap);
end
% toc

% Cmap_pos=Cmap;
% Cmap_neg=Cmap;
% Cmap_pos(I_neg,:)=ones(size(I_neg,1),1)*[0 0 0];
% Cmap_neg(I_pos,:)=ones(size(I_pos,1),1)*[0 0 0];
% 
% figure
% colormap(map);
% set(gcf,'Position',[0 100 850 600]);
% subplot(1,2,1)
% axis equal
% patch('Faces',fu,'Vertices',v,'FaceVertexCData',Cmap,'EdgeColor','none','FaceColor','interp','FaceLighting','phong','backfacelight','unlit');
% light('Position',[1,1,1]);
% light('Position',[-1,-1,1]);
% light('Position',[-1,-1,-1]);
% light('Position',[1,1,-1]);
% material dull;
% colorbar
% subplot(1,2,2)
% axis equal
% patch('Faces',fu,'Vertices',v,'FaceVertexCData',Cmap,'EdgeColor','none','FaceColor','interp','FaceLighting','phong','backfacelight','unlit');
% colorbar
% 
% figure
% colormap(map);
% set(gcf,'Position',[0 100 850 600]);
% subplot(1,2,1)
% axis equal
% patch('Faces',fu,'Vertices',v_pos,'FaceVertexCData',Cmap_pos,'EdgeColor','none','FaceColor','interp','FaceLighting','phong','backfacelight','unlit');
% light('Position',[1,1,1]);
% light('Position',[-1,-1,1]);
% light('Position',[-1,-1,-1]);
% light('Position',[1,1,-1]);
% material dull;
% colorbar
% subplot(1,2,2)
% axis equal
% patch('Faces',fu,'Vertices',v_neg,'FaceVertexCData',Cmap_neg,'EdgeColor','none','FaceColor','interp','FaceLighting','phong','backfacelight','unlit');
% light('Position',[1,1,1]);
% light('Position',[-1,-1,1]);
% light('Position',[-1,-1,-1]);
% light('Position',[1,1,-1]);
% material dull;
% set(gcf,'Position',[0 100 850 600]);
% colorbar
