% BrainStorm Toolbox
% Version 2.0 (Alpha) 02-Nov-2004
% Contents Generated by make_contents on 02-Nov-2004 14:31:32
%
% Files Sorted first by Category, then alphabetical, listed with first help line.
% A * indicates the H1 line begins with the filename.
%
% Category: Data Processing
%
%  bst_extractmarkersctf.m * - Extract signal block from a .ds CTF data set
%  bst_readmarkerfilectf.m * - read_markerf reads the CTF markerfile MarkerFile.mrk
%  covariance_plots.fig    GUI figure for covariance_plots.m
%  covariance_plots.m      * - M-file for covariance_generator, covariance_plots
%  ds2brainstorm.m         * - Convert a DS CTF dataset into BrainStorm format
%  eeg2bs.m                * - (fnamein,fnameout,type,channel)
%  extract_channels.m      * - Extract the channels to be used in this particular run
%  extract_ctf_markers.m   * - Extract signal block from a .ds CTF data set based on the Markers information in the Markerfile
%  load_fif_apos.m         * - Load in position information from Neuromag 122 ".apos" file
%  load_fif_asc.m          * - Load data from Neuromag 122 .fif file converted to ascii
%  load_smf.m              * - Load a simply written SMF file into the faces vertices structure
%  meg4write.m             * - WRITE CTF MEG4 file format
%  mesh2brainstorm.m       * - Import .mesh tessellation files (BrainVisa interchange)
%  readdsgl.m              * - Loads a BrainSuite .dsgl format tessellation file.
%  readmarkerfile_ctf.m    * - Read marker information from CTF MarkerFile.mrk
%  save_smf.m              * - Save out a file in a simple form of the SMF format
%  tri2brainstorm.m        * - Read .tri file into BrainStorm format
%
% Category: Database Management
%
%  browse_study_folder.m          * - Find all *brainstormstudy.mat files in a directory tree
%  eeg_load_scan3avg.m            * - Read a NeuroScan 3.x AVG File
%  elpos2bs.m                     * - this function converts electrode position files into BrainStorm Channel format
%  find_mfiles.m                  * - Find m-files that open a particular figure handle or the GCF
%  help_manager.fig               GUI figure for help_manager.m, bst_static_taskbar.m
%  help_manager.m                 * - Application M-file for help_manager.fig
%  load_brainstorm_file.m         * - load or try to find and load the BrainStorm file.
%  make_default_database.m        * - Confirm or Create a default database, default study, default subject
%  make_default_study.m           * - Create simulated default data and link to a simulated subject
%  make_default_subject.m         * - Make a brainstormsubject and simulated MRI in a folder
%  phantom_channel_assignment.fig GUI figure for phantom_channel_assignment.m, tess_align_tool.m
%  phantom_channel_assignment.m   * - Application M-file for phantom_channel_assignment.fig
%  read_besa.m                    * - (overwrite succinct one line summary here)
%
% Category: Forward Modeling
%
%  bem_gain.m                 * - Computes the EEG/MEG forward/gain matrix associated with a set of grid points 
%  bem_kernel.m               * - computes kernel matrices for EEG and MEG
%  bem_xfer.m                 * - Computation of the MEG and/or EEG BEM transfer matrices
%  berg.m                     * - PARAMETER CALCULATION FOR EEG MULTILAYER SPHERICAL FORWARD MODEL (berg.m)
%  bestfitsph.m               * - Find best fitting sphere
%  bst_headmodeler.m          * - Solution to the MEG/EEG forward problem
%  carto_sensors.m            * - (Rcoils,v);
%  eeg_bem.m                  * - Calculate the electric potential , BEM approach, arbitrary orientation
%  eeg_sph.m                  * - Calculate the electric potential , spherical head, arbitrary orientation
%  gain_interp.m              * - Gain matrix interpolation from a set of pre-computed forward fields defined over grid points in 3D space
%  get_gain.m                 * - Get a set of source foward fields from a .bin gain matrix file
%  good_channel.m             * - Extract channels of a given type
%  gridmaker.m                * - 3D regular gridding of surface envelope
%  hrow_linear.m              * - Compute row in BEM geometry matrix for linear collocation
%  kl_galerkin.m              * - Galerking kernel for BEM of linear model
%  kl_gram.m                  * - Kernel computation used in bem_xfer
%  meg_bem.m                  * - Calculate the mag field, BEM approach, arbitrary orientation
%  os_meg.m                   * - Calculate the (overlapping) sphere models for MEG
%  overlapping_sphere.m       * - Create overlapping spheres for E/MEG channels.
%  overlapping_sphere_fmins.m * - for use with OVERLAPPING_SPHERE
%  read_gain.m                * - Extract parts or a compete gain matrix from .bin binay gain file 
%  sensor_122.m               * - Return the Neuromag 122 information
%  sensor_axial.m             * - Generate axial gradiometers
%  sensor_planar.m            * - Generate planar gradiometers
%  sensor_ring.m              * - Generate rings of sensors about a sphere roughly uniformly spaced.
%  sensor_spacing.m           * - generate sites roughly evenly spaced about a hemisphere.
%  solid_angle2.m             * - Solid angle of a viewed triangle
%  source_grid.m              * - generate variable grid of possible source locations
%  source_grids.m             * - Generate source grids for parametric model searches
%  source_tess.m              * - generate variable grid of possible source locations
%  tesselate.m                * - tesselate based on the sensor_ring program
%  trans_matrix.m             * - calculate BEM transfer matrices for EEG and MEG
%  tri_interp.m               * - Compute the interpolation matrix from a cortical tessellation to the MRI volume
%  weighting_scalar.m         * - For use with Overlapping Sphere
%  zhang_fit.m                * - Compute 'Berg' parameters for EEG multilayer sphere
%
% Category: GUI and Related
%
%  bem_param_select.fig           GUI figure for headmodeler_gui.m
%  bst_color_scheme.m             * - apply the BrainStorm color, font, size scheme to the figure
%  bst_layout.m                   * - Manage all BST windows in a standard layout
%  bst_message_window.fig         GUI figure for bst_message_window.m, avw2brainstorm.m, bem_gain.m, and others
%  bst_message_window.m           * - Application M-file for bst_message_window.fig, with NON CALLBACKS
%  bst_splashscreen.fig           GUI figure for bst_splashscreen.m, bst_static_taskbar.m
%  bst_splashscreen.m             * - GUI app for license information and agreement
%  bst_static_taskbar.fig         GUI figure for bst_static_taskbar.m, bst_wavedata_display.m, data_manager.m, and others
%  bst_static_taskbar.m           * - BrainStorm's primary taskbar always visible
%  bst_win_manager.m              * - GUI Window management for BrainStorm
%  channel_select.fig             GUI figure for dataplot_cb.m
%  data_manager.fig               GUI figure for data_manager.m, bst_static_taskbar.m, extract_channels.m, and others
%  data_manager.m                 * - Edit/select database, subjects, studies, datasets, build headmodels, import data.
%  data_selector_cb.m             * - Callback function to setup and execute inverse techniques
%  database_manager.fig           GUI figure for database_manager.m, data_manager.m
%  database_manager.m             * - GUI to edit the User Databases and select one
%  dataplot.fig                   GUI figure for bst_imaging_display.m, bst_static_taskbar.m, bst_wavedata_display.m, and others
%  dataplot_cb.m                  * - : Callback switchyard for the DATAViewer Tool
%  file_selection_win.fig         GUI figure for file_selection_win.m, bst_mriviewer.m, dataplot_cb.m, and others
%  file_selection_win.m           * - Application M-file for file_selection_win.fig
%  generic_listbox_win.fig        GUI figure for importdata.m, subject_editor.m
%  headmodeler_gui.fig            GUI figure for headmodeler_gui.m, bst_static_taskbar.m, data_manager.m, and others
%  headmodeler_gui.m              * - Application M-file to build head models
%  importdata.fig                 GUI figure for importdata.m, data_manager.m, ds2brainstorm.m, and others
%  importdata.m                   * - Case Switchyard for importing data from major MEG and EEG systems
%  layout_manager.fig             GUI figure for layout_manager.m, bst_static_taskbar.m
%  layout_manager.m               * - Application M-file to manage the window layout
%  least_squares_parameters.fig   GUI figure for data_selector_cb.m, least_squares_parameters_cb.m, parametric_estimation.m
%  listbox_win.fig                GUI figure for importdata.m, subject_editor.m
%  listchan.fig                   GUI figure for dataplot_cb.m
%  logobrainstorm.jpg             Figure file
%  makeuswait.m                   * - change the figure pointer according to action
%  map_single.fig                 GUI figure for dataplot_cb.m
%  mri_parameters.fig             GUI figure for mri_parameters.m, bst_mriviewer.m
%  mri_parameters.m               * - Application M-file for mri_parameters.fig
%  nowzooming.m                   * - WindownButtonDownFcn callbcak for zooming within BST_MRIVIEWER 
%  pcs_params.fig                 GUI figure for pcs_params.m, bst_mriviewer.m, mri_read_tool.m
%  pcs_params.m                   * - Application M-file to set the parameters of the patient coordinates
%  set_dataviewing_parameters.fig GUI figure for dataplot_cb.m
%  simulator.fig                  GUI figure for simulator.m, bst_static_taskbar.m, make_default_study.m, and others
%  simulator.m                    * - Application M-file for simulator.fig
%  simulator_mri.fig              GUI figure for simulator_mri.m, bst_static_taskbar.m, make_default_subject.m
%  simulator_mri.m                * - Application M-file to make a simulated spherical MRI
%  study_editor.fig               GUI figure for study_editor.m, data_manager.m, importdata.m
%  study_editor.m                 * - GUI to edit the BrainStorm Study information, case switchyard
%  subject_editor.fig             GUI figure for subject_editor.m, bst_static_taskbar.m, data_manager.m, and others
%  subject_editor.m               * - GUI to edit the BrainStorm Subject information, case switchyard
%  tess_align_tool.fig            GUI figure for tess_align_tool.m, subject_editor.m
%  tess_align_tool.m              * - Application M-file for tess_align_tool.fig
%  tessellation_window.fig        GUI figure for bst_imaging_display.m, dataplot_cb.m, manage_corticalscouts.m, and others
%  zscore_gui.fig                 GUI figure for zscore_gui.m, dataplot_cb.m
%  zscore_gui.m                   * - : management of zscore visualization
%
% Category: Help
%
%  contents.m                               This Contents File
%  help_data_bststudy.m                     * - Information on database files of type 'bststudy'
%  help_data_bstsubject.m                   * - Information on database files of type 'bstsubject'
%  help_data_channel.m                      * - Information on database files of type 'channel'
%  help_data_data.m                         * - Information on database files of type 'data'
%  help_data_headmodel.m                    * - Information on database files of type 'headmodel'
%  help_data_image.m                        * - Information on database files of type 'image'
%  help_data_raw.m                          * - Information on database files of type 'raw'
%  help_data_results.m                      * - Information on database files of type 'results'
%  help_data_tess.m                         * - Information on database files of type 'tess'
%  help_data_triconn.m                      * - Information on database files of type 'triconn'
%  help_data_vertconn.m                     * - Information on database files of type 'vertconn'
%  help_database_list.m                     * - Explain the database used by BrainStorm
%  help_editing_brainstorm.m                * - Information on how to update and edit your version of BrainStorm
%  help_fig_bem_param_select.m              * - Information on figure file 'bem_param_select'
%  help_fig_bst_message_window.m            * - Information on figure file 'bst_message_window'
%  help_fig_bst_splashscreen.m              * - Information on figure file 'bst_splashscreen'
%  help_fig_bst_static_taskbar.m            * - Information on figure file 'bst_static_taskbar'
%  help_fig_channel_select.m                * - Information on figure file 'channel_select'
%  help_fig_chi_pdf_fit.m                   * - Information on figure file 'chi_pdf_fit'
%  help_fig_covariance_generator.m          * - Information on figure file 'covariance_generator'
%  help_fig_covariance_plots.m              * - Information on figure file 'covariance_plots'
%  help_fig_data_manager.m                  * - Information on figure file 'data_manager'
%  help_fig_data_selector.m                 * - Information on figure file 'data_selector'
%  help_fig_database_manager.m              * - Information on figure file 'database_manager'
%  help_fig_dataplot.m                      * - Information on figure file 'dataplot'
%  help_fig_generic_listbox_win.m           * - Information on figure file 'generic_listbox_win'
%  help_fig_headmodeler_gui.m               * - Information on figure file 'headmodeler_gui'
%  help_fig_help_manager.m                  * - Information on figure file 'help_manager'
%  help_fig_importdata.m                    * - Information on figure file 'importdata'
%  help_fig_layout_manager.m                * - Information on figure file 'layout_manager'
%  help_fig_least_squares_parameters.m      * - Information on figure file 'least_squares_parameters'
%  help_fig_listbox_win.m                   * - Information on figure file 'listbox_win'
%  help_fig_listchan.m                      * - Information on figure file 'listchan'
%  help_fig_manage_corticalscouts.m         * - Information on figure file 'manage_corticalscouts'
%  help_fig_map_single.m                    * - Information on figure file 'map_single'
%  help_fig_mapping.m                       * - Information on figure file 'mapping'
%  help_fig_markers_select.m                * - Information on figure file 'markers_select'
%  help_fig_minnorm_parameters.m            * - Information on figure file 'minnorm_parameters'
%  help_fig_mri_read_tool.m                 * - Information on figure file 'mri_read_tool'
%  help_fig_mri_scan_params.m               * - Information on figure file 'mri_scan_params'
%  help_fig_mribox.m                        * - Information on figure file 'mribox'
%  help_fig_parametric_estimation.m         * - Information on figure file 'parametric_estimation'
%  help_fig_pcs_params.m                    * - Information on figure file 'pcs_params'
%  help_fig_rap_music_parameters.m          * - Information on figure file 'rap_music_parameters'
%  help_fig_rap_parameters.m                * - Information on figure file 'rap_parameters'
%  help_fig_results_time_series.m           * - Information on figure file 'results_time_series'
%  help_fig_results_update_gui.m            * - Information on figure file 'results_update_gui'
%  help_fig_results_visualization.m         * - Information on figure file 'results_visualization'
%  help_fig_select_folder.m                 * - Information on figure file 'select_folder'
%  help_fig_set_dataviewing_parameters.m    * - Information on figure file 'set_dataviewing_parameters'
%  help_fig_set_sourceviewing_parameters.m  * - Information on figure file 'set_sourceviewing_parameters'
%  help_fig_show_signal_decomposition.m     * - Information on figure file 'show_signal_decomposition'
%  help_fig_simulator.m                     * - Information on figure file 'simulator'
%  help_fig_simulator_mri.m                 * - Information on figure file 'simulator_mri'
%  help_fig_sourceimaging.m                 * - Information on figure file 'sourceimaging'
%  help_fig_sourceimaging_parameters.m      * - Information on figure file 'sourceimaging_parameters'
%  help_fig_study_editor.m                  * - Information on figure file 'study_editor'
%  help_fig_subject_editor.m                * - Information on figure file 'subject_editor'
%  help_fig_taskbar.m                       * - Information on figure file 'taskbar'
%  help_fig_tessellation_handler.m          * - Information on figure file 'tessellation_handler'
%  help_fig_tessellation_select.m           * - Information on figure file 'tessellation_select'
%  help_fig_tessellation_window.m           * - Information on figure file 'tessellation_window'
%  help_fig_timeseries.m                    * - Information on figure file 'timeseries'
%  help_fig_view_manager.m                  * - Information on figure file 'view_manager'
%  help_fig_visu_maps.m                     * - Information on figure file 'visu_maps'
%  help_fig_wave_single.m                   * - Information on figure file 'wave_single'
%  help_fig_web_pages.m                     * - Information on figure file 'web_pages'
%  help_fig_zscore_gui.m                    * - Information on figure file 'zscore_gui'
%  help_figure_list.m                       * - Explain the figures used by BrainStorm
%  help_pref_currentdata.m                  * - Preference information on structure of 'CurrentData'
%  help_pref_dateofagreement.m              * - Preference information on structure of 'DateofAgreement'
%  help_pref_defaultsubject.m               * - Preference information on structure of 'DefaultSubject'
%  help_pref_iuserdatabase.m                * - Preference information on structure of 'iUserDataBase'
%  help_pref_layout.m                       * - Preference information on structure of 'Layout'
%  help_pref_studies.m                      * - Preference information on structure of 'Studies'
%  help_pref_studysubject.m                 * - Preference information on structure of 'StudySubject'
%  help_pref_subjects.m                     * - Preference information on structure of 'Subjects'
%  help_pref_usercurrentdata.m              * - Preference information on structure of 'UserCurrentData'
%  help_pref_userdatabase.m                 * - Preference information on structure of 'UserDataBase'
%  help_pref_version.m                      * - Preference information on structure of 'Version'
%  help_preference_list.m                   * - Explain the preferences used by BrainStorm
%  montreal_data_create.m                   * - Read landmarks from the Montreal Phantom and create simulated data
%  multidipole_simulation_eeg_data_create.m  MONTREAL_DATA_CREATE - Create simulated EEG data using EGI array
%  readme.m                                 * - What's New in Each Revision of BrainStorm 2.0 (Alpha)
%
% Category: Inverse Modeling
%
%  bst_sourceimaging.m              * - Command line call to source imaging routines
%  bstscript_ForwardInverse_basic.m * - Basic Head Modelling and Source Imaging BrainStorm Script
%  data_selector.fig                GUI figure for bst_sourceimaging.m, data_selector_cb.m, parametric_estimation.m
%  lcmvbf.fig                       GUI figure for lcmvbf.m, bst_sourceimaging.m, dataplot_cb.m
%  lcmvbf.m                         * - Spatial filtering solution as called from command line or BST_SOURCEIMAGING.M
%  least_squares_fit.m              * - multiple dipole fit using fminsearch
%  least_squares_parameters_cb.m    * - least_squares GUI setup and execution
%  minnorm.m                        * - Mininum norm solution as called from command line or BST_SOURCEIMAGING.M
%  minnorm_parameters_cb.m          * - Minimum Norm GUI setup and execution
%  muopt.m                          * - Quasi-optimality criterion for choosing the regularization parameter.
%  parametric_estimation.fig        GUI figure for parametric_estimation.m, bst_static_taskbar.m, dataplot_cb.m, and others
%  parametric_estimation.m          * - GUI for selecting data segments and subspaces prior to estimation
%  rap_music_parameters.fig         GUI figure for rap_music_parameters.m, bst_static_taskbar.m, dataplot_cb.m, and others
%  rap_music_parameters.m           * - Application M-file for rap_music_parameters.fig
%  rapmusic_gui.m                   * - Execute RAPMUSIC using GUI inputs, BrainStorm MMII version
%  regcheck.m                       * - Check the regularization tag
%  regsubspace.m                    * - Determine the subspace based on the regularization method
%  subcorr_gui.m                    * - Subcorr function custom to the gui features
%
% Category: Utility - General
%
%  avw2brainstorm.m            * - : Converts an AVW MRI structure (from D. Weber's EEGToolbox) to BRAINSTORM MRI format
%  brainstorm.m                * - Go to the BrainStorm home web page
%  brainstorm_reset.m          * - Clear Matlab BrainStorm preferences, remove default data
%  dip.m                       * - UNKNOWN, move to archive?
%  engstr.m                    * - create a string for the number in engineering format
%  find_brainstorm_files.m     * - Find BrainStorm subjects or study files, create Menu
%  find_brainstorm_structure.m * - Find all of the available files with a subject or study
%  find_subdir.m               * - Find all subdirectories in a BrainStorm path
%  genpath2cell.m              * - convert path or generated path string into cell array
%  get_channel.m               * - Get the Channel information associated with a particular data file
%  get_user_directory.m        * - Get the user's root directory information
%  ginput2.m                   * - Graphical input from mouse.
%  grayish.m                   * - % gray out the lower end of a spectrum for less severe palette
%  load_raw.m                  * - Read a BrainStorm "raw" format (.txt or .raw) matrix
%  make_contents.mat           Mat-file
%  mby3check.m                 * - Check to see if matrix is m by 3 or 3 by m.
%  mby6check.m                 * - Check to see if matrix is m by 6 or 6 by m.
%  meg4read.m                  * - READ CTF MEG4 file format
%  mutincomp.m                 * - Mutual incompatibility among checkboxes and radiobuttons
%  norcol.m                    * - (French) squared sum of each column in a matrix
%  norlig.m                    * - (French) Norm of the rows of a matrix
%  offset.m                    * - each column in inmat such that a plot(outmat) looks good.
%  qslim.m                     * - Mesh simplification, wrapper function for Garland's QSLIM executable program
%  read_ctf_mri.m              * - Read CTF MRI format (Version 2.1)
%  readdfs.m                   * - (overwrite succinct one line summary here)
%  readRaw.m                   * - Reads an EGI epoch-marked simple binary format (epoch-marked raw format) file.
%  save_fieldnames.m           * - Save just the fieldnames of a structure to a mat-file
%  save_raw.m                  * - Save out a matrix in BrainStorm "raw" format, based on extension
%  select_folder.fig           GUI figure for select_folder.m, database_manager.m
%  select_folder.m             * - Application M-file for bst_SelectFolder.fig
%  str2mat0.m                  * - (Deprecated) Form text matrix from individual strings.
%  str_repeater.m              * - Repeat string format and separator to display data
%  vec.m                       * - Lexicographical ordering of a matrix, A(:).
%  web_pages.fig               GUI figure for web_pages.m, bst_static_taskbar.m
%  web_pages.m                 * - Listbox of relevant BrainStorm web pages and email addresses
%  windclf.m                   * - Reset and clear the figure, retaining the NAME property
%  windfind.m                  * - Find or create a particular window using it's NAME property
%
% Category: Utility - Numeric
%
%  aic_mdl.m                * - Calculate Information Theoretic Criteria for data dimensionality
%  blk_diag.m               * - Make or extract a sparse block diagonal matrix
%  blk_lex.m                * - Lexicographically order the submatrices in A
%  brainstorm_filt.m        * - Zero-phase filter dedicated to multi-channel MEG and EEG data
%  carto_sph.m              * - (sensloc,v,center)
%  chi_pdf_fit.fig          GUI figure with unknown calls
%  closest.m                * - Find point in one array closest to point in another array
%  colnorm.m                * - Calculate L2 norm for each column of a matrix and normalize
%  covariance_generator.fig GUI figure with unknown calls
%  cross_mat.m              * - Sparse cross product matrix good for matrix equivalent operation
%  crossprod.m              * - Cross product between two sets, each set with three columns
%  dist_sph.m               * - FMINS distance function used to minimize the fit to a sphere
%  dlegpoly.m               * - Evaluate the first N Legendre polynomials
%  dotprod.m                * - Dot product of two vectors (deprecated)
%  embedding.m              * - computing the approximate embedding surface
%  fidufit.m                * - (overwrite succinct one line summary here)
%  findclosest.m            * - Find entries of closest elements between two vectors 
%  fronorm.m                * - Fast calculation of the Frobenius Norm of a Matrix
%  hanning_window.m         * - Calculate the hanning window function for n points
%  inorcol.m                * - Compute the (pseudo)inverse of the column norms of matrix Mat
%  modulo.m                 * - Compute the modulo
%  mri2scs.m                * - Compute the transform to move form the MRI coordinate system (in mm) to the SCS 
%  ray_intersect.m          * - find intersection of a ray with a set of faces
%  rownorm.m                * - Calculate the L2 norm of each row of a matrix
%  scs2mri.m                * - transform SCS point coordinates (in mm) to MRI coordinate system (in mm) 
%  shepards.m               * - (X,x,v,n); 3D nearest-neighbor interpolation using Shepard's weighting
%  sort_key.m               * - Sort with column keys
%  svd0.m                   * - Economy SVD in both U and V, S returned sparse diagonal
%  tessellation_stats.m     * - Calculate statistics of the tesselation and hunt for suspicious faces and vertices
%  transform.m              * - Transform coordinates between PCS and MRI
%  tri_area.m               * - Find areas of all triangles
%
% Category: Visualization
%
%  bst_imaging_display.m            * - : display utility for cortical distributed source imaging 
%  bst_mriviewer.fig                GUI figure for bst_mriviewer.m, bst_static_taskbar.m, dataplot_cb.m, and others
%  bst_mriviewer.m                  * - Application M-file for bst_mriviewer.fig
%  bst_wavedata_display.m           * - Various ways of loooking at time series
%  c_activ.m                        * - Finding a colormap to code deepness and activation
%  catci.m                          * - computing color coding for activation on the vertices
%  contraste.m                      * - computing the colormap coding deepness
%  curvature_cortex.m               * - calculates cortex curvature
%  depthgauge.m                     * - Make a depthgauge for measuring depth
%  faces_connectivity.m             * - Generate the connections of faces to a vertex
%  filterGUI.fig                    GUI figure for filterGUI.m, dataplot_cb.m
%  filterGUI.m                      * - M-file for filterGUI.fig
%  ihot.mat                         Mat-file
%  interp_mail.m                    * - (French) Interpolate coordinates of the "maillage"
%  leaflet.m                        * - (overwrite succinct one line summary here)
%  leaflet.mat                      Mat-file
%  load_BsTMRI.m                    * - Load BrainStorm MRI format
%  manage_corticalscouts.fig        GUI figure for manage_corticalscouts.m, dataplot_cb.m
%  manage_corticalscouts.m          * - Application M-file for manage_corticalscouts.fig
%  mapping.fig                      GUI figure for bst_imaging_display.m, bst_mriviewer.m, bst_wavedata_display.m, and others
%  markers_select.fig               GUI figure with unknown calls
%  mri_read_tool.fig                GUI figure for mri_read_tool.m, bst_static_taskbar.m, make_default_subject.m, and others
%  mri_read_tool.m                  * - AOS Version Application M-file to read in MRI and manipulate
%  mribox.fig                       GUI figure for mritool_cb.m
%  mritool_cb.m                     * - OBSOLETE Switchyard corresponding to the OLDER MRITOOL GUI (mribox.fig)
%  patch_swell.m                    * - enlarge a patch by appending the next set of adjacent vertices
%  plot3d.m                         * - 'plot3' the given three column data
%  plot_dipole.m                    * - (r,n,s,c)
%  plot_patch.m                     * - plots a vertex or face and its neighbors
%  results_time_series.fig          GUI figure for results_time_series.m, rapmusic_gui.m
%  results_time_series.m            * - Application M-file for results_time_series.fig
%  results_update.m                 * - Update of display the source parameters and residuals while RAP-MUSIC or LS is running.
%  results_update_gui.fig           GUI figure for results_update.m
%  results_visualization.fig        GUI figure for results_visualization.m, bst_static_taskbar.m, rapmusic_gui.m, and others
%  results_visualization.m          * - Application M-file View the results of source modeling
%  separation.m                     * - Splitting the brain into 2 parts
%  set_sourceviewing_parameters.fig GUI figure for set_sourceviewing_parameters.m, dataplot_cb.m
%  set_sourceviewing_parameters.m   * - Application M-file for set_sourceviewing_parameters.fig
%  show_signal_decomposition.fig    GUI figure for show_signal_decomposition.m
%  show_signal_decomposition.m      * - Application M-file for show_signal_decomposition.fig
%  smooth_cortex.m                  * - Smoothes tesselation
%  sourceimaging.fig                GUI figure for sourceimaging.m, bst_sourceimaging.m, bst_static_taskbar.m, and others
%  sourceimaging.m                  * - Main switch to source imaging routines
%  sourceimaging_parameters.fig     GUI figure with unknown calls
%  tessellation_handler.fig         GUI figure for tessellation_handler.m, set_sourceviewing_parameters.m
%  tessellation_handler.m           * - : Basic Viewing of tessellation objects in BrainStorm format; GUI Manager
%  tessellation_outwards.m          * - Ensure that tessellation ordering is "outwards"
%  togglebuttoncolor.m              * - : change button color of toggle button
%  toggleface.m                     * - Toggle the faces and edges as invisible
%  togglelight.m                    * - toggle the lighting flat or phong
%  vertices_connectivity.m          * - Generate the connections between vertices
%  view_surface.m                   * - Convenient function to consistently plot surfaces
%  visu_maps.fig                    GUI figure with unknown calls
%  warp_everything_bst.m             WARP_EVERYTHING - (summary line here)
%  wave_single.fig                  GUI figure with unknown calls
%
% Category: All Alphabetical
%
%  aic_mdl.m                                * - Calculate Information Theoretic Criteria for data dimensionality
%  avw2brainstorm.m                         * - : Converts an AVW MRI structure (from D. Weber's EEGToolbox) to BRAINSTORM MRI format
%  bem_gain.m                               * - Computes the EEG/MEG forward/gain matrix associated with a set of grid points 
%  bem_kernel.m                             * - computes kernel matrices for EEG and MEG
%  bem_param_select.fig                     GUI figure for headmodeler_gui.m
%  bem_xfer.m                               * - Computation of the MEG and/or EEG BEM transfer matrices
%  berg.m                                   * - PARAMETER CALCULATION FOR EEG MULTILAYER SPHERICAL FORWARD MODEL (berg.m)
%  bestfitsph.m                             * - Find best fitting sphere
%  blk_diag.m                               * - Make or extract a sparse block diagonal matrix
%  blk_lex.m                                * - Lexicographically order the submatrices in A
%  brainstorm.m                             * - Go to the BrainStorm home web page
%  brainstorm_filt.m                        * - Zero-phase filter dedicated to multi-channel MEG and EEG data
%  brainstorm_reset.m                       * - Clear Matlab BrainStorm preferences, remove default data
%  browse_study_folder.m                    * - Find all *brainstormstudy.mat files in a directory tree
%  bst_cactivcmap.mat                       Mat-file
%  bst_color_scheme.m                       * - apply the BrainStorm color, font, size scheme to the figure
%  bst_extractmarkersctf.m                  * - Extract signal block from a .ds CTF data set
%  bst_headmodeler.m                        * - Solution to the MEG/EEG forward problem
%  bst_imaging_display.m                    * - : display utility for cortical distributed source imaging 
%  bst_layout.m                             * - Manage all BST windows in a standard layout
%  bst_message_window.fig                   GUI figure for bst_message_window.m, avw2brainstorm.m, bem_gain.m, and others
%  bst_message_window.m                     * - Application M-file for bst_message_window.fig, with NON CALLBACKS
%  bst_mriviewer.fig                        GUI figure for bst_mriviewer.m, bst_static_taskbar.m, dataplot_cb.m, and others
%  bst_mriviewer.m                          * - Application M-file for bst_mriviewer.fig
%  bst_readmarkerfilectf.m                  * - read_markerf reads the CTF markerfile MarkerFile.mrk
%  bst_sourceimaging.m                      * - Command line call to source imaging routines
%  bst_splashscreen.fig                     GUI figure for bst_splashscreen.m, bst_static_taskbar.m
%  bst_splashscreen.m                       * - GUI app for license information and agreement
%  bst_static_taskbar.fig                   GUI figure for bst_static_taskbar.m, bst_wavedata_display.m, data_manager.m, and others
%  bst_static_taskbar.m                     * - BrainStorm's primary taskbar always visible
%  bst_wavedata_display.m                   * - Various ways of loooking at time series
%  bst_win_manager.m                        * - GUI Window management for BrainStorm
%  bstscript_ForwardInverse_basic.m         * - Basic Head Modelling and Source Imaging BrainStorm Script
%  c_activ.m                                * - Finding a colormap to code deepness and activation
%  carto_sensors.m                          * - (Rcoils,v);
%  carto_sph.m                              * - (sensloc,v,center)
%  catci.m                                  * - computing color coding for activation on the vertices
%  channel_select.fig                       GUI figure for dataplot_cb.m
%  chi_pdf_fit.fig                          GUI figure with unknown calls
%  closest.m                                * - Find point in one array closest to point in another array
%  colnorm.m                                * - Calculate L2 norm for each column of a matrix and normalize
%  contents.m                               This Contents File
%  contraste.m                              * - computing the colormap coding deepness
%  covariance_generator.fig                 GUI figure with unknown calls
%  covariance_plots.fig                     GUI figure for covariance_plots.m
%  covariance_plots.m                       * - M-file for covariance_generator, covariance_plots
%  cpot.m                                   * - UNKNOWN, Send to Archive?
%  cross_mat.m                              * - Sparse cross product matrix good for matrix equivalent operation
%  crossprod.m                              * - Cross product between two sets, each set with three columns
%  curvature_cortex.m                       * - calculates cortex curvature
%  data_manager.fig                         GUI figure for data_manager.m, bst_static_taskbar.m, extract_channels.m, and others
%  data_manager.m                           * - Edit/select database, subjects, studies, datasets, build headmodels, import data.
%  data_selector.fig                        GUI figure for bst_sourceimaging.m, data_selector_cb.m, parametric_estimation.m
%  data_selector_cb.m                       * - Callback function to setup and execute inverse techniques
%  database_manager.fig                     GUI figure for database_manager.m, data_manager.m
%  database_manager.m                       * - GUI to edit the User Databases and select one
%  dataplot.fig                             GUI figure for bst_imaging_display.m, bst_static_taskbar.m, bst_wavedata_display.m, and others
%  dataplot_cb.m                            * - : Callback switchyard for the DATAViewer Tool
%  depthgauge.m                             * - Make a depthgauge for measuring depth
%  dip.m                                    * - UNKNOWN, move to archive?
%  dist_sph.m                               * - FMINS distance function used to minimize the fit to a sphere
%  dlegpoly.m                               * - Evaluate the first N Legendre polynomials
%  dotprod.m                                * - Dot product of two vectors (deprecated)
%  ds2brainstorm.m                          * - Convert a DS CTF dataset into BrainStorm format
%  eeg2bs.m                                 * - (fnamein,fnameout,type,channel)
%  eeg_bem.m                                * - Calculate the electric potential , BEM approach, arbitrary orientation
%  eeg_load_scan3avg.m                      * - Read a NeuroScan 3.x AVG File
%  eeg_sph.m                                * - Calculate the electric potential , spherical head, arbitrary orientation
%  elpos2bs.m                               * - this function converts electrode position files into BrainStorm Channel format
%  embedding.m                              * - computing the approximate embedding surface
%  engstr.m                                 * - create a string for the number in engineering format
%  extract_channels.m                       * - Extract the channels to be used in this particular run
%  extract_ctf_markers.m                    * - Extract signal block from a .ds CTF data set based on the Markers information in the Markerfile
%  faces_connectivity.m                     * - Generate the connections of faces to a vertex
%  fidufit.m                                * - (overwrite succinct one line summary here)
%  fidufit.mat                              Mat-file
%  file_selection_win.fig                   GUI figure for file_selection_win.m, bst_mriviewer.m, dataplot_cb.m, and others
%  file_selection_win.m                     * - Application M-file for file_selection_win.fig
%  filterGUI.fig                            GUI figure for filterGUI.m, dataplot_cb.m
%  filterGUI.m                              * - M-file for filterGUI.fig
%  find_brainstorm_files.m                  * - Find BrainStorm subjects or study files, create Menu
%  find_brainstorm_structure.m              * - Find all of the available files with a subject or study
%  find_mfiles.m                            * - Find m-files that open a particular figure handle or the GCF
%  find_subdir.m                            * - Find all subdirectories in a BrainStorm path
%  findclosest.m                            * - Find entries of closest elements between two vectors 
%  fronorm.m                                * - Fast calculation of the Frobenius Norm of a Matrix
%  gain_interp.m                            * - Gain matrix interpolation from a set of pre-computed forward fields defined over grid points in 3D space
%  generic_listbox_win.fig                  GUI figure for importdata.m, subject_editor.m
%  genpath2cell.m                           * - convert path or generated path string into cell array
%  geom100.mat                              Mat-file
%  get_channel.m                            * - Get the Channel information associated with a particular data file
%  get_gain.m                               * - Get a set of source foward fields from a .bin gain matrix file
%  get_user_directory.m                     * - Get the user's root directory information
%  ginput2.m                                * - Graphical input from mouse.
%  good_channel.m                           * - Extract channels of a given type
%  grayish.m                                * - % gray out the lower end of a spectrum for less severe palette
%  gridmaker.m                              * - 3D regular gridding of surface envelope
%  hanning_window.m                         * - Calculate the hanning window function for n points
%  headmodeler_gui.fig                      GUI figure for headmodeler_gui.m, bst_static_taskbar.m, data_manager.m, and others
%  headmodeler_gui.m                        * - Application M-file to build head models
%  help_data_bststudy.m                     * - Information on database files of type 'bststudy'
%  help_data_bstsubject.m                   * - Information on database files of type 'bstsubject'
%  help_data_channel.m                      * - Information on database files of type 'channel'
%  help_data_data.m                         * - Information on database files of type 'data'
%  help_data_headmodel.m                    * - Information on database files of type 'headmodel'
%  help_data_image.m                        * - Information on database files of type 'image'
%  help_data_raw.m                          * - Information on database files of type 'raw'
%  help_data_results.m                      * - Information on database files of type 'results'
%  help_data_tess.m                         * - Information on database files of type 'tess'
%  help_data_triconn.m                      * - Information on database files of type 'triconn'
%  help_data_vertconn.m                     * - Information on database files of type 'vertconn'
%  help_database_list.m                     * - Explain the database used by BrainStorm
%  help_editing_brainstorm.m                * - Information on how to update and edit your version of BrainStorm
%  help_fig_bem_param_select.m              * - Information on figure file 'bem_param_select'
%  help_fig_bst_message_window.m            * - Information on figure file 'bst_message_window'
%  help_fig_bst_splashscreen.m              * - Information on figure file 'bst_splashscreen'
%  help_fig_bst_static_taskbar.m            * - Information on figure file 'bst_static_taskbar'
%  help_fig_channel_select.m                * - Information on figure file 'channel_select'
%  help_fig_chi_pdf_fit.m                   * - Information on figure file 'chi_pdf_fit'
%  help_fig_covariance_generator.m          * - Information on figure file 'covariance_generator'
%  help_fig_covariance_plots.m              * - Information on figure file 'covariance_plots'
%  help_fig_data_manager.m                  * - Information on figure file 'data_manager'
%  help_fig_data_selector.m                 * - Information on figure file 'data_selector'
%  help_fig_database_manager.m              * - Information on figure file 'database_manager'
%  help_fig_dataplot.m                      * - Information on figure file 'dataplot'
%  help_fig_generic_listbox_win.m           * - Information on figure file 'generic_listbox_win'
%  help_fig_headmodeler_gui.m               * - Information on figure file 'headmodeler_gui'
%  help_fig_help_manager.m                  * - Information on figure file 'help_manager'
%  help_fig_importdata.m                    * - Information on figure file 'importdata'
%  help_fig_layout_manager.m                * - Information on figure file 'layout_manager'
%  help_fig_least_squares_parameters.m      * - Information on figure file 'least_squares_parameters'
%  help_fig_listbox_win.m                   * - Information on figure file 'listbox_win'
%  help_fig_listchan.m                      * - Information on figure file 'listchan'
%  help_fig_manage_corticalscouts.m         * - Information on figure file 'manage_corticalscouts'
%  help_fig_map_single.m                    * - Information on figure file 'map_single'
%  help_fig_mapping.m                       * - Information on figure file 'mapping'
%  help_fig_markers_select.m                * - Information on figure file 'markers_select'
%  help_fig_minnorm_parameters.m            * - Information on figure file 'minnorm_parameters'
%  help_fig_mri_read_tool.m                 * - Information on figure file 'mri_read_tool'
%  help_fig_mri_scan_params.m               * - Information on figure file 'mri_scan_params'
%  help_fig_mribox.m                        * - Information on figure file 'mribox'
%  help_fig_parametric_estimation.m         * - Information on figure file 'parametric_estimation'
%  help_fig_pcs_params.m                    * - Information on figure file 'pcs_params'
%  help_fig_rap_music_parameters.m          * - Information on figure file 'rap_music_parameters'
%  help_fig_rap_parameters.m                * - Information on figure file 'rap_parameters'
%  help_fig_results_time_series.m           * - Information on figure file 'results_time_series'
%  help_fig_results_update_gui.m            * - Information on figure file 'results_update_gui'
%  help_fig_results_visualization.m         * - Information on figure file 'results_visualization'
%  help_fig_select_folder.m                 * - Information on figure file 'select_folder'
%  help_fig_set_dataviewing_parameters.m    * - Information on figure file 'set_dataviewing_parameters'
%  help_fig_set_sourceviewing_parameters.m  * - Information on figure file 'set_sourceviewing_parameters'
%  help_fig_show_signal_decomposition.m     * - Information on figure file 'show_signal_decomposition'
%  help_fig_simulator.m                     * - Information on figure file 'simulator'
%  help_fig_simulator_mri.m                 * - Information on figure file 'simulator_mri'
%  help_fig_sourceimaging.m                 * - Information on figure file 'sourceimaging'
%  help_fig_sourceimaging_parameters.m      * - Information on figure file 'sourceimaging_parameters'
%  help_fig_study_editor.m                  * - Information on figure file 'study_editor'
%  help_fig_subject_editor.m                * - Information on figure file 'subject_editor'
%  help_fig_taskbar.m                       * - Information on figure file 'taskbar'
%  help_fig_tessellation_handler.m          * - Information on figure file 'tessellation_handler'
%  help_fig_tessellation_select.m           * - Information on figure file 'tessellation_select'
%  help_fig_tessellation_window.m           * - Information on figure file 'tessellation_window'
%  help_fig_timeseries.m                    * - Information on figure file 'timeseries'
%  help_fig_view_manager.m                  * - Information on figure file 'view_manager'
%  help_fig_visu_maps.m                     * - Information on figure file 'visu_maps'
%  help_fig_wave_single.m                   * - Information on figure file 'wave_single'
%  help_fig_web_pages.m                     * - Information on figure file 'web_pages'
%  help_fig_zscore_gui.m                    * - Information on figure file 'zscore_gui'
%  help_figure_list.m                       * - Explain the figures used by BrainStorm
%  help_manager.fig                         GUI figure for help_manager.m, bst_static_taskbar.m
%  help_manager.m                           * - Application M-file for help_manager.fig
%  help_pref_currentdata.m                  * - Preference information on structure of 'CurrentData'
%  help_pref_dateofagreement.m              * - Preference information on structure of 'DateofAgreement'
%  help_pref_defaultsubject.m               * - Preference information on structure of 'DefaultSubject'
%  help_pref_iuserdatabase.m                * - Preference information on structure of 'iUserDataBase'
%  help_pref_layout.m                       * - Preference information on structure of 'Layout'
%  help_pref_studies.m                      * - Preference information on structure of 'Studies'
%  help_pref_studysubject.m                 * - Preference information on structure of 'StudySubject'
%  help_pref_subjects.m                     * - Preference information on structure of 'Subjects'
%  help_pref_usercurrentdata.m              * - Preference information on structure of 'UserCurrentData'
%  help_pref_userdatabase.m                 * - Preference information on structure of 'UserDataBase'
%  help_pref_version.m                      * - Preference information on structure of 'Version'
%  help_preference_list.m                   * - Explain the preferences used by BrainStorm
%  hrow_linear.m                            * - Compute row in BEM geometry matrix for linear collocation
%  ihot.mat                                 Mat-file
%  importdata.fig                           GUI figure for importdata.m, data_manager.m, ds2brainstorm.m, and others
%  importdata.m                             * - Case Switchyard for importing data from major MEG and EEG systems
%  inorcol.m                                * - Compute the (pseudo)inverse of the column norms of matrix Mat
%  interp_mail.m                            * - (French) Interpolate coordinates of the "maillage"
%  kl_galerkin.m                            * - Galerking kernel for BEM of linear model
%  kl_gram.m                                * - Kernel computation used in bem_xfer
%  layout_manager.fig                       GUI figure for layout_manager.m, bst_static_taskbar.m
%  layout_manager.m                         * - Application M-file to manage the window layout
%  lcmvbf.fig                               GUI figure for lcmvbf.m, bst_sourceimaging.m, dataplot_cb.m
%  lcmvbf.m                                 * - Spatial filtering solution as called from command line or BST_SOURCEIMAGING.M
%  leaflet.m                                * - (overwrite succinct one line summary here)
%  leaflet.mat                              Mat-file
%  least_squares_fit.m                      * - multiple dipole fit using fminsearch
%  least_squares_parameters.fig             GUI figure for data_selector_cb.m, least_squares_parameters_cb.m, parametric_estimation.m
%  least_squares_parameters_cb.m            * - least_squares GUI setup and execution
%  listbox_win.fig                          GUI figure for importdata.m, subject_editor.m
%  listchan.fig                             GUI figure for dataplot_cb.m
%  load_brainstorm_file.m                   * - load or try to find and load the BrainStorm file.
%  load_BsTMRI.m                            * - Load BrainStorm MRI format
%  load_fif_apos.m                          * - Load in position information from Neuromag 122 ".apos" file
%  load_fif_asc.m                           * - Load data from Neuromag 122 .fif file converted to ascii
%  load_raw.m                               * - Read a BrainStorm "raw" format (.txt or .raw) matrix
%  load_smf.m                               * - Load a simply written SMF file into the faces vertices structure
%  logobrainstorm.jpg                       Figure file
%  make_contents.mat                        Mat-file
%  make_default_database.m                  * - Confirm or Create a default database, default study, default subject
%  make_default_study.m                     * - Create simulated default data and link to a simulated subject
%  make_default_subject.m                   * - Make a brainstormsubject and simulated MRI in a folder
%  makeuswait.m                             * - change the figure pointer according to action
%  manage_corticalscouts.fig                GUI figure for manage_corticalscouts.m, dataplot_cb.m
%  manage_corticalscouts.m                  * - Application M-file for manage_corticalscouts.fig
%  map_single.fig                           GUI figure for dataplot_cb.m
%  mapping.fig                              GUI figure for bst_imaging_display.m, bst_mriviewer.m, bst_wavedata_display.m, and others
%  markers_select.fig                       GUI figure with unknown calls
%  mby3check.m                              * - Check to see if matrix is m by 3 or 3 by m.
%  mby6check.m                              * - Check to see if matrix is m by 6 or 6 by m.
%  meg4read.m                               * - READ CTF MEG4 file format
%  meg4write.m                              * - WRITE CTF MEG4 file format
%  meg_bem.m                                * - Calculate the mag field, BEM approach, arbitrary orientation
%  mes.m                                    * - (overwrite succinct one line summary here)
%  mesh2brainstorm.m                        * - Import .mesh tessellation files (BrainVisa interchange)
%  minnorm.m                                * - Mininum norm solution as called from command line or BST_SOURCEIMAGING.M
%  minnorm_parameters_cb.m                  * - Minimum Norm GUI setup and execution
%  modulo.m                                 * - Compute the modulo
%  montreal_data_create.m                   * - Read landmarks from the Montreal Phantom and create simulated data
%  mri2scs.m                                * - Compute the transform to move form the MRI coordinate system (in mm) to the SCS 
%  mri_parameters.fig                       GUI figure for mri_parameters.m, bst_mriviewer.m
%  mri_parameters.m                         * - Application M-file for mri_parameters.fig
%  mri_read_tool.fig                        GUI figure for mri_read_tool.m, bst_static_taskbar.m, make_default_subject.m, and others
%  mri_read_tool.m                          * - AOS Version Application M-file to read in MRI and manipulate
%  mribox.fig                               GUI figure for mritool_cb.m
%  mritool_cb.m                             * - OBSOLETE Switchyard corresponding to the OLDER MRITOOL GUI (mribox.fig)
%  multidipole_simulation_eeg_data_create.m  MONTREAL_DATA_CREATE - Create simulated EEG data using EGI array
%  muopt.m                                  * - Quasi-optimality criterion for choosing the regularization parameter.
%  mutincomp.m                              * - Mutual incompatibility among checkboxes and radiobuttons
%  norcol.m                                 * - (French) squared sum of each column in a matrix
%  norlig.m                                 * - (French) Norm of the rows of a matrix
%  nowzooming.m                             * - WindownButtonDownFcn callbcak for zooming within BST_MRIVIEWER 
%  offset.m                                 * - each column in inmat such that a plot(outmat) looks good.
%  os_meg.m                                 * - Calculate the (overlapping) sphere models for MEG
%  overlapping_sphere.m                     * - Create overlapping spheres for E/MEG channels.
%  overlapping_sphere_fmins.m               * - for use with OVERLAPPING_SPHERE
%  parametric_estimation.fig                GUI figure for parametric_estimation.m, bst_static_taskbar.m, dataplot_cb.m, and others
%  parametric_estimation.m                  * - GUI for selecting data segments and subspaces prior to estimation
%  patch_swell.m                            * - enlarge a patch by appending the next set of adjacent vertices
%  pcs_params.fig                           GUI figure for pcs_params.m, bst_mriviewer.m, mri_read_tool.m
%  pcs_params.m                             * - Application M-file to set the parameters of the patient coordinates
%  phantom_channel_assignment.fig           GUI figure for phantom_channel_assignment.m, tess_align_tool.m
%  phantom_channel_assignment.m             * - Application M-file for phantom_channel_assignment.fig
%  pleg.m                                   * - Used in CPOT, Legendre polynomials
%  plot3d.m                                 * - 'plot3' the given three column data
%  plot_dipole.m                            * - (r,n,s,c)
%  plot_patch.m                             * - plots a vertex or face and its neighbors
%  prepfig.m                                * - Prepare figure
%  qslim.m                                  * - Mesh simplification, wrapper function for Garland's QSLIM executable program
%  rap_music_parameters.fig                 GUI figure for rap_music_parameters.m, bst_static_taskbar.m, dataplot_cb.m, and others
%  rap_music_parameters.m                   * - Application M-file for rap_music_parameters.fig
%  rapmusic_gui.m                           * - Execute RAPMUSIC using GUI inputs, BrainStorm MMII version
%  ray_intersect.m                          * - find intersection of a ray with a set of faces
%  read_besa.m                              * - (overwrite succinct one line summary here)
%  read_ctf_mri.m                           * - Read CTF MRI format (Version 2.1)
%  read_gain.m                              * - Extract parts or a compete gain matrix from .bin binay gain file 
%  readdfs.m                                * - (overwrite succinct one line summary here)
%  readdsgl.m                               * - Loads a BrainSuite .dsgl format tessellation file.
%  readmarkerfile_ctf.m                     * - Read marker information from CTF MarkerFile.mrk
%  readme.m                                 * - What's New in Each Revision of BrainStorm 2.0 (Alpha)
%  readRaw.m                                * - Reads an EGI epoch-marked simple binary format (epoch-marked raw format) file.
%  regcheck.m                               * - Check the regularization tag
%  regsubspace.m                            * - Determine the subspace based on the regularization method
%  results_time_series.fig                  GUI figure for results_time_series.m, rapmusic_gui.m
%  results_time_series.m                    * - Application M-file for results_time_series.fig
%  results_update.m                         * - Update of display the source parameters and residuals while RAP-MUSIC or LS is running.
%  results_update_gui.fig                   GUI figure for results_update.m
%  results_visualization.fig                GUI figure for results_visualization.m, bst_static_taskbar.m, rapmusic_gui.m, and others
%  results_visualization.m                  * - Application M-file View the results of source modeling
%  rownorm.m                                * - Calculate the L2 norm of each row of a matrix
%  save_fieldnames.m                        * - Save just the fieldnames of a structure to a mat-file
%  save_raw.m                               * - Save out a matrix in BrainStorm "raw" format, based on extension
%  save_smf.m                               * - Save out a file in a simple form of the SMF format
%  scs2mri.m                                * - transform SCS point coordinates (in mm) to MRI coordinate system (in mm) 
%  select_folder.fig                        GUI figure for select_folder.m, database_manager.m
%  select_folder.m                          * - Application M-file for bst_SelectFolder.fig
%  sensor_122.m                             * - Return the Neuromag 122 information
%  sensor_axial.m                           * - Generate axial gradiometers
%  sensor_planar.m                          * - Generate planar gradiometers
%  sensor_ring.m                            * - Generate rings of sensors about a sphere roughly uniformly spaced.
%  sensor_spacing.m                         * - generate sites roughly evenly spaced about a hemisphere.
%  separation.m                             * - Splitting the brain into 2 parts
%  set_dataviewing_parameters.fig           GUI figure for dataplot_cb.m
%  set_sourceviewing_parameters.fig         GUI figure for set_sourceviewing_parameters.m, dataplot_cb.m
%  set_sourceviewing_parameters.m           * - Application M-file for set_sourceviewing_parameters.fig
%  shepards.m                               * - (X,x,v,n); 3D nearest-neighbor interpolation using Shepard's weighting
%  show_signal_decomposition.fig            GUI figure for show_signal_decomposition.m
%  show_signal_decomposition.m              * - Application M-file for show_signal_decomposition.fig
%  simulator.fig                            GUI figure for simulator.m, bst_static_taskbar.m, make_default_study.m, and others
%  simulator.m                              * - Application M-file for simulator.fig
%  simulator_mri.fig                        GUI figure for simulator_mri.m, bst_static_taskbar.m, make_default_subject.m
%  simulator_mri.m                          * - Application M-file to make a simulated spherical MRI
%  smooth_cortex.m                          * - Smoothes tesselation
%  solid_angle2.m                           * - Solid angle of a viewed triangle
%  sort_key.m                               * - Sort with column keys
%  source_grid.m                            * - generate variable grid of possible source locations
%  source_grids.m                           * - Generate source grids for parametric model searches
%  source_tess.m                            * - generate variable grid of possible source locations
%  sourceimaging.fig                        GUI figure for sourceimaging.m, bst_sourceimaging.m, bst_static_taskbar.m, and others
%  sourceimaging.m                          * - Main switch to source imaging routines
%  sourceimaging_parameters.fig             GUI figure with unknown calls
%  sph_rphtestgrid2.mat                     Mat-file
%  sph_rphtestgrid3.mat                     Mat-file
%  str2mat0.m                               * - (Deprecated) Form text matrix from individual strings.
%  str_repeater.m                           * - Repeat string format and separator to display data
%  study_editor.fig                         GUI figure for study_editor.m, data_manager.m, importdata.m
%  study_editor.m                           * - GUI to edit the BrainStorm Study information, case switchyard
%  subcorr_gui.m                            * - Subcorr function custom to the gui features
%  subject_editor.fig                       GUI figure for subject_editor.m, bst_static_taskbar.m, data_manager.m, and others
%  subject_editor.m                         * - GUI to edit the BrainStorm Subject information, case switchyard
%  surf2vol_interp.m                        * - (overwrite succinct one line summary here)
%  svd0.m                                   * - Economy SVD in both U and V, S returned sparse diagonal
%  tess_align_tool.fig                      GUI figure for tess_align_tool.m, subject_editor.m
%  tess_align_tool.m                        * - Application M-file for tess_align_tool.fig
%  tesselate.m                              * - tesselate based on the sensor_ring program
%  tessellation_handler.fig                 GUI figure for tessellation_handler.m, set_sourceviewing_parameters.m
%  tessellation_handler.m                   * - : Basic Viewing of tessellation objects in BrainStorm format; GUI Manager
%  tessellation_outwards.m                  * - Ensure that tessellation ordering is "outwards"
%  tessellation_stats.m                     * - Calculate statistics of the tesselation and hunt for suspicious faces and vertices
%  tessellation_window.fig                  GUI figure for bst_imaging_display.m, dataplot_cb.m, manage_corticalscouts.m, and others
%  togglebuttoncolor.m                      * - : change button color of toggle button
%  toggleface.m                             * - Toggle the faces and edges as invisible
%  togglelight.m                            * - toggle the lighting flat or phong
%  toolbox_cross_ref.mat                    Mat-file
%  trans_matrix.m                           * - calculate BEM transfer matrices for EEG and MEG
%  transform.m                              * - Transform coordinates between PCS and MRI
%  tri2brainstorm.m                         * - Read .tri file into BrainStorm format
%  tri_area.m                               * - Find areas of all triangles
%  tri_interp.m                             * - Compute the interpolation matrix from a cortical tessellation to the MRI volume
%  vec.m                                    * - Lexicographical ordering of a matrix, A(:).
%  vertices_connectivity.m                  * - Generate the connections between vertices
%  view_surface.m                           * - Convenient function to consistently plot surfaces
%  visu_maps.fig                            GUI figure with unknown calls
%  warp_everything_bst.m                     WARP_EVERYTHING - (summary line here)
%  wave_single.fig                          GUI figure with unknown calls
%  web_pages.fig                            GUI figure for web_pages.m, bst_static_taskbar.m
%  web_pages.m                              * - Listbox of relevant BrainStorm web pages and email addresses
%  weighting_scalar.m                       * - For use with Overlapping Sphere
%  windclf.m                                * - Reset and clear the figure, retaining the NAME property
%  windfind.m                               * - Find or create a particular window using it's NAME property
%  zhang_fit.m                              * - Compute 'Berg' parameters for EEG multilayer sphere
%  zscore_gui.fig                           GUI figure for zscore_gui.m, dataplot_cb.m
%  zscore_gui.m                             * - : management of zscore visualization
%
% Category: Unknown Category
%
%  bst_cactivcmap.mat    Mat-file
%  fidufit.mat           Mat-file
%  geom100.mat           Mat-file
%  sph_rphtestgrid2.mat  Mat-file
%  sph_rphtestgrid3.mat  Mat-file
%  toolbox_cross_ref.mat Mat-file
%
% Category: Missing in Toolbox
%
%  No files in this category
%
% Category: Archive
%
%  cpot.m            * - UNKNOWN, Send to Archive?
%  mes.m             * - (overwrite succinct one line summary here)
%  pleg.m            * - Used in CPOT, Legendre polynomials
%  prepfig.m         * - Prepare figure
%  surf2vol_interp.m * - (overwrite succinct one line summary here)

%<autobegin> ---------------------- 02-Nov-2004 14:32:29 -----------------------
% --------- Automatically Generated Comments Block Using AUTO_COMMENTS ---------
%
% CATEGORY: Help
%
% At Check-in: $Author: Mosher $  $Revision: 63 $  $Date: 11/02/04 2:33p $
%
% This software is part of BrainStorm Toolbox Version 2.0 (Alpha) 29-Oct-2004
% 
% Principal Investigators and Developers:
% ** Richard M. Leahy, PhD, Signal & Image Processing Institute,
%    University of Southern California, Los Angeles, CA
% ** John C. Mosher, PhD, Biophysics Group,
%    Los Alamos National Laboratory, Los Alamos, NM
% ** Sylvain Baillet, PhD, Cognitive Neuroscience & Brain Imaging Laboratory,
%    CNRS, Hopital de la Salpetriere, Paris, France
% 
% See BrainStorm website at http://neuroimage.usc.edu for further information.
% 
% Copyright (c) 2004 BrainStorm by the University of Southern California
% This software distributed  under the terms of the GNU General Public License
% as published by the Free Software Foundation. Further details on the GPL
% license can be found at http://www.gnu.org/copyleft/gpl.html .
% 
% FOR RESEARCH PURPOSES ONLY. THE SOFTWARE IS PROVIDED "AS IS," AND THE
% UNIVERSITY OF SOUTHERN CALIFORNIA AND ITS COLLABORATORS DO NOT MAKE ANY
% WARRANTY, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO WARRANTIES OF
% MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, NOR DO THEY ASSUME ANY
% LIABILITY OR RESPONSIBILITY FOR THE USE OF THIS SOFTWARE.
%<autoend> ------------------------ 02-Nov-2004 14:32:29 -----------------------

