function Cmap=contraste(v,v_pos,v_neg,connectivity_cell,I_pos,I_neg,prop_thres,ref_map)
%CONTRASTE - computing the colormap coding deepness
% function Cmap=contraste(v,v_pos,v_neg,connectivity_cell,I_pos,I_neg,prop_thres,ref_map)
%
%  computing the colormap coding deepness
%
%  inputs : v : vertices, v_pos : vertices of the positive part, v_neg : vertices of the negative part,
%           connectivity_cell : result of vertices_connectivity, I_pos/I_neg : indices of positive/negative part of the brain
%           prop_thres : percentage of gyri and sulci, ref_map : colors of gyri and sulci
%  output : Cmap : colormap codind deepness on the vertices
%

%<autobegin> ---------------------- 26-May-2004 11:29:54 -----------------------
% --------- Automatically Generated Comments Block Using AUTO_COMMENTS ---------
%
% CATEGORY: Visualization
%
% Alphabetical list of external functions (non-Matlab):
%   toolbox\embedding.m
%
% At Check-in: $Author: Mosher $  $Revision: 14 $  $Date: 5/26/04 9:59a $
%
% This software is part of BrainStorm Toolbox Version 2.0 (Alpha) 24-May-2004
% 
% Principal Investigators and Developers:
% ** Richard M. Leahy, PhD, Signal & Image Processing Institute,
%    University of Southern California, Los Angeles, CA
% ** John C. Mosher, PhD, Biophysics Group,
%    Los Alamos National Laboratory, Los Alamos, NM
% ** Sylvain Baillet, PhD, Cognitive Neuroscience & Brain Imaging Laboratory,
%    CNRS, Hopital de la Salpetriere, Paris, France
% 
% See BrainStorm website at http://neuroimage.usc.edu for further information.
% 
% Copyright (c) 2004 BrainStorm by the University of Southern California
% This software distributed  under the terms of the GNU General Public License
% as published by the Free Software Foundation. Further details on the GPL
% license can be found at http://www.gnu.org/copyleft/gpl.html .
% 
% FOR RESEARCH PURPOSES ONLY. THE SOFTWARE IS PROVIDED "AS IS," AND THE
% UNIVERSITY OF SOUTHERN CALIFORNIA AND ITS COLLABORATORS DO NOT MAKE ANY
% WARRANTY, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO WARRANTIES OF
% MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, NOR DO THEY ASSUME ANY
% LIABILITY OR RESPONSIBILITY FOR THE USE OF THIS SOFTWARE.
%<autoend> ------------------------ 26-May-2004 11:29:54 -----------------------



% transform connectivity cells into matrix with first column containing the number of neighbors for each row
connectivity_mattemp=zeros(size(v,1),20);
maxim=0;
for i=1:size(v,1)
	clear v_connex;
	v_connex=[i connectivity_cell{i}];
	if size(v_connex,2)>maxim
		maxim=size(v_connex,2);
	end
	connectivity_mattemp(i,2:size(v_connex,2)+1)=v_connex;
	connectivity_mattemp(i,1)=size(v_connex,2);
end
connectivity_mat=connectivity_mattemp(:,1:maxim+1);

% compute "approximative embedding surface"
v_embedding=embedding(v,connectivity_mat,3,3);
v_embedding_pos=embedding(v_pos,connectivity_mat,3,3);
v_embedding_neg=embedding(v_neg,connectivity_mat,3,3);

% compute deepness coding (contrast)
d=sqrt(sum((v_embedding-v).^2,2));
dsort=sort(d);
d_gs=dsort(floor(size(d,1)*0.5));
I_gs=find(d>=d_gs);
Ipos_gs=intersect(I_gs,I_pos);
Ineg_gs=intersect(I_gs,I_neg);
d(Ipos_gs)=sqrt(sum((v_embedding_pos(Ipos_gs,:)-v_pos(Ipos_gs,:)).^2,2));
d(Ineg_gs)=sqrt(sum((v_embedding_neg(Ineg_gs,:)-v_neg(Ineg_gs,:)).^2,2));
minid=min(min(d));
maxid=max(max(d));
C=(ones(size(v_embedding,1),1)-((d)-minid)/(maxid-minid));
clear d;
Cmap=ones(size(v_embedding,1),1)*ref_map(1,:);
C_sort=sort(C);
prop_max=C_sort(floor(size(C_sort,1)*prop_thres)); 
clear C_sort;
I=find(C<=prop_max);
Cmap(I,:)=ones(size(I,1),1)*ref_map(2,:);
