function G = eeg_bem(L,Channel,Param,Order,Verbose, varargin);
%EEG_BEM - Calculate the electric potential , BEM approach, arbitrary orientation
% function G = eeg_bem(L,Channel,Param,Order,Verbose, varargin);
% function G = eeg_bem(L,Channel,Param,Order);
% L is 3 x nL, each column a source location
% Channel is the channel structure, same for Param
% Order is 
%  -1 current dipole  
%   0 focal(magnetic) dipole %NOT SUPPORTED
%   1 1st order multipole %NOT SUPPORTED
%
% Verbose: toggle Verbose mode (1 is default)

%<autobegin> ---------------------- 14-Jun-2004 17:10:25 -----------------------
% --------- Automatically Generated Comments Block Using AUTO_COMMENTS ---------
%
% CATEGORY: Forward Modeling
%
% Alphabetical list of external functions (non-Matlab):
%   toolbox\gain_interp.m
%
% At Check-in: $Author: Mosher $  $Revision: 17 $  $Date: 6/14/04 3:37p $
%
% This software is part of BrainStorm Toolbox Version 2.0 (Alpha) 14-Jun-2004
% 
% Principal Investigators and Developers:
% ** Richard M. Leahy, PhD, Signal & Image Processing Institute,
%    University of Southern California, Los Angeles, CA
% ** John C. Mosher, PhD, Biophysics Group,
%    Los Alamos National Laboratory, Los Alamos, NM
% ** Sylvain Baillet, PhD, Cognitive Neuroscience & Brain Imaging Laboratory,
%    CNRS, Hopital de la Salpetriere, Paris, France
% 
% See BrainStorm website at http://neuroimage.usc.edu for further information.
% 
% Copyright (c) 2004 BrainStorm by the University of Southern California
% This software distributed  under the terms of the GNU General Public License
% as published by the Free Software Foundation. Further details on the GPL
% license can be found at http://www.gnu.org/copyleft/gpl.html .
% 
% FOR RESEARCH PURPOSES ONLY. THE SOFTWARE IS PROVIDED "AS IS," AND THE
% UNIVERSITY OF SOUTHERN CALIFORNIA AND ITS COLLABORATORS DO NOT MAKE ANY
% WARRANTY, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO WARRANTIES OF
% MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, NOR DO THEY ASSUME ANY
% LIABILITY OR RESPONSIBILITY FOR THE USE OF THIS SOFTWARE.
%<autoend> ------------------------ 14-Jun-2004 17:10:25 -----------------------

% ----------------------------- Script History ---------------------------------
% Authors: Sylvain Baillet, Ph.D. - John E. Ermer M Sc.
% 19-May-2004 JCM Comments cleaning
% ----------------------------- Script History ---------------------------------

if nargin < 5
    Verbose = 1; % Default
end

if Order >-1
   errordlg('Higher-order source models not supported in BEM, Sorry.')
   return
end

Rq = L';
%[G,R_eeg_sensor,R_meg_sensor,O_meg_sensor] = gain_bem_interp2(Rq,Param(1).bem_gaingrid_mfname,persist_inhibit);
[G] = gain_interp(Rq,Param(1).bem_gaingrid_mfname);

% Now reduce back to requested number of channels
if nargin == 7 % User reduces computation to a selected number of channels
    G = G(varargin{end},:);
end

