function [subdirs] = find_subdir(dirname);
%FIND_SUBDIR - Find all subdirectories in a BrainStorm path
% function [subdirs] = find_subdir(dirname);
% Find all the subdirectories within dirname and return them is the cell array subdirs
% All subdirs are given referentially to the dirname.
% 
% Could use genpath and genpath2cell, but specific folders are excluded here
%  For large trees, genpath would be faster CBB

%<autobegin> ---------------------- 26-May-2004 11:30:18 -----------------------
% --------- Automatically Generated Comments Block Using AUTO_COMMENTS ---------
%
% CATEGORY: Utility - General
%
% Alphabetical list of external functions (non-Matlab):
%   toolbox\find_subdir.m  NOTE: Routine calls itself explicitly
%
% At Check-in: $Author: Mosher $  $Revision: 12 $  $Date: 5/26/04 9:59a $
%
% This software is part of BrainStorm Toolbox Version 2.0 (Alpha) 24-May-2004
% 
% Principal Investigators and Developers:
% ** Richard M. Leahy, PhD, Signal & Image Processing Institute,
%    University of Southern California, Los Angeles, CA
% ** John C. Mosher, PhD, Biophysics Group,
%    Los Alamos National Laboratory, Los Alamos, NM
% ** Sylvain Baillet, PhD, Cognitive Neuroscience & Brain Imaging Laboratory,
%    CNRS, Hopital de la Salpetriere, Paris, France
% 
% See BrainStorm website at http://neuroimage.usc.edu for further information.
% 
% Copyright (c) 2004 BrainStorm by the University of Southern California
% This software distributed  under the terms of the GNU General Public License
% as published by the Free Software Foundation. Further details on the GPL
% license can be found at http://www.gnu.org/copyleft/gpl.html .
% 
% FOR RESEARCH PURPOSES ONLY. THE SOFTWARE IS PROVIDED "AS IS," AND THE
% UNIVERSITY OF SOUTHERN CALIFORNIA AND ITS COLLABORATORS DO NOT MAKE ANY
% WARRANTY, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO WARRANTIES OF
% MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, NOR DO THEY ASSUME ANY
% LIABILITY OR RESPONSIBILITY FOR THE USE OF THIS SOFTWARE.
%<autoend> ------------------------ 26-May-2004 11:30:18 -----------------------


% /---Script Author--------------------------------------\
% |                                                      |
% | *** Sylvain Baillet, Ph.D.                           |
% | Cognitive Neuroscience & Brain Imaging Laboratory    |
% | CNRS UPR640 - LENA                                   | 
% | Hopital de la Salpetriere, Paris, France             |
% | sylvain.baillet@chups.jussieu.fr                     |
% \------------------------------------------------------/
%  
% Date of creation: February 2002
%
% Script History ---------------------------------------------------------------
%
% JCM: 9-May-2002 editorial comments
% SB: 24-May-2002 Edited Header - Now come back to original directory once done, 
%                 rather than stay in last folder visited.
% JCM 6-Jun-2002  Autocomments, comments
% ------------------------------------------------------------------------------

OrigFolder = pwd; % Starting folder

D = dir(dirname);
for i = 1:length(D),
    if findstr(D(i).name,'..'),
        D(i).isdir = logical(0);  % don't want it
    end  
end
D = D([D.isdir]);

subdirs = {D.name};
if ~isempty(subdirs)
    for k = 1:length(subdirs)
        sub_subdirs{k} = fullfile(dirname,subdirs{k});
    end
    subdirs  = sub_subdirs;
else
    sub_subdirs = [];
end

for d = 1:length(D)
%     D(d).name
    if isempty(findstr(lower(D(d).name),'sptf')) 
       % Skip SPTF folders (usually quite big with multiple subfolders)
        sub_subdirs = find_subdir(fullfile(dirname,D(d).name));  
        subdirs = [subdirs,sub_subdirs];   
    end
end

cd(OrigFolder);
