function A = get_gain(fid,ndx);
%GET_GAIN - Get a set of source foward fields from a .bin gain matrix file
% function A = get_gain(fid,ndx);
% Get a set of source foward fields A from a .bin gain matrix file
% INPUTS
%       fid : a file identifier following a fopen call on a valid binary gain matrix file
%       ndx : vector array of source indices for which the forward fields are requested
% OUTPUTS
%       A   : array of requested forward fields
%
% The user is responsible for opening the file in the proper machine format.
%
% For head model matrices, this routine should only be accessed from read_gain,
% so that a consistent machine format is used to read the file.
%
% See also READ_GAIN, LOAD_RAW, SAVE_RAW

%<autobegin> ---------------------- 08-Jun-2004 15:11:19 -----------------------
% --------- Automatically Generated Comments Block Using AUTO_COMMENTS ---------
%
% CATEGORY: Forward Modeling
%
% At Check-in: $Author: Mosher $  $Revision: 17 $  $Date: 6/08/04 1:38p $
%
% This software is part of BrainStorm Toolbox Version 2.0 (Alpha) 28-May-2004
% 
% Principal Investigators and Developers:
% ** Richard M. Leahy, PhD, Signal & Image Processing Institute,
%    University of Southern California, Los Angeles, CA
% ** John C. Mosher, PhD, Biophysics Group,
%    Los Alamos National Laboratory, Los Alamos, NM
% ** Sylvain Baillet, PhD, Cognitive Neuroscience & Brain Imaging Laboratory,
%    CNRS, Hopital de la Salpetriere, Paris, France
% 
% See BrainStorm website at http://neuroimage.usc.edu for further information.
% 
% Copyright (c) 2004 BrainStorm by the University of Southern California
% This software distributed  under the terms of the GNU General Public License
% as published by the Free Software Foundation. Further details on the GPL
% license can be found at http://www.gnu.org/copyleft/gpl.html .
% 
% FOR RESEARCH PURPOSES ONLY. THE SOFTWARE IS PROVIDED "AS IS," AND THE
% UNIVERSITY OF SOUTHERN CALIFORNIA AND ITS COLLABORATORS DO NOT MAKE ANY
% WARRANTY, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO WARRANTIES OF
% MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, NOR DO THEY ASSUME ANY
% LIABILITY OR RESPONSIBILITY FOR THE USE OF THIS SOFTWARE.
%<autoend> ------------------------ 08-Jun-2004 15:11:19 -----------------------

% \------------------------------------------------------/
% | *** Sylvain Baillet, Ph.D.                           |
% | Cognitive Neuroscience & Brain Imaging Laboratory    |
% | CNRS UPR640 - LENA                                   | 
% | Hopital de la Salpetriere, Paris, France             |
% | sylvain.baillet@chups.jussieu.fr                     |
% \------------------------------------------------------/
%  
% Date of creation: October 2002 
% Script History -----------------------------------------------------------------------------------
%---------------------------------------------------------------------------------------------------


frewind(fid);

rows = fread(fid,1,'uint32');

if nargin == 2 
   cols = length(ndx);
   
   A = zeros(rows,cols);
   
   for i = 1:cols,
      % 4 bytes per element, find starting point
      offset = 4 + (ndx(i)-1)*rows*4;
      status = fseek(fid,offset,'bof');
      if(status == -1),
         error(sprintf('Error reading file at column %.0f',i));
      end
      
      A(:,i) = fread(fid,[rows,1],'float32'); 
      
   end
   
   return
   
else % ndx is not specified: read the whole matrix
   
   offset = 4;
   status = fseek(fid,offset,'bof');
   fbegin = ftell(fid);
   status = fseek(fid,0,'eof');
   fend = ftell(fid);
   
   frewind(fid);
   offset = 4;
   status = fseek(fid,offset,'bof');
   
   cols = (fend - fbegin + 1) / (4* rows); % Number of sources / columns
   
   A = fread(fid,[rows, cols],'float32');
   
end
