function helptext = help_data_channel;
%HELP_DATA_CHANNEL - Information on database files of type 'channel'
% function helptext = help_data_channel;
%
%    Landmark : a structure specifying locations of extra points of interests with fields:
%              Loc : a 3 x n array of landmark locations in meters coordinate system
%             Name : a 1 x n cell array of string used to label the landmarks
%
%     Channel : An array of structures. Each element in the array comprises 
%                the following fields
%              Loc : 3 x n, one column per coil, location in meters in SCS
%           Weight : 1 x n, relative gradiometer weights, e.g. [1 -1] or [1 -2 1]
%           Orient : 3 x n, one column per coil, Cartesian orientation in SCS
%             Type : String, must be {'MEG', 'EEG', 'MEG REF','EEG REF', 'OTHER'};
%             Name : String, short label, usually machine assigned 'MEG 001'
%          Comment : See explanation below
% 
%  The Comment field is somewhat complicated, CBB.
%          Comment : Keywords or data. If TYPE is 'EEG' and data are average referenced, 
%                    then Comment must be 'AVERAGE REF', and all Loc are a single location.
%                    If EEG are data are differential, then two Loc and Weights
%                    are used, and Comment is '' (blank). 
%                    If EEG data are single ended, then Loc is one location,
%                    there can ONLY be one Type of 'EEG REF', Comment is '', and
%                    algorithms know to search for the reference channel.
%                    If MEG data, and there are reference channels, the
%                    reference channels are marked Type 'MEG REF'. Then the
%                    FIRST Channel of Type 'MEG' has a Comment field that gives
%                    the transformation matrix that builds the higher
%                    gradiometers. See notes below for calculation method.
%
% Obsolete
%           System : String    e.g. 'CTF 151', this field apparently not used.
%
% -- Notes --
% SCS is the patient coordinate system, i.e. the coil location is with respect
%    to the subject's origin. See BrainStorm reference on coordinate systems:
%
%    http://neuroimage.usc.edu/brainstorm/GUI_CoordinateSystem.htm
%
% A "channel" comprises the locations of the array's output, usually the
%    result of combining "n" different coil locations.
%
% The reference channels are used to form "virtual gradiometers." If there are
%  151 head channels (Type 'MEG') and 29 reference channels (Type 'MEG REF'),
%  then the reference weighting matrix is 151 x 29. The 151 originally recorded
%  data channels are modified in the machine or external to BrainStorm as Ffinal
%  = Forg - W*Fref; If Gfinal is the gain matrix for the noise-weighted gain
%  matrix (151 rows), Ghead is the gain matrix for each channel without noise
%  weighting (151 rows),  Gref is the gain matrix for each of the reference
%  channels (29 rows), and W is the reference channel weights, then:
%
%   Gfinal = Ghead - W*Gref;
%
%  See help_data_raw for descriptions on how to manually store this information
%  and importation. At this time, CTF weighting information is automatically
%  handled. 
%
% See also HELP_DATA_RAW

%<autobegin> ---------------------- 26-May-2004 11:30:25 -----------------------
% --------- Automatically Generated Comments Block Using AUTO_COMMENTS ---------
%
% CATEGORY: Help
%
% At Check-in: $Author: Mosher $  $Revision: 14 $  $Date: 5/26/04 9:59a $
%
% This software is part of BrainStorm Toolbox Version 2.0 (Alpha) 24-May-2004
% 
% Principal Investigators and Developers:
% ** Richard M. Leahy, PhD, Signal & Image Processing Institute,
%    University of Southern California, Los Angeles, CA
% ** John C. Mosher, PhD, Biophysics Group,
%    Los Alamos National Laboratory, Los Alamos, NM
% ** Sylvain Baillet, PhD, Cognitive Neuroscience & Brain Imaging Laboratory,
%    CNRS, Hopital de la Salpetriere, Paris, France
% 
% See BrainStorm website at http://neuroimage.usc.edu for further information.
% 
% Copyright (c) 2004 BrainStorm by the University of Southern California
% This software distributed  under the terms of the GNU General Public License
% as published by the Free Software Foundation. Further details on the GPL
% license can be found at http://www.gnu.org/copyleft/gpl.html .
% 
% FOR RESEARCH PURPOSES ONLY. THE SOFTWARE IS PROVIDED "AS IS," AND THE
% UNIVERSITY OF SOUTHERN CALIFORNIA AND ITS COLLABORATORS DO NOT MAKE ANY
% WARRANTY, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO WARRANTIES OF
% MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, NOR DO THEY ASSUME ANY
% LIABILITY OR RESPONSIBILITY FOR THE USE OF THIS SOFTWARE.
%<autoend> ------------------------ 26-May-2004 11:30:25 -----------------------


% This help file template was generated by 'make_help' on 24-Sep-2003 13:58:32
%
% This help file is callable as "help help_data_channel" (at the command line),
%  "help_data_channel" (in the Matlab help window), or
%  "txt = help_data_channel;" (no display, return only txt).
 
if nargout,
   helptext = help(mfilename); % return help block to output variable
else
   helpwin(mfilename); % no output variable, display in help window
end
