function helptext = help_data_image;
%HELP_DATA_IMAGE - Information on database files of type 'image'
% function helptext = help_data_image;
%
%       Cube : is the actual image set, x, y, z, left to right, back to front,
%              bottom to top, of size M x N x P.
%  DataClass : a string describing the bit encoding of the gray levels (e.g. 'ushort')
%  Voxsize   : Size of a voxel in mm (e.g. [0.9375    0.9375    0.9375])
%  scantype  : a string label indicating the scan direction (e.g. 'Axial')
%        SCS : structure with fields:
%            FiducialName : cell array of ORDERED fiducial labels, 
%                           nasion, left and right and origin) 
%                          (e.g. 'Nasion', 'Left ear','Right ear', 'CTF Origin')
%                          (additional fiducials are stored in Landmarks below).
%          mmCubeFiducial : is 3 x n array of ORDERED coordinate fiducial points 
%                           in mm (see FiducialName) 
%                           MRI coordinates relative to 0,0,0 point.
%                  System : keyword, {'CTF','NEUROMAG'}
%                       R : 3x3 rotation matrix (cosines)
%                       T : translation 3x1 vector (units of mm)
%                   
%                           Transformation formulas are:
%                           x(SCS coordinates) = R * x(MRI coordinates) + T
%                           x(MRI) = inv(R)*(x(SCS) - T)
%
% Landmarks : a structure specifying locations of extra points of interests with fields:
%                MRImmXYZ : a 3xn array of landmark locations in mm and MRI coordinate system
%                Names    : a cell array of string used to label the landmarks
%
% See http://neuroimage.usc.edu/brainstorm/GUI_CoordinateSystem.htm
%
% See also SCS2MRI, MRI2SCS, HELP_DATA_CHANNEL

%<autobegin> ---------------------- 26-May-2004 11:30:26 -----------------------
% --------- Automatically Generated Comments Block Using AUTO_COMMENTS ---------
%
% CATEGORY: Help
%
% At Check-in: $Author: Mosher $  $Revision: 14 $  $Date: 5/26/04 9:59a $
%
% This software is part of BrainStorm Toolbox Version 2.0 (Alpha) 24-May-2004
% 
% Principal Investigators and Developers:
% ** Richard M. Leahy, PhD, Signal & Image Processing Institute,
%    University of Southern California, Los Angeles, CA
% ** John C. Mosher, PhD, Biophysics Group,
%    Los Alamos National Laboratory, Los Alamos, NM
% ** Sylvain Baillet, PhD, Cognitive Neuroscience & Brain Imaging Laboratory,
%    CNRS, Hopital de la Salpetriere, Paris, France
% 
% See BrainStorm website at http://neuroimage.usc.edu for further information.
% 
% Copyright (c) 2004 BrainStorm by the University of Southern California
% This software distributed  under the terms of the GNU General Public License
% as published by the Free Software Foundation. Further details on the GPL
% license can be found at http://www.gnu.org/copyleft/gpl.html .
% 
% FOR RESEARCH PURPOSES ONLY. THE SOFTWARE IS PROVIDED "AS IS," AND THE
% UNIVERSITY OF SOUTHERN CALIFORNIA AND ITS COLLABORATORS DO NOT MAKE ANY
% WARRANTY, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO WARRANTIES OF
% MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, NOR DO THEY ASSUME ANY
% LIABILITY OR RESPONSIBILITY FOR THE USE OF THIS SOFTWARE.
%<autoend> ------------------------ 26-May-2004 11:30:26 -----------------------


% OBSOLETE ________________________________________________________
%      Comment : String comment about the file
%          PCS : The patient coordinate system (see below)
%      Segment : A segment of the cube
%      Voxsize : The dimensions of the voxels
%
%      Structure 'PCS' has the following fields:
%               Comment: char    e.g. 'CTF'
%          CubeFiducial: [3x6 double]  
%          FiducialName: [1x6 cell]  
%           PCSFiducial: [3x6 double]  
%                     R: [3x3 double]  
%                     t: [3x1 double]  
%
%___________________________________________________________________
% -- Notes --
%  Cube: 
%  PCS:
%  Voxsize:

% ----------------------------- Script History ---------------------------------
% 25-May-2004 JCM  Updating, cleaning comments
% ----------------------------- Script History ---------------------------------


% This help file template was generated by 'make_help' on 24-Sep-2003 13:58:29
%
% This help file is callable as "help help_data_image" (at the command line),
%  "help_data_image" (in the Matlab help window), or
%  "txt = help_data_image;" (no display, return only txt).
 
if nargout,
   helptext = help(mfilename); % return help block to output variable
else
   helpwin(mfilename); % no output variable, display in help window
end

web('http://neuroimage.usc.edu/brainstorm/GUI_CoordinateSystem.htm','-browser')
