function helptext = help_data_raw;
%HELP_DATA_RAW - Information on database files of type 'raw'
% function helptext = help_data_raw;
%
% --------------------- RAW Formats (Binary and ASCII) -------------------------
%
% The BrainStorm "raw" format is for loading sensor and data from arbitrary
% formats. The file extensions are of keywords {.txt, .raw}. Files of extension
% "txt" are considered ASCII (text) files, and extensions of type "raw" are
% considered as binary files. The formats of each are:
%
%TXT:
%   Each line is terminated with an EOL, each ascii number is separated by white
%   space. Data are loaded using Matlab's "load -ascii" convention, see Matlab
%   help on "load". Matlab command is load('-ascii',fname). The number of rows
%   and columns are automatically inferred from the load routine. In special
%   cases, the text file may be a more general string file rather than a simple
%   ascii translation of data. See for instance the Channel Labels file.
%
% RAW:
%   All values are written as single precision binary, i.e. four-byte floats.
%   See Matlab help on "single" and on "fread". Data are loaded using fread as 
%   fread(fname,inf,'single'). The first float is the number of rows, the second
%   float is the number of columns, and the remaining rows*columns floats are
%   the data in the matrix of dimension rows x columns.
%
% -------------------------- BrainStorm Raw Files ------------------------------
%
% The result of "load_raw" is a matrix read into matlab. The matrices
%   anticipated for loading into BrainStorm are listed and summarized below.
%
% Channel Location, the Cartesian location of each sensor coil in each channel
% Channel Orientation, the Cartesian orientation of the coil (null for EEG)
% Channel Type, optional text file giving the sensor type (i.e. MEG, EEG, reference)
% Channel Labels, optional text file of names of each sensor (e.g. 'Cz', 'MEG 001')
% Channel Weights, optional file of the reference weights applied in noise
%                  cancellation schemes
% Data File, the spatial-temporal or temporal-spatial data matrix
% Data Time, the optional vector of time indices associated with the data
%
% Details of each file are discussed below
%
% ---------------------- BrainStorm Raw File Summaries -------------------------
%
% Channel Location information
%   The number of rows is the number of data channels. Each channel is
%   characterized by one or more sensors or coils, equal to the number of
%   columns x 3 (x, y, z location) in the matrix. Magnetometers have one column,
%   1st order gradiometers have two, single-ended EEG have one, differential
%   pairs have two. Single-ended EEG also have an additional channel location
%   for the reference electrode. Alternatively, enter all EEG channels as two
%   columns, the first for the primary electrode, the second for the reference
%   electrode. If there is a mix of channel sizes (e.g. magnetometers and
%   gradiometers), enter NaN for the additional channels when forming the
%   matrix.
%
%   All units are in meters, in Cartestian coordinates with respect to the
%   Subject Coordinate System.
%
% Channel Orientation Information
%   In the case of MEG, each coil needs an orientation. The Channel orientation
%   matrix is identical in size to the Channel Location matrix. Each three
%   elements (cos x, cos y, cos z) is the orientation in Cartesian coordinates
%   for the corresponding location. The orientation vector should be unit norm,
%   which will be enforced by the import routine. In a mixed sensor type file,
%   enter NaN for meaningless orientations. EEG-only can skip this file.
%
% Optional: Channel Labels
%   Optionally, a separate file of channel labels (e.g. 'Cz', 'R12', 'My first
%   sensor'), one text line per channel, may be provided. If not provided, then
%   default labels of 'MEG Channel 1', etc, will be assigned. Each line of the
%   Channel labels file should not be surrounded in quotes. 
%
% Optional: Channel Type
%   A raw file may be loaded as all one type (EEG or MEG), but optionally a text
%   file may be provided that contains one line per channel, with the following
%   keywords (from help_data_channel):
%     'MEG', 'EEG', 'MEG REF', 'EEG REG', 'OTHER'
%   Each line of the Type file should not be surrounded in quotes
%
% Optional: Channel Reference Weights
%   Noise cancellation schemes generally work by designating some channels as
%   "reference", then subtracting the reference channels in a prescribed manner
%   from the regular head sensors. For instance, if there are 100 sensors about
%   the head and an additional 10 reference sensors in the upper region of the
%   Dewar, then the Reference Weights matrix is 100 x 10, giving the
%   coefficients necessary to subtract the ten sensors from each channel.
%
% Optional: Landmark Information
%   In addition to the coil locations (both EEG and MEG), "landmarks" or
%   "fiducial" points may be entered in an optional file, generally anticipated
%   to be points on the scalp. In EEG data, the following fiduciary landmarks
%   are necessary in order to establish the subject coordinate system: Nasion,
%   Left Pre-aricular, Right Pre-aricular. These landmarks are also explicitly
%   found in some MEG data sets. Other landmarks may include the location of
%   localizing coils or arbitrary headshape points. The format of the landmark
%   file should always be a text file, one line per landmark, in the format '%g
%   %g %g %s', where the first three values are the x,y,z Cartesian coordinates
%   of the landmark and the last entry is a arbitrary text string. Coordinates
%   should be separated spaces, and everything after the third space is taken
%   literally as the landmark string, so no quotes should be used, 
%   example: 0.09 -0.09 0.03 Nasion (PPI measured) 
%
% Data Matrix Information
%   The data matrix is nominally a space-time matrix, where each column of the
%   matrix represents one time slice, and the number of rows is equal to the
%   number of channels. The space-time matrix may be stored as either space-time
%   or time-space, as selected by the user at read time. If stored as raw
%   (binary), the first two floats should indicate the rows and columns of the
%   matrix. If the data are stored as time-space, then after loading the matrix
%   will be transposed to space-time. This transposition will cause a noticeable
%   delay only in the loading of very large data files. Typically binary data
%   are stored "muxed", i.e. by time slice, with the first, say, 151 data points
%   equal to the measurements at the 151 sensors in the first time instance. The
%   data are loaded as "spatial-temporal."
%   By contrast, often ascii data are stored by channel, such that the first
%   line of the text file corresponds to the time series for the first sensor.
%   These data are loaded as "temporal-spatial", then transposed after loading.
%   All Data matrices in BrainStorm are ultimately stored as "spatial-temporal."
%
%   All units should be in MKS, i.e. MEG in Tesla and EEG in Volts.
%
%   The final spatial-temporal (loaded by any above method and transpostion) data
%   matrix should have as many rows (channels) as there are channels in the
%   Channel matrix. NOTE IN THE CASE OF EEG: For (say) a 128 channel EEG system,
%   all single ended, there are actually 129 sensor locations, with the 129th
%   (say) the reference electrode. Unlike MEG, there is no recorded 129th
%   channel of information, but for bookkeeping purposes in BrainStorm we need a
%   virtual 129th channel of data. Either make a channel row of NaN or zero data
%   in the data matrix at the same index number as the reference channel
%   location, or accept the load routine's request to add such a row.
%
% Time Vector information
%   Since the data may be written in either space-time or time-space, we load
%   separately a simple vector of time values, in seconds. For consistency with
%   other raw formats, the first two floats should be unity and the length of
%   the time series. Text files should just be white space separated text
%   numbers, and EOLs will be ignored. 
%
% Reference in the Help Menu: the BrainStorm Document on coordinate Systems.
%
% See also LOAD_RAW, SAVE_RAW, HELP_DATA_CHANNEL, HELP_DATA_DATA,
%          HELP_DATABASE_LIST

%<autobegin> ---------------------- 26-May-2004 11:30:26 -----------------------
% --------- Automatically Generated Comments Block Using AUTO_COMMENTS ---------
%
% CATEGORY: Help
%
% At Check-in: $Author: Mosher $  $Revision: 10 $  $Date: 5/26/04 9:59a $
%
% This software is part of BrainStorm Toolbox Version 2.0 (Alpha) 24-May-2004
% 
% Principal Investigators and Developers:
% ** Richard M. Leahy, PhD, Signal & Image Processing Institute,
%    University of Southern California, Los Angeles, CA
% ** John C. Mosher, PhD, Biophysics Group,
%    Los Alamos National Laboratory, Los Alamos, NM
% ** Sylvain Baillet, PhD, Cognitive Neuroscience & Brain Imaging Laboratory,
%    CNRS, Hopital de la Salpetriere, Paris, France
% 
% See BrainStorm website at http://neuroimage.usc.edu for further information.
% 
% Copyright (c) 2004 BrainStorm by the University of Southern California
% This software distributed  under the terms of the GNU General Public License
% as published by the Free Software Foundation. Further details on the GPL
% license can be found at http://www.gnu.org/copyleft/gpl.html .
% 
% FOR RESEARCH PURPOSES ONLY. THE SOFTWARE IS PROVIDED "AS IS," AND THE
% UNIVERSITY OF SOUTHERN CALIFORNIA AND ITS COLLABORATORS DO NOT MAKE ANY
% WARRANTY, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO WARRANTIES OF
% MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, NOR DO THEY ASSUME ANY
% LIABILITY OR RESPONSIBILITY FOR THE USE OF THIS SOFTWARE.
%<autoend> ------------------------ 26-May-2004 11:30:26 -----------------------



% This help file template was generated by 'make_help' on 16-Apr-2004 10:26:11
%
% This help file is callable as "help help_data_raw" (at the command line),
%  "help_data_raw" (in the Matlab help window), or
%  "txt = help_data_raw;" (no display, return only txt).
 
if nargout,
   helptext = help(mfilename); % return help block to output variable
else
   helpwin(mfilename); % no output variable, display in help window
end
