function help_preference_list;
%HELP_PREFERENCE_LIST - Explain the preferences used by BrainStorm
% function help_preference_list;
%Call as a function or type 'help help_preference_list' at the command line
%
%Generate this file using the development tool make_preference_list
%
%AS OF 24-Sep-2003 15:30:18:
%
% -----------------  BrainStorm  ---------------------
%
%The following Preferences are found in the BrainStorm m-files:
%
%          CurrentData
%      DateofAgreement
%       DefaultSubject
%               Layout
%              Studies
%         StudySubject
%             Subjects
%      UserCurrentData
%         UserDataBase
%              Version
%        iUserDataBase
%
%Matlab has the following Preferences stored in Group 'BrainStorm'
%
%        CurrentData: [1x1 struct]  
%    DateofAgreement: char    e.g. '18-Sep-2003'
%             Layout: [1x1 struct]  
%            Studies: [1x1 struct]  
%       StudySubject: empty   
%           Subjects: [1x1 struct]  
%       UserDataBase: [1x3 struct]  
%            Version: [1x1 struct]  
%      iUserDataBase: [1x1 double]  e.g. 1
%
%Below are details on how each Preference is defined and used in BrainStorm
%
%
%-----------------  CurrentData  ---------------------
%
%BrainStorm Preference 'CurrentData' is of class struct
% 'CurrentData' has the following fields:
%         StudyFile: char    e.g. 'default_data\sphere_brainstormstudy.mat'
%       SubjectFile: char    e.g. 'default_subject\sphere_brainstormsubject.mat'
%
% Help for this preference (help_pref_currentdata) is given as:
%
%   Group 'BrainStorm' Preference 'CurrentData'
%   Class Structure, array 1 x 1
%   Fields
%    .StudyFile Relative filename to the folder containing data
%    .SubjectFile Relative filename to the folder with subject information
%  
%
% The following BrainStorm m-files 'SET' this preference:
%
%    data_manager.m
%    database_manager.m
%
% The following BrainStorm m-files 'GET' this preference:
%
%    database_manager.m
%    dataplot_cb.m
%    get_user_directory.m
%    startup.m
%
%
%-----------------  DateofAgreement  ---------------------
%
%BrainStorm Preference 'DateofAgreement' is of class char
%
% Help for this preference (help_pref_dateofagreement) is given as:
%
%   Group 'BrainStorm' Preference 'DateofAgreement'
%   Class character
%   String giving the date copyright notice last agreed to
%  
%
% The following BrainStorm m-files 'SET' this preference:
%
%    bst_splashscreen.m
%
% The following BrainStorm m-files 'GET' this preference:
%
%    startup.m
%
%
%-----------------  DefaultSubject  ---------------------
%
%
% ** BrainStorm Preference 'DefaultSubject' was NOT found in the stored preferences.
%
%
% Help for this preference (help_pref_defaultsubject) is given as:
%
%   (add help information)
%
% The following BrainStorm m-files 'SET' this preference:
%
%
% The following BrainStorm m-files 'GET' this preference:
%
%    importdata.m
%
%
%-----------------  Layout  ---------------------
%
%BrainStorm Preference 'Layout' is of class struct
% 'Layout' has the following fields:
%        DynamicHeight: [1x1 double]  e.g. 0.832713
%         DynamicWidth: [1x1 double]  e.g. 0.18395
%           MenuMargin: [1x1 double]  e.g. 0.025
%        MessageHeight: [1x1 double]  e.g. 0.166636
%         MessageWidth: [1x1 double]  e.g. 0.398232
%           NameMargin: [1x1 double]  e.g. 0.032
%       ScreenPosition: [1x4 double]  
%           ScreenSize: [1x4 double]  
%           SideMargin: [1x1 double]  e.g. 0.0075
%         StaticHeight: [1x1 double]  e.g. 0.166636
%          StaticWidth: [1x1 double]  e.g. 0.601768
%               allpos: [9x4 double]  
%              tilepos: [2x2 cell]  
%               winpos: [3x4 double]  
%
% Help for this preference (help_pref_layout) is given as:
%
%   Group 'BrainStorm' Preference 'Layout'
%   Class structure 1 x 1
%   Fields
%    .DynamicHeight Height of the vertical toolbar on the right 
%    .DynamicWidth Width (normalized units)
%    .MenuMargin allowance for the filemenu height used in some figs
%    .MessageHeight Height of the Message window on the lower left
%    .MessageWidth Width
%    .NameMargin allowance for the name height used in all windows
%    .ScreenPosition
%    .ScreenSize
%    .SideMargin allowance for thickness of the edging on sides of figures
%    .StaticHeight Height of the BrainStorm toolbar at lower right
%    .StaticWidth width
%    .allpos: [9x4 double]  concatenation of these positions
%    .tilepos: [2x2 cell]  the calculated locations of each tile (1,1,1) to (2,2,4)
%    .winpos: [3x4 double]
%  
%
% The following BrainStorm m-files 'SET' this preference:
%
%    bst_layout.m
%
% The following BrainStorm m-files 'GET' this preference:
%
%    bst_layout.m
%    bst_static_taskbar.m
%    data_manager.m
%
%
%-----------------  Studies  ---------------------
%
%BrainStorm Preference 'Studies' is of class struct
% 'Studies' has the following fields:
%         StudyFile: char    e.g. 'default_data\sphere_brainstormstudy.mat'
%       StudyFolder: char    e.g. 'default_data'
%         StudyName: char    e.g. 'Default Data'
%
% Help for this preference (help_pref_studies) is given as:
%
%   (add help information)
%
% The following BrainStorm m-files 'SET' this preference:
%
%    data_manager.m
%
% The following BrainStorm m-files 'GET' this preference:
%
%    startup.m
%    study_editor.m
%    subject_editor.m
%
%
%-----------------  StudySubject  ---------------------
%
%BrainStorm Preference 'StudySubject' is of class empty
%
% Help for this preference (help_pref_studysubject) is given as:
%
%   (add help information)
%
% The following BrainStorm m-files 'SET' this preference:
%
%
% The following BrainStorm m-files 'GET' this preference:
%
%    startup.m
%
%
%-----------------  Subjects  ---------------------
%
%BrainStorm Preference 'Subjects' is of class struct
% 'Subjects' has the following fields:
%              Name: char    e.g. 'Default Spherical Subject'
%       SubjectFile: char    e.g. 'default_subject\sphere_brainstormsubject.mat'
%
% Help for this preference (help_pref_subjects) is given as:
%
%   (add help information)
%
% The following BrainStorm m-files 'SET' this preference:
%
%    data_manager.m
%
% The following BrainStorm m-files 'GET' this preference:
%
%    importdata.m
%    startup.m
%    study_editor.m
%
%
%-----------------  UserCurrentData  ---------------------
%
%
% ** BrainStorm Preference 'UserCurrentData' was NOT found in the stored preferences.
%
%
% Help for this preference (help_pref_usercurrentdata) is given as:
%
%   (add help information)
%
% The following BrainStorm m-files 'SET' this preference:
%
%    dataplot_cb.m
%
% The following BrainStorm m-files 'GET' this preference:
%
%    get_user_directory.m
%
%
%-----------------  UserDataBase  ---------------------
%
%BrainStorm Preference 'UserDataBase' is of class struct
% 'UserDataBase' has the following fields:
%        Comment: char    e.g. 'Default Database'
%       FILELIST: [1x1 struct]  
%        STUDIES: char    e.g. 'C:\BrainStorm_2001\default_database'
%       SUBJECTS: char    e.g. 'C:\BrainStorm_2001\default_database'
%
%      Structure 'FILELIST' has the following fields:
%            StudyFile: char    e.g. 'default_data\sphere_brainstormstudy.mat'
%          StudyFolder: char    e.g. 'default_data'
%            StudyName: char    e.g. 'Default Data'
%              Subject: [1x1 struct]  
%                bytes: [1x1 double]  e.g. 720
%                 date: char    e.g. '18-Sep-2003 09:35:20'
%              display: char    e.g. 'default_data | Default.Data | Default.Spherical.Subject'
%                isdir: [1x1 double]  e.g. 0
%
%         Structure 'Subject' has the following fields:
%                    Name: char    e.g. 'Default Spherical Subject'
%             SubjectFile: char    e.g. 'default_subject\sphere_brainstormsubject.mat'
%
% Help for this preference (help_pref_userdatabase) is given as:
%
%   Group 'BrainStorm' Preference 'UserDataBase'
%   Class Structure, array 1 x n
%   Fields
%    .Comment The name of the database
%    .SUBJECTS The absolute directory folder where all subject information is kept.
%    .STUDIES  The absolute directory folder where all data information is kept.
%    .FILELIST The result of BROWSE_STUDY_FOLDER applied to .STUDIES.
%  
%
% The following BrainStorm m-files 'SET' this preference:
%
%    brainstorm_reset.m
%    data_manager.m
%    database_manager.m
%    make_default_database.m
%    startup.m
%    study_editor.m
%
% The following BrainStorm m-files 'GET' this preference:
%
%    brainstorm_reset.m
%    data_manager.m
%    database_manager.m
%    get_user_directory.m
%    make_default_database.m
%    startup.m
%    study_editor.m
%
%
%-----------------  Version  ---------------------
%
%BrainStorm Preference 'Version' is of class struct
% 'Version' has the following fields:
%          Date: char    e.g. '08-Sep-2003'
%          Name: char    e.g. 'BrainStorm Toolbox'
%       Release: char    e.g. '(Alpha-Pre)'
%       Version: char    e.g. '2.0'
%
% Help for this preference (help_pref_version) is given as:
%
%   (add help information)
%
% The following BrainStorm m-files 'SET' this preference:
%
%    startup.m
%
% The following BrainStorm m-files 'GET' this preference:
%
%    bst_static_taskbar.m
%
%
%-----------------  iUserDataBase  ---------------------
%
%BrainStorm Preference 'iUserDataBase' is of class double
%
% Help for this preference (help_pref_iuserdatabase) is given as:
%
%   (add help information)
%
% The following BrainStorm m-files 'SET' this preference:
%
%    brainstorm_reset.m
%    data_manager.m
%    database_manager.m
%    make_default_database.m
%    startup.m
%
% The following BrainStorm m-files 'GET' this preference:
%
%    data_manager.m
%    database_manager.m
%    get_user_directory.m
%    make_default_database.m
%    study_editor.m
%

%<autobegin> ---------------------- 26-May-2004 11:30:39 -----------------------
% --------- Automatically Generated Comments Block Using AUTO_COMMENTS ---------
%
% CATEGORY: Help
%
% At Check-in: $Author: Mosher $  $Revision: 7 $  $Date: 5/26/04 9:59a $
%
% This software is part of BrainStorm Toolbox Version 2.0 (Alpha) 24-May-2004
% 
% Principal Investigators and Developers:
% ** Richard M. Leahy, PhD, Signal & Image Processing Institute,
%    University of Southern California, Los Angeles, CA
% ** John C. Mosher, PhD, Biophysics Group,
%    Los Alamos National Laboratory, Los Alamos, NM
% ** Sylvain Baillet, PhD, Cognitive Neuroscience & Brain Imaging Laboratory,
%    CNRS, Hopital de la Salpetriere, Paris, France
% 
% See BrainStorm website at http://neuroimage.usc.edu for further information.
% 
% Copyright (c) 2004 BrainStorm by the University of Southern California
% This software distributed  under the terms of the GNU General Public License
% as published by the Free Software Foundation. Further details on the GPL
% license can be found at http://www.gnu.org/copyleft/gpl.html .
% 
% FOR RESEARCH PURPOSES ONLY. THE SOFTWARE IS PROVIDED "AS IS," AND THE
% UNIVERSITY OF SOUTHERN CALIFORNIA AND ITS COLLABORATORS DO NOT MAKE ANY
% WARRANTY, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO WARRANTIES OF
% MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, NOR DO THEY ASSUME ANY
% LIABILITY OR RESPONSIBILITY FOR THE USE OF THIS SOFTWARE.
%<autoend> ------------------------ 26-May-2004 11:30:39 -----------------------



% CATEGORY: Help

helptext = help(mfilename);

helpwin(mfilename);
