function Hi = hrow_linear(colp,PP,v,yset,yset_mag,geometry,nodes,cdvdiff,N,area2)
%HROW_LINEAR - Compute row in BEM geometry matrix for linear collocation
% function Hi = hrow_linear(colp,PP,v,yset,yset_mag,geometry,nodes,cdvdiff,N,area2)
% compute a row of the H matrix(1 by no_node) for linear BEM
% formula in:
% de Munck, IEEE Trans.BME, pp986-990,1992
% or schlitt et al, IEEE Trans, BME, pp52-58, 1995
% some global variables
%

%<autobegin> ---------------------- 26-May-2004 11:30:41 -----------------------
% --------- Automatically Generated Comments Block Using AUTO_COMMENTS ---------
%
% CATEGORY: Forward Modeling
%
% Alphabetical list of external functions (non-Matlab):
%   toolbox\crossprod.m
%   toolbox\dotprod.m
%
% At Check-in: $Author: Mosher $  $Revision: 14 $  $Date: 5/26/04 9:59a $
%
% This software is part of BrainStorm Toolbox Version 2.0 (Alpha) 24-May-2004
% 
% Principal Investigators and Developers:
% ** Richard M. Leahy, PhD, Signal & Image Processing Institute,
%    University of Southern California, Los Angeles, CA
% ** John C. Mosher, PhD, Biophysics Group,
%    Los Alamos National Laboratory, Los Alamos, NM
% ** Sylvain Baillet, PhD, Cognitive Neuroscience & Brain Imaging Laboratory,
%    CNRS, Hopital de la Salpetriere, Paris, France
% 
% See BrainStorm website at http://neuroimage.usc.edu for further information.
% 
% Copyright (c) 2004 BrainStorm by the University of Southern California
% This software distributed  under the terms of the GNU General Public License
% as published by the Free Software Foundation. Further details on the GPL
% license can be found at http://www.gnu.org/copyleft/gpl.html .
% 
% FOR RESEARCH PURPOSES ONLY. THE SOFTWARE IS PROVIDED "AS IS," AND THE
% UNIVERSITY OF SOUTHERN CALIFORNIA AND ITS COLLABORATORS DO NOT MAKE ANY
% WARRANTY, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO WARRANTIES OF
% MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, NOR DO THEY ASSUME ANY
% LIABILITY OR RESPONSIBILITY FOR THE USE OF THIS SOFTWARE.
%<autoend> ------------------------ 26-May-2004 11:30:41 -----------------------

% History -------------------------------
% JCM 08-Sep-2003 Commenting
% ---------------------------------------


no_elt = size(geometry,1);
no_node = size(nodes,1);
Hi = zeros(1,no_node);
Y = [nodes(:,1)-colp(1),nodes(:,2)-colp(2),nodes(:,3)-colp(3)];
MAGY2  = (sum((Y.*Y)'))';
MAGY = sqrt(MAGY2);
y1 = Y(geometry(v,1),:);
y2 = Y(geometry(v,2),:);
y3 = Y(geometry(v,3),:);

magy2 = [MAGY2(geometry(v,1)),MAGY2(geometry(v,2)),MAGY2(geometry(v,3))];
magy2(magy2 == 0) = eps*min(abs(magy2(magy2 ~= 0))); % SB: Divide by or Log of Zeros issues
magy = [MAGY(geometry(v,1)),MAGY(geometry(v,2)),MAGY(geometry(v,3))];
magy(magy == 0) = eps*min(abs(magy(magy ~= 0))); % SB: Divide by or Log of Zeros issues

%cp = [(cross(y2',y3'))',(cross(y3',y1'))',(cross(y1',y2'))'];  %je 4/20/00
cp = [(crossprod(y2,y3)),(crossprod(y3,y1)),(crossprod(y1,y2))];

%  solid angle
%dp = [(dot(y2',y3'))',(dot(y3',y1'))',(dot(y1',y2'))'];  %je 4/20/00
dp = [(dotprod(y2,y3)),(dotprod(y3,y1)),(dotprod(y1,y2))];

sangle =  2*atan2(dotprod(y1,cp(:,1:3)) , ...     
                  magy(:,1).*(magy(:,2).*magy(:,3)+dp(:,1)) +...
                  magy(:,2).*dp(:,2) +...
                  magy(:,3).*dp(:,3) );

OMEGA = zeros(length(v),3);  % compute omegabar eq.(A.10) in Schlitt

% Schlitt (A11)
gammap =log( ( yset_mag(v,1).*magy(:,2)+magy2(:,2)-dp(:,3))./...
   ( yset_mag(v,1).* magy(:,1) + dp(:,3)-magy2(:,1) +eps*min(yset_mag(v,1)~=0)))./yset_mag(v,1);
OMEGA = OMEGA -  yset(v,1:3).*[gammap,gammap,gammap];
gammap =log( ( yset_mag(v,2).*magy(:,3)+magy2(:,3)-dp(:,1))./...
   ( yset_mag(v,2).* magy(:,2) + dp(:,1)-magy2(:,2) +eps*min(yset_mag(v,2)~=0)))./yset_mag(v,2);
OMEGA = OMEGA -  yset(v,4:6).*[gammap,gammap,gammap];
gammap =log( ( yset_mag(v,3).*magy(:,1)+magy2(:,1)-dp(:,2))./...
   ( yset_mag(v,3).* magy(:,3) + dp(:,2)-magy2(:,3) +eps*min(yset_mag(v,3)~=0)))./yset_mag(v,3); % eps*... here to avoid "divide by zero" messages
OMEGA = OMEGA -  yset(v,7:9).*[gammap,gammap,gammap];

beta = dotprod(N(v,:),y1);    %Schlitt (A1)

% see schlitt (A8), 2*area is absorbed into P matrix
h = zeros(no_elt,3);
h(v,1)= dotprod(N(v,:), cp(:,1:3)).*sangle+ ...
            beta .*dotprod(-yset(v,4:6),OMEGA) ;
h(v,2)= dotprod(N(v,:), cp(:,4:6)).*sangle+ ...
            beta .*dotprod(-yset(v,7:9),OMEGA) ;
h(v,3)= dotprod(N(v,:), cp(:,7:9)).*sangle+ ...
            beta .*dotprod(-yset(v,1:3),OMEGA) ;

Hi =  (PP*[h(:,1);h(:,2); h(:,3)])' .* cdvdiff';
return
