function [Rcoils,Ocoils,Rot,Trans,Cardinal,Extra,HPI_patient,HPI_device,Sensor_info] = load_fif_apos(fname,verbose);
%LOAD_FIF_APOS - Load in position information from Neuromag 122 ".apos" file
% function [Rcoils,Ocoils,Rot,Trans,Cardinal,Extra,HPI_patient,HPI_device,Sensor_info] = load_fif_apos(fname,verbose);
% function [Rcoils,Ocoils,Rot,Trans,Cardinal,Extra,...
%     HPI_patient,HPI_device,Sensor_info] = load_fif_apos(fname,verbose);
%
% Rcoils is the coil locations, Ocoils is the orientation
% Rot is the rotation matrix, Trans the translation.  If r is a 3 x 1, then
%  r_head = Rot*r + Trans  rotates and translates r from device coordinates
%  to patient coordinates.  The patient coordinates are established by
%  Cardinal, and the HPI coils are given in both the patient and device
%  coordinates.  Sensor_info loads up the device location and three cosine
%  directions for each gradiometer pad.  
% 
% See also SENSOR_122

%<autobegin> ---------------------- 26-May-2004 11:30:50 -----------------------
% --------- Automatically Generated Comments Block Using AUTO_COMMENTS ---------
%
% CATEGORY: Data Processing
%
% Alphabetical list of external functions (non-Matlab):
%   toolbox\sensor_122.m
%
% At Check-in: $Author: Mosher $  $Revision: 13 $  $Date: 5/26/04 9:59a $
%
% This software is part of BrainStorm Toolbox Version 2.0 (Alpha) 24-May-2004
% 
% Principal Investigators and Developers:
% ** Richard M. Leahy, PhD, Signal & Image Processing Institute,
%    University of Southern California, Los Angeles, CA
% ** John C. Mosher, PhD, Biophysics Group,
%    Los Alamos National Laboratory, Los Alamos, NM
% ** Sylvain Baillet, PhD, Cognitive Neuroscience & Brain Imaging Laboratory,
%    CNRS, Hopital de la Salpetriere, Paris, France
% 
% See BrainStorm website at http://neuroimage.usc.edu for further information.
% 
% Copyright (c) 2004 BrainStorm by the University of Southern California
% This software distributed  under the terms of the GNU General Public License
% as published by the Free Software Foundation. Further details on the GPL
% license can be found at http://www.gnu.org/copyleft/gpl.html .
% 
% FOR RESEARCH PURPOSES ONLY. THE SOFTWARE IS PROVIDED "AS IS," AND THE
% UNIVERSITY OF SOUTHERN CALIFORNIA AND ITS COLLABORATORS DO NOT MAKE ANY
% WARRANTY, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO WARRANTIES OF
% MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, NOR DO THEY ASSUME ANY
% LIABILITY OR RESPONSIBILITY FOR THE USE OF THIS SOFTWARE.
%<autoend> ------------------------ 26-May-2004 11:30:50 -----------------------

% ----------------------------- Script History ---------------------------------
% 19-May-2004 JCM  Comments cleaning
% ----------------------------- Script History ---------------------------------


if(exist('verbose') ~= 1),
  verbose = 1;			% talkative running
end

fid = fopen(fname,'rt');	% text mode all platforms

if(fid < 0),
  error(['Unable to open file ' fname])
end

next_line = fgetl(fid);
if(verbose)
  disp(next_line)
end
key_word = sscanf(next_line,'%s ',1);

while(~strcmp(key_word,'cardinal')),
  next_line = fgetl(fid);
  if(verbose)
    disp(next_line)
  end
  key_word = sscanf(next_line,'%s ',1);
end				% found keyword CARDINAL

for i = 1:3,
  Cardinal(i,:) = sscanf(next_line,'cardinal %*d %f %f %f')';
  next_line = fgetl(fid);
end
if(verbose)
  disp('Read three CARDINAL lines')
end

for i = 1:3,
  HPI_patient(i,:) = sscanf(next_line,'hpi %*d %f %f %f')';
  next_line = fgetl(fid);
end
if(verbose)
  disp('Read three HPI lines')
end

% so what is the next line?
key_word = sscanf(next_line,'%s ',1);

Extra = [];
while(strcmp(key_word,'extra')), % we have Extra head points
  tmp = sscanf(next_line,'extra %*d %f %f %f')';
  if(isempty(tmp)),
    disp(next_line)
  end
  
  Extra = [Extra;tmp];
  next_line = fgetl(fid);
  key_word = sscanf(next_line,'%s ',1);
end
if(verbose),
  disp(sprintf('Read %.0f lines of Extra head points',size(Extra,1)));
end

% we are now entering the region where the hpi in device is listed

while(~strcmp(key_word,'hpi'))
  next_line = fgetl(fid);
  key_word = sscanf(next_line,'%s ',1);
  if(verbose),
    disp(next_line)
  end
end

for i = 1:3,
  HPI_device(i,:) = sscanf(next_line,'hpi %*d %f %f %f')';
  next_line = fgetl(fid);
end

if(verbose),
  disp('Read in three hpi locations in device coords')
end

% now find the transformation matrix

key_word = sscanf(next_line,'%s ',1);
while(strcmp(key_word,'#'))
  next_line = fgetl(fid);
  key_word = sscanf(next_line,'%s ',1);
  if(verbose),
    disp(next_line)
  end
end

for i = 1:3,
  Rot(i,:) = sscanf(next_line,'%f %f %f')';
  next_line = fgetl(fid);
end
Trans = sscanf(next_line,'%f %f %f');
if(verbose),
  disp('Loaded in rotation and translation information')
end

% now load in the sensor position information

next_line = fgetl(fid);
key_word = sscanf(next_line,'%s ',1);
while(strcmp(key_word,'#'))
  next_line = fgetl(fid);
  key_word = sscanf(next_line,'%s ',1);
  if(verbose),
    disp(next_line)
  end
end
if(verbose),
  disp('Now loading in sensor information')
end

Sensor_info = [];

while(next_line ~= -1),
  Sensor_info = [Sensor_info;sscanf(next_line,'%f ',12)'];
  fgetl(fid);
  fgetl(fid);
  fgetl(fid);
  next_line = fgetl(fid);
  if(verbose),
    disp(next_line)
  end
end

fclose(fid);

[Rcoils,Ocoils] = sensor_122(Sensor_info);

Rcoils(:,1:3) = [Rot*Rcoils(:,1:3)' + Trans*ones(1,size(Rcoils,1))]';
Rcoils(:,4:6) = [Rot*Rcoils(:,4:6)' + Trans*ones(1,size(Rcoils,1))]';

Ocoils(:,1:3) = [Rot*Ocoils(:,1:3)']';
Ocoils(:,4:6) = [Rot*Ocoils(:,4:6)']';

return
