function FV = load_smf(fname);
%LOAD_SMF - Load a simply written SMF file into the faces vertices structure
% function FV = load_smf(fname);
%
% Each line is one of
% # comment
% f <i> <j> <k>
% v <x> <y> <z>
% otherwise the line is ignored
%
% See also LOAD_SMF

%<autobegin> ---------------------- 26-May-2004 11:30:51 -----------------------
% --------- Automatically Generated Comments Block Using AUTO_COMMENTS ---------
%
% CATEGORY: Data Processing
%
% At Check-in: $Author: Mosher $  $Revision: 4 $  $Date: 5/26/04 10:29a $
%
% This software is part of BrainStorm Toolbox Version 2.0 (Alpha) 24-May-2004
% 
% Principal Investigators and Developers:
% ** Richard M. Leahy, PhD, Signal & Image Processing Institute,
%    University of Southern California, Los Angeles, CA
% ** John C. Mosher, PhD, Biophysics Group,
%    Los Alamos National Laboratory, Los Alamos, NM
% ** Sylvain Baillet, PhD, Cognitive Neuroscience & Brain Imaging Laboratory,
%    CNRS, Hopital de la Salpetriere, Paris, France
% 
% See BrainStorm website at http://neuroimage.usc.edu for further information.
% 
% Copyright (c) 2004 BrainStorm by the University of Southern California
% This software distributed  under the terms of the GNU General Public License
% as published by the Free Software Foundation. Further details on the GPL
% license can be found at http://www.gnu.org/copyleft/gpl.html .
% 
% FOR RESEARCH PURPOSES ONLY. THE SOFTWARE IS PROVIDED "AS IS," AND THE
% UNIVERSITY OF SOUTHERN CALIFORNIA AND ITS COLLABORATORS DO NOT MAKE ANY
% WARRANTY, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO WARRANTIES OF
% MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, NOR DO THEY ASSUME ANY
% LIABILITY OR RESPONSIBILITY FOR THE USE OF THIS SOFTWARE.
%<autoend> ------------------------ 26-May-2004 11:30:51 -----------------------


% Author: John C. Mosher, Ph.D.

% ----------------------------- Script History ---------------------------------
% JCM 24-May-2004  Creation
% ----------------------------- Script History ---------------------------------

fid = fopen(fname,'rt');

% preallocate
FV.faces = zeros(200000,3);
FV.vertices = zeros(100000,3);
iV = 0; % initialize vertices counter
iF = 0; % faces counter
while 1
   tline = fgetl(fid);
   if ~ischar(tline),
      break
   end
   
   [OP,ARG] = strtok(tline);
   
   switch OP
      case {'begin','end'}
         % ignore
      case 'v'
         iV = iV + 1;
         FV.vertices(iV,:) = sscanf(ARG,'%g %g %g')';
      case 'f'
         iF = iF + 1;
         FV.faces(iF,:) = sscanf(ARG,'%f %f %f')';
      case '#'
         % comment line
         disp(tline);
      otherwise
         % do nothing
   end
end

fclose(fid);

FV.vertices = FV.vertices(1:iV,:);
FV.faces = FV.faces(1:iF,:);
