function make_default_study(STUDY,SUBJECT);
%MAKE_DEFAULT_STUDY - Create simulated default data and link to a simulated subject
% function make_default_study(STUDY,SUBJECT);
% 
% Invokes the simulator and stores a simulated data set in the STUDY folder,
%  linked to an assumed default data set in the SUBJECT folder.
% STUDY and SUBJECT should be referential to the current database
%
% See also MAKE_DEFAULT_DATABASE, MAKE_DEFAULT_SUBJECT

%<autobegin> ---------------------- 12-Oct-2004 01:11:23 -----------------------
% --------- Automatically Generated Comments Block Using AUTO_COMMENTS ---------
%
% CATEGORY: Database Management
%
% Alphabetical list of external functions (non-Matlab):
%   toolbox\bst_headmodeler.m
%   toolbox\bst_message_window.m
%   toolbox\get_user_directory.m
%   toolbox\hanning_window.m
%   toolbox\simulator.m
%
% Application data and their calls in this file:
%   'SourceLoc'
%   'SourceOrientation'
%   'TimeSeries'
%   
%   setappdata(fig,'SourceLoc',SourceLoc);
%   setappdata(fig,'SourceOrientation',SourceOrientation);
%   setappdata(fig,'TimeSeries',TimeSeries);
%   
%   set(getappdata(0,'BrainStormMessageWindow'),'pointer','arrow');
%   set(getappdata(0,'BrainStormMessageWindow'),'pointer','watch');
%
% At Check-in: $Author: Mosher $  $Revision: 16 $  $Date: 10/11/04 11:33p $
%
% This software is part of BrainStorm Toolbox Version 2.0 (Alpha) 23-Sep-2004
% 
% Principal Investigators and Developers:
% ** Richard M. Leahy, PhD, Signal & Image Processing Institute,
%    University of Southern California, Los Angeles, CA
% ** John C. Mosher, PhD, Biophysics Group,
%    Los Alamos National Laboratory, Los Alamos, NM
% ** Sylvain Baillet, PhD, Cognitive Neuroscience & Brain Imaging Laboratory,
%    CNRS, Hopital de la Salpetriere, Paris, France
% 
% See BrainStorm website at http://neuroimage.usc.edu for further information.
% 
% Copyright (c) 2004 BrainStorm by the University of Southern California
% This software distributed  under the terms of the GNU General Public License
% as published by the Free Software Foundation. Further details on the GPL
% license can be found at http://www.gnu.org/copyleft/gpl.html .
% 
% FOR RESEARCH PURPOSES ONLY. THE SOFTWARE IS PROVIDED "AS IS," AND THE
% UNIVERSITY OF SOUTHERN CALIFORNIA AND ITS COLLABORATORS DO NOT MAKE ANY
% WARRANTY, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO WARRANTIES OF
% MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, NOR DO THEY ASSUME ANY
% LIABILITY OR RESPONSIBILITY FOR THE USE OF THIS SOFTWARE.
%<autoend> ------------------------ 12-Oct-2004 01:11:23 -----------------------


% ----------------------------- Script History ---------------------------------
% JCM 06-Nov-2002  First design
% JCM 11-Sep-2003  updating to be consistent with make_default_database
% JCM 11-Oct-2004  changed hanning to be BST function hanning_window
% ----------------------------- Script History ---------------------------------


bst_message_window('append','WAIT: Generating simulated data . . .');

fig = simulator; % create the simulator GUI
handles = guihandles(fig); % get all of the handles to it

set(fig,'pointer','watch');
set(getappdata(0,'BrainStormMessageWindow'),'pointer','watch');
drawnow

% set the app data in the simulator, it handles the rest
% Default cortex is 75 - 79 mm.
SourceLoc = {[0 0 75]'/1000,[20 20 70]'/1000,[-20 -20 70]'/1000};
SourceOrientation = {[1 0 0]',[1 -1 0]'/norm([1 1 0]) [-1 1 0]'/norm([-1 1 0])};
TimeSeries = [[hanning_window(50);zeros(50,1)], [zeros(25,1);hanning_window(50);zeros(25,1)], ...
      [zeros(50,1);hanning_window(50)]] * 10e-9; % A-m


setappdata(fig,'SourceLoc',SourceLoc);
setappdata(fig,'SourceOrientation',SourceOrientation);
setappdata(fig,'TimeSeries',TimeSeries);

% reinitialize the simulator with the above locations
simulator('initialize_gui',fig, [], handles);

% set the location
set(handles.edit_data_folder_name,'string',STUDY);
set(handles.edit_data_root_name,'string','sphere_');

% activate as if the button was pushed
simulator('pushbutton_generate_Callback',handles.pushbutton_generate,[],handles,[]);

% data are now created in the current database, in the STUDY folder.

% make the brainstormstudy file
% SUBJECT should be referential to the current database
BrainStormSubject = fullfile(SUBJECT,'sphere_brainstormsubject.mat');
Session = 'Simulated Sphere Data';
DateOfStudy = datestr(now);
DateOfModification = datestr(now);
Name = 'Default Data';

User = get_user_directory;

cd(User.STUDIES) % the root location of the data
cd(STUDY) % the requested folder
save('sphere_brainstormstudy.mat','Session','BrainStormSubject',...
   'DateOfStudy','DateOfModification','Name');

% clear the windows and watch
close(fig); % clear the simulator fig

% make a headmodel

bst_message_window('wrap',{...
      'Computing head model for study: ',...
      'sphere_brainstormstudy',...
      'with default parameters',...
   });

OPTIONS.HeadModelFile = 'Default';
bst_headmodeler(fullfile(STUDY,'sphere_brainstormstudy.mat'),OPTIONS);


set(getappdata(0,'BrainStormMessageWindow'),'pointer','arrow');
