function make_default_subject(SUBJECT);
%MAKE_DEFAULT_SUBJECT - Make a brainstormsubject and simulated MRI in a folder
% function make_default_subject(SUBJECT);
% 
% Creates a brainstormsubject complete with simulated spherical MRI in the
% SUBJECT folder, such as the default_subject folder.
% SUBJECT should be a referential name, called from the current subject root
%  location.
%
% See also MAKE_DEFAULT_DATABASE, MAKE_DEFAULT_STUDY

%<autobegin> ---------------------- 26-May-2004 11:30:52 -----------------------
% --------- Automatically Generated Comments Block Using AUTO_COMMENTS ---------
%
% CATEGORY: Database Management
%
% Alphabetical list of external functions (non-Matlab):
%   toolbox\bst_message_window.m
%   toolbox\get_user_directory.m
%   toolbox\simulator_mri.m
%
% Application data and their calls in this file:
%   set(getappdata(0,'BrainStormMessageWindow'),'pointer','arrow');
%   set(getappdata(0,'BrainStormMessageWindow'),'pointer','watch');
%
% At Check-in: $Author: Mosher $  $Revision: 16 $  $Date: 5/26/04 9:59a $
%
% This software is part of BrainStorm Toolbox Version 2.0 (Alpha) 24-May-2004
% 
% Principal Investigators and Developers:
% ** Richard M. Leahy, PhD, Signal & Image Processing Institute,
%    University of Southern California, Los Angeles, CA
% ** John C. Mosher, PhD, Biophysics Group,
%    Los Alamos National Laboratory, Los Alamos, NM
% ** Sylvain Baillet, PhD, Cognitive Neuroscience & Brain Imaging Laboratory,
%    CNRS, Hopital de la Salpetriere, Paris, France
% 
% See BrainStorm website at http://neuroimage.usc.edu for further information.
% 
% Copyright (c) 2004 BrainStorm by the University of Southern California
% This software distributed  under the terms of the GNU General Public License
% as published by the Free Software Foundation. Further details on the GPL
% license can be found at http://www.gnu.org/copyleft/gpl.html .
% 
% FOR RESEARCH PURPOSES ONLY. THE SOFTWARE IS PROVIDED "AS IS," AND THE
% UNIVERSITY OF SOUTHERN CALIFORNIA AND ITS COLLABORATORS DO NOT MAKE ANY
% WARRANTY, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO WARRANTIES OF
% MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, NOR DO THEY ASSUME ANY
% LIABILITY OR RESPONSIBILITY FOR THE USE OF THIS SOFTWARE.
%<autoend> ------------------------ 26-May-2004 11:30:52 -----------------------


% History ---------------------------------
% JCM 06-Nov-2002  First design
% JCM 11-Sep-2003  Updating to be consistent with make_default_database
% JCM 26-Apr-2003  Updating to work with Baillet bst_mriviewer instead of
%                  mri_read_tool (AOS version).
% ---------------------------------

bst_message_window('append','WAIT: Generating simulated MRI . . .');

fig = simulator_mri; % generate the MRI simulator
handles = guihandles(fig); % get all of its handles

set(fig,'pointer','watch');
set(getappdata(0,'BrainStormMessageWindow'),'pointer','watch');
drawnow

set(handles.edit_folder_name,'String',SUBJECT); % the name of the Default Subject folder
set(handles.edit_file_name,'String','sphere'); % name of the subject

% activate as if the button was pushed
simulator_mri('pushbutton_generate_Callback',handles.pushbutton_generate,[],handles,[]);
% the sphere_subjectimage is now created in the SUBJECT folder of the current database

% Now we establish the SCS by using the existing routines
% New Baillet system is easy, no need to recompute
if 0 % AOS MRI Read tool routines
	% now get this MRI into the existing BrainStorm coordinate system
	% open the MRI Read Tool
	fig_mri = mri_read_tool;
	fig_mri_handles = guihandles(fig_mri);
	% Load in the image
	mri_read_tool('readbs_Callback',fig_mri_handles.Hloadbsformat,[],fig_mri_handles,...
		fullfile('default_subject',filesep,'sphere_subjectimage.mat'));
	% Define the PCS in CTF using the 4 2 1 points as Nasion, Left PA, Right PA
	mri_read_tool('definepcs_Callback',fig_mri_handles.definepcs,[],fig_mri_handles,...
		[4 1 2]',1)
	% Now save it out
	FNAME = fullfile(pwd,'sphere_subjectimage.mat');
	mri_read_tool('savemrscans_Callback',fig_mri_handles.savemrscans,[],fig_mri_handles,FNAME);
	% now close the mri read tool
	close(fig_mri);
end


% make the brainstormsubject file
Tesselation = []; % keep empty
Anatomy = fullfile(SUBJECT,'sphere_subjectimage.mat');
Comments = 'MRI of a sphere';
DateOfAcquisition = datestr(now);
DateOfModification = datestr(now);
Name = 'Default Spherical Subject';

User = get_user_directory;

cd(User.SUBJECTS) % the root location of the data
cd(SUBJECT) % the requested subject folder
save('sphere_brainstormsubject.mat','Tesselation','Anatomy',...
   'Comments','DateOfAcquisition','DateOfModification','Name');

% clear the windows and watch
close(fig); % clear the simulator fig
set(getappdata(0,'BrainStormMessageWindow'),'pointer','arrow');

