function newverts = patch_swell(iverts,vconn);
%PATCH_SWELL - enlarge a patch by appending the next set of adjacent vertices
% function newverts = patch_swell(iverts,vconn);
% iverts is an index list of vertex numbers, will be converted to a row vec.
% vconn is the cell array of vertex connectivity
% newverts is the row vec list of NEW vertex numbers adjacent the patch
% Concatenate to swell the patch: patch = [patch(:)' patch_swell(patch,vconn)];

%<autobegin> ---------------------- 26-May-2004 11:34:07 -----------------------
% --------- Automatically Generated Comments Block Using AUTO_COMMENTS ---------
%
% CATEGORY: Visualization
%
% At Check-in: $Author: Mosher $  $Revision: 12 $  $Date: 5/26/04 10:02a $
%
% This software is part of BrainStorm Toolbox Version 2.0 (Alpha) 24-May-2004
% 
% Principal Investigators and Developers:
% ** Richard M. Leahy, PhD, Signal & Image Processing Institute,
%    University of Southern California, Los Angeles, CA
% ** John C. Mosher, PhD, Biophysics Group,
%    Los Alamos National Laboratory, Los Alamos, NM
% ** Sylvain Baillet, PhD, Cognitive Neuroscience & Brain Imaging Laboratory,
%    CNRS, Hopital de la Salpetriere, Paris, France
% 
% See BrainStorm website at http://neuroimage.usc.edu for further information.
% 
% Copyright (c) 2004 BrainStorm by the University of Southern California
% This software distributed  under the terms of the GNU General Public License
% as published by the Free Software Foundation. Further details on the GPL
% license can be found at http://www.gnu.org/copyleft/gpl.html .
% 
% FOR RESEARCH PURPOSES ONLY. THE SOFTWARE IS PROVIDED "AS IS," AND THE
% UNIVERSITY OF SOUTHERN CALIFORNIA AND ITS COLLABORATORS DO NOT MAKE ANY
% WARRANTY, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO WARRANTIES OF
% MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, NOR DO THEY ASSUME ANY
% LIABILITY OR RESPONSIBILITY FOR THE USE OF THIS SOFTWARE.
%<autoend> ------------------------ 26-May-2004 11:34:07 -----------------------


% John C. Mosher, Ph.D. 
% See Copyright file for information
% $Date: 5/26/04 10:02a $ $Revision: 12 $

[m,n] = size(iverts);
if(m~=1),
  iverts = iverts(:)'; % ensure row vector
end

% concatenate all vertex connections for all verts
newverts = [vconn{iverts}];

% extract unique set of indices, remove existing vertices
newverts = setdiff(newverts,iverts);

return
