function h = plot3d(x,p1,p2,p3,p4,p5,p6,p7,p8,p9,p10,p11,p12,p13,p14);
%PLOT3D - 'plot3' the given three column data
% function h = plot3d(x,p1,p2,p3,p4,p5,p6,p7,p8,p9,p10,p11,p12,p13,p14);
% x is n*three columns wide, parameters p1-p14 are optional standard plot3
%  parameters.  h is the handle returned by plot3
% The first three columns of x are plotted as one set, then the next three,
%  etc.

%<autobegin> ---------------------- 26-May-2004 11:34:08 -----------------------
% --------- Automatically Generated Comments Block Using AUTO_COMMENTS ---------
%
% CATEGORY: Visualization
%
% At Check-in: $Author: Mosher $  $Revision: 13 $  $Date: 5/26/04 10:02a $
%
% This software is part of BrainStorm Toolbox Version 2.0 (Alpha) 24-May-2004
% 
% Principal Investigators and Developers:
% ** Richard M. Leahy, PhD, Signal & Image Processing Institute,
%    University of Southern California, Los Angeles, CA
% ** John C. Mosher, PhD, Biophysics Group,
%    Los Alamos National Laboratory, Los Alamos, NM
% ** Sylvain Baillet, PhD, Cognitive Neuroscience & Brain Imaging Laboratory,
%    CNRS, Hopital de la Salpetriere, Paris, France
% 
% See BrainStorm website at http://neuroimage.usc.edu for further information.
% 
% Copyright (c) 2004 BrainStorm by the University of Southern California
% This software distributed  under the terms of the GNU General Public License
% as published by the Free Software Foundation. Further details on the GPL
% license can be found at http://www.gnu.org/copyleft/gpl.html .
% 
% FOR RESEARCH PURPOSES ONLY. THE SOFTWARE IS PROVIDED "AS IS," AND THE
% UNIVERSITY OF SOUTHERN CALIFORNIA AND ITS COLLABORATORS DO NOT MAKE ANY
% WARRANTY, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO WARRANTIES OF
% MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, NOR DO THEY ASSUME ANY
% LIABILITY OR RESPONSIBILITY FOR THE USE OF THIS SOFTWARE.
%<autoend> ------------------------ 26-May-2004 11:34:08 -----------------------

% ----------------------------- Script History ---------------------------------
% Author 1995 by John C. Mosher
% March 3, 1995 author
% 19-May-2004 JCM Comments Cleaning
% ----------------------------- Script History ---------------------------------

cols = size(x,2);		% number of columns

s = 'hp = plot3(x(:,1:3:cols),x(:,2:3:cols),x(:,3:3:cols)'; % basic string

for i = 1:(nargin-1),		% if extra parameters given
  s = [s sprintf(',p%.0f',i)];  % add next parameter
end

s = [s ');'];			% close off plot3 command

eval(s);			% do it!
if(nargout),			% user wanted handle
  h = hp;
end

return
