function plot_dipole(r,n,s,c)
%PLOT_DIPOLE - (r,n,s,c)
% function plot_dipole(r,n,s,c)
% r=[x y z] dipole location
% n=[nx ny nz] dipole orientation + strength ; this is not normalized!
% s=scale factor to adapt size of dipole
% c=[r g b] color
% (c)2003 Felix Darvas, Ph.D.
% Signal & Image Processing Institute
% USC

%<autobegin> ---------------------- 26-May-2004 11:34:08 -----------------------
% --------- Automatically Generated Comments Block Using AUTO_COMMENTS ---------
%
% CATEGORY: Visualization
%
% At Check-in: $Author: Mosher $  $Revision: 11 $  $Date: 5/26/04 10:02a $
%
% This software is part of BrainStorm Toolbox Version 2.0 (Alpha) 24-May-2004
% 
% Principal Investigators and Developers:
% ** Richard M. Leahy, PhD, Signal & Image Processing Institute,
%    University of Southern California, Los Angeles, CA
% ** John C. Mosher, PhD, Biophysics Group,
%    Los Alamos National Laboratory, Los Alamos, NM
% ** Sylvain Baillet, PhD, Cognitive Neuroscience & Brain Imaging Laboratory,
%    CNRS, Hopital de la Salpetriere, Paris, France
% 
% See BrainStorm website at http://neuroimage.usc.edu for further information.
% 
% Copyright (c) 2004 BrainStorm by the University of Southern California
% This software distributed  under the terms of the GNU General Public License
% as published by the Free Software Foundation. Further details on the GPL
% license can be found at http://www.gnu.org/copyleft/gpl.html .
% 
% FOR RESEARCH PURPOSES ONLY. THE SOFTWARE IS PROVIDED "AS IS," AND THE
% UNIVERSITY OF SOUTHERN CALIFORNIA AND ITS COLLABORATORS DO NOT MAKE ANY
% WARRANTY, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO WARRANTIES OF
% MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, NOR DO THEY ASSUME ANY
% LIABILITY OR RESPONSIBILITY FOR THE USE OF THIS SOFTWARE.
%<autoend> ------------------------ 26-May-2004 11:34:08 -----------------------

[xc,yc,zc]=cylinder;
[xs,ys,zs]=sphere;
xs=xs*s;
ys=ys*s;
zs=zs*s;
xc=xc*s/2;
yc=yc*s/2;
zc=zc*3*s*norm(n); % 4 is a scale for length of dipole
zc=zc+s/2;
nn=n/norm(n);

xcc=reshape(xc,prod(size(xc)),1);
ycc=reshape(yc,prod(size(yc)),1);
zcc=reshape(zc,prod(size(zc)),1);


alpha=acos(nn(1));
beta=acos(nn(2));
gamma=acos(nn(3));
R1=[1 0 0; 0 nn(1) sqrt(1-nn(1)^2);0 -sqrt(1-nn(1)^2) nn(1)];
R2=[nn(2) 0 -sqrt(1-nn(2)^2);0 1 0;sqrt(1-nn(2)^2) 0 nn(2)];
R3=[nn(3) sqrt(1-nn(3)^2) 0;-sqrt(1-nn(3)^2) nn(3) 0;0 0 1];

RR=R1*R2*R3;
rr=(RR*[xcc ycc zcc]')';
xcc=rr(:,1);ycc=rr(:,2);zcc=rr(:,3);
xc=reshape(xcc,size(xc,1),size(xc,2));
yc=reshape(ycc,size(yc,1),size(yc,2));
zc=reshape(zcc,size(zc,1),size(zc,2));

xs=xs+r(1);
xc=xc+r(1);
ys=ys+r(2);
yc=yc+r(2);
zs=zs+r(3);
zc=zc+r(3);
hold on
s = surf(xc,yc,zc);
set(s,'EdgeColor','none','FaceColor',c);
hold on
s = surf(xs,ys,zs);
set(s,'EdgeColor','none','FaceColor',c);
hold off
