function G = read_gain(FILENAME,chanID,srcID);
%READ_GAIN - Extract parts or a compete gain matrix from .bin binay gain file 
%function G = read_gain(FILENAME,chanID,srcID);
% Extract parts or a compete gain matrix from .bin binay gain file 
% The gain matrix file must be in the BrainStorm binary file format.
%
% INPUTS 
%        FILENAME: a character string describing the name of the file containing the matrix 
%        chanID  : Optional vector of indices linked to the ROWS of the matrix (ie channels) to be extracted 
%                  If chanID is LEFT EMPTY, the matrix is extracted for all channels
%        srcID   : Optional vector of indices linked to the COLUMNS of the matrix to be extracted 
%                  If srcID is LEFT EMPTY, matrix is extracted for all sources
% OUTPUT
%        G       : an array containing the forward fields of the gain (sub)matrix.
%
% See also GET_GAIN, LOAD_RAW, SAVE_RAW

%<autobegin> ---------------------- 08-Jun-2004 15:12:54 -----------------------
% --------- Automatically Generated Comments Block Using AUTO_COMMENTS ---------
%
% CATEGORY: Forward Modeling
%
% Alphabetical list of external functions (non-Matlab):
%   toolbox\get_gain.m
%   toolbox\get_user_directory.m
%
% At Check-in: $Author: Mosher $  $Revision: 18 $  $Date: 6/08/04 1:39p $
%
% This software is part of BrainStorm Toolbox Version 2.0 (Alpha) 28-May-2004
% 
% Principal Investigators and Developers:
% ** Richard M. Leahy, PhD, Signal & Image Processing Institute,
%    University of Southern California, Los Angeles, CA
% ** John C. Mosher, PhD, Biophysics Group,
%    Los Alamos National Laboratory, Los Alamos, NM
% ** Sylvain Baillet, PhD, Cognitive Neuroscience & Brain Imaging Laboratory,
%    CNRS, Hopital de la Salpetriere, Paris, France
% 
% See BrainStorm website at http://neuroimage.usc.edu for further information.
% 
% Copyright (c) 2004 BrainStorm by the University of Southern California
% This software distributed  under the terms of the GNU General Public License
% as published by the Free Software Foundation. Further details on the GPL
% license can be found at http://www.gnu.org/copyleft/gpl.html .
% 
% FOR RESEARCH PURPOSES ONLY. THE SOFTWARE IS PROVIDED "AS IS," AND THE
% UNIVERSITY OF SOUTHERN CALIFORNIA AND ITS COLLABORATORS DO NOT MAKE ANY
% WARRANTY, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO WARRANTIES OF
% MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, NOR DO THEY ASSUME ANY
% LIABILITY OR RESPONSIBILITY FOR THE USE OF THIS SOFTWARE.
%<autoend> ------------------------ 08-Jun-2004 15:12:54 -----------------------


% \------------------------------------------------------/
% | *** Sylvain Baillet, Ph.D.                           |
% | Cognitive Neuroscience & Brain Imaging Laboratory    |
% | CNRS UPR640 - LENA                                   | 
% | Hopital de la Salpetriere, Paris, France             |
% | sylvain.baillet@chups.jussieu.fr                     |
% \------------------------------------------------------/
%  
% Date of creation: October 2002 
% Script History -----------------------------------------------------------------------------------
% JCM 27-May-2004  Comments updating
%---------------------------------------------------------------------------------------------------


% Open the file
fid = fopen(FILENAME ,'r','ieee-be'); 
if fid < 0
    Users = get_user_directory;
    cd(Users.STUDIES)
    fid = fopen(FILENAME ,'r','ieee-be'); 
end

if fid < 0 
   errordlg([FILENAME,' is not in current directory or in the Matlab search path.'],'HeadModel file was not found.');
   return
end

if nargin == 1
   G = get_gain(fid);
elseif nargin == 2
   G = get_gain(fid,srcID);
elseif nargin == 3
   if isempty(srcID) % ChanID is defined but srcID is left blank
      G = get_gain(fid);
   else
      G = get_gain(fid,srcID);
   end
   if ~isempty(chanID)
       G = G(chanID,:); % Keep only channels of interest
   end
end

fclose(fid);


  
