function NFV=readdsgl(s)
%READDSGL - Loads a BrainSuite .dsgl format tessellation file.
% function NFV=readdsgl(s)
%   NFV = READDSGL(FILENAME) loads the file specified by FILENAME string.
%
% NFV has the following structure:
%   NFV.faces    : the face data,
%   NFV.vertices : the face data,
%   NFV.res      : voxel dimensions [xres yres zres]'
% Examples
%   outerskull = readdsgl('outerskull.dsgl');

%<autobegin> ---------------------- 26-May-2004 11:34:13 -----------------------
% --------- Automatically Generated Comments Block Using AUTO_COMMENTS ---------
%
% CATEGORY: Data Processing
%
% At Check-in: $Author: Mosher $  $Revision: 12 $  $Date: 5/26/04 10:02a $
%
% This software is part of BrainStorm Toolbox Version 2.0 (Alpha) 24-May-2004
% 
% Principal Investigators and Developers:
% ** Richard M. Leahy, PhD, Signal & Image Processing Institute,
%    University of Southern California, Los Angeles, CA
% ** John C. Mosher, PhD, Biophysics Group,
%    Los Alamos National Laboratory, Los Alamos, NM
% ** Sylvain Baillet, PhD, Cognitive Neuroscience & Brain Imaging Laboratory,
%    CNRS, Hopital de la Salpetriere, Paris, France
% 
% See BrainStorm website at http://neuroimage.usc.edu for further information.
% 
% Copyright (c) 2004 BrainStorm by the University of Southern California
% This software distributed  under the terms of the GNU General Public License
% as published by the Free Software Foundation. Further details on the GPL
% license can be found at http://www.gnu.org/copyleft/gpl.html .
% 
% FOR RESEARCH PURPOSES ONLY. THE SOFTWARE IS PROVIDED "AS IS," AND THE
% UNIVERSITY OF SOUTHERN CALIFORNIA AND ITS COLLABORATORS DO NOT MAKE ANY
% WARRANTY, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO WARRANTIES OF
% MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, NOR DO THEY ASSUME ANY
% LIABILITY OR RESPONSIBILITY FOR THE USE OF THIS SOFTWARE.
%<autoend> ------------------------ 26-May-2004 11:34:13 -----------------------

% Author : David Shattuck (shattuck@sipi.usc.edu) 2000
% 29-May-2002 JCM : inclusion into BrainStorm MMII, some comments, formatting


fid=fopen(s,'rb','ieee-le');

if (fid<0),
   error('unable to open file'); 
end

magic1 = ['d' 's' 'g' 'l']';
magic2 = ['l' 'g' 's' 'd']';
magic = char(fread(fid,4,'char'));
if (magic~=magic1)

   if (magic==magic2)
   
      fclose(fid);
      fid=fopen(s,'rb','ieee-be');
      
      if (fid<0) 
         error('unable to open file'); 
      end
      
   end
   
end

NFV.origin = [0 0 0];
hsize=fread(fid,1,'int32');

if (hsize>44)
   version=char(fread(fid,8,'char'))';
end

ntris=fread(fid,1,'int32');
nverts=fread(fid,1,'int32');
nStripPoints=fread(fid,1,'int32');
NFV.res   = fread(fid,3,'float32');

if (hsize>44)
   NFV.origin = fread(fid,3,'float');
end

r=fseek(fid,hsize,-1);
if (r~=0) 
   error('file is truncated'); 
end

NFV.faces = fread(fid,[3 ntris  ],'int32')';
NFV.faces = NFV.faces + 1;
NFV.vertices = fread(fid,[3 nverts ],'float')';

fclose(fid);
