function SubSpace = regsubspace(GUI,U,S);
%REGSUBSPACE - Determine the subspace based on the regularization method
% function SubSpace = regsubspace(GUI,U,S);
% method is CASE Sensitive.
% See REGCHECK

%<autobegin> ---------------------- 26-May-2004 11:34:14 -----------------------
% --------- Automatically Generated Comments Block Using AUTO_COMMENTS ---------
%
% CATEGORY: Inverse Modeling
%
% At Check-in: $Author: Mosher $  $Revision: 12 $  $Date: 5/26/04 10:02a $
%
% This software is part of BrainStorm Toolbox Version 2.0 (Alpha) 24-May-2004
% 
% Principal Investigators and Developers:
% ** Richard M. Leahy, PhD, Signal & Image Processing Institute,
%    University of Southern California, Los Angeles, CA
% ** John C. Mosher, PhD, Biophysics Group,
%    Los Alamos National Laboratory, Los Alamos, NM
% ** Sylvain Baillet, PhD, Cognitive Neuroscience & Brain Imaging Laboratory,
%    CNRS, Hopital de la Salpetriere, Paris, France
% 
% See BrainStorm website at http://neuroimage.usc.edu for further information.
% 
% Copyright (c) 2004 BrainStorm by the University of Southern California
% This software distributed  under the terms of the GNU General Public License
% as published by the Free Software Foundation. Further details on the GPL
% license can be found at http://www.gnu.org/copyleft/gpl.html .
% 
% FOR RESEARCH PURPOSES ONLY. THE SOFTWARE IS PROVIDED "AS IS," AND THE
% UNIVERSITY OF SOUTHERN CALIFORNIA AND ITS COLLABORATORS DO NOT MAKE ANY
% WARRANTY, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO WARRANTIES OF
% MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, NOR DO THEY ASSUME ANY
% LIABILITY OR RESPONSIBILITY FOR THE USE OF THIS SOFTWARE.
%<autoend> ------------------------ 26-May-2004 11:34:14 -----------------------


% JCM 10/19/99 turned off lower and deblanking, since profiling showed
%  to be expensive
% $Date: 5/26/04 10:02a $ $Revision: 12 $

% JCM 12/2/99 changed eps to eps = 1e-7, because gain matrices written in single precision

eps = 1e-7;

switch GUI.REG % regularization switch
case 'Condition'
  
  S = diag(S);  % find only the non-zero values
  % and only those less than the condition value
  rnk = sum((S(1) ./ S(find(S))) <= GUI.Condition);
  
case 'Energy'
  
  cS= cumsum(diag(S).^2); % cumulative energy
  rnk = sum((cS ./ cS(end)) <= GUI.Energy);
  
case 'Tikhonov' % just keep all of the columns, to within tolerance
  % Tikhonov regularization, keeps non-null space
  %what's its rank? Assume more rows than columns
  tol = size(U,1) * S(1) * eps;
  rnk = sum(diag(S) > tol);
  
case 'None'
  
  %what's its rank? Assume more rows than columns
  tol = size(U,1) * S(1) * eps;
  rnk = sum(diag(S) > tol);
  
otherwise
  
  error(sprintf('Unknown regularization method: %s',GUI.REG))
  
end % regularization switch

SubSpace = U(:,1:rnk);

return
