function save_smf(fname,FV);
%SAVE_SMF - Save out a file in a simple form of the SMF format
% function save_smf(fname,FV);
% Writes out one line per vertex or face:
% v <x> <y> <z>
% f <i> <j> <k>
%
% See also LOAD_SMF

%<autobegin> ---------------------- 26-May-2004 11:34:18 -----------------------
% --------- Automatically Generated Comments Block Using AUTO_COMMENTS ---------
%
% CATEGORY: Data Processing
%
% At Check-in: $Author: Mosher $  $Revision: 4 $  $Date: 5/26/04 10:30a $
%
% This software is part of BrainStorm Toolbox Version 2.0 (Alpha) 24-May-2004
% 
% Principal Investigators and Developers:
% ** Richard M. Leahy, PhD, Signal & Image Processing Institute,
%    University of Southern California, Los Angeles, CA
% ** John C. Mosher, PhD, Biophysics Group,
%    Los Alamos National Laboratory, Los Alamos, NM
% ** Sylvain Baillet, PhD, Cognitive Neuroscience & Brain Imaging Laboratory,
%    CNRS, Hopital de la Salpetriere, Paris, France
% 
% See BrainStorm website at http://neuroimage.usc.edu for further information.
% 
% Copyright (c) 2004 BrainStorm by the University of Southern California
% This software distributed  under the terms of the GNU General Public License
% as published by the Free Software Foundation. Further details on the GPL
% license can be found at http://www.gnu.org/copyleft/gpl.html .
% 
% FOR RESEARCH PURPOSES ONLY. THE SOFTWARE IS PROVIDED "AS IS," AND THE
% UNIVERSITY OF SOUTHERN CALIFORNIA AND ITS COLLABORATORS DO NOT MAKE ANY
% WARRANTY, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO WARRANTIES OF
% MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, NOR DO THEY ASSUME ANY
% LIABILITY OR RESPONSIBILITY FOR THE USE OF THIS SOFTWARE.
%<autoend> ------------------------ 26-May-2004 11:34:18 -----------------------


% Author: John C. Mosher, Ph.D.

% ----------------------------- Script History ---------------------------------
% JCM 24-May-2004  Creation
% ----------------------------- Script History ---------------------------------


fid = fopen(fname,'wt');

for i = 1:size(FV.vertices,1),
   fprintf(fid,'v %.3f %.3f %.3f\n',FV.vertices(i,:));
end

for i = 1:size(FV.faces,1),
   fprintf(fid,'f %.0f %.0f %.0f\n',FV.faces(i,:));
end

fclose(fid);
