function [mriCoord] = scs2mri(MRI,scsCoord);
%SCS2MRI - transform SCS point coordinates (in mm) to MRI coordinate system (in mm) 
% function [mriCoord] = scs2mri(MRI,scsCoord);
%  function [scsCoord] = mri2scs(MRI,mriCoord);
%  MRI - a proper BrainStorm MRI structure (i.e. from any subjectimage file, with fiducial points 
%        and SCS system properly defined)
%  scsCoord - a 3xN matric of corresponding point coordinates in the SCS system (in mm)
%
%  mriCoord - a 3xN matrix of point coordinates in the MRI system (in mm)
%
%  Definition of original transform is the following:
%  Xscs = MRI.SCS.R Xmri + MRI.SCS.T ; 
%  (Xmri in mm)
%  

%<autobegin> ---------------------- 26-May-2004 11:34:18 -----------------------
% --------- Automatically Generated Comments Block Using AUTO_COMMENTS ---------
%
% CATEGORY: Utility - Numeric
%
% At Check-in: $Author: Mosher $  $Revision: 8 $  $Date: 5/26/04 10:02a $
%
% This software is part of BrainStorm Toolbox Version 2.0 (Alpha) 24-May-2004
% 
% Principal Investigators and Developers:
% ** Richard M. Leahy, PhD, Signal & Image Processing Institute,
%    University of Southern California, Los Angeles, CA
% ** John C. Mosher, PhD, Biophysics Group,
%    Los Alamos National Laboratory, Los Alamos, NM
% ** Sylvain Baillet, PhD, Cognitive Neuroscience & Brain Imaging Laboratory,
%    CNRS, Hopital de la Salpetriere, Paris, France
% 
% See BrainStorm website at http://neuroimage.usc.edu for further information.
% 
% Copyright (c) 2004 BrainStorm by the University of Southern California
% This software distributed  under the terms of the GNU General Public License
% as published by the Free Software Foundation. Further details on the GPL
% license can be found at http://www.gnu.org/copyleft/gpl.html .
% 
% FOR RESEARCH PURPOSES ONLY. THE SOFTWARE IS PROVIDED "AS IS," AND THE
% UNIVERSITY OF SOUTHERN CALIFORNIA AND ITS COLLABORATORS DO NOT MAKE ANY
% WARRANTY, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO WARRANTIES OF
% MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, NOR DO THEY ASSUME ANY
% LIABILITY OR RESPONSIBILITY FOR THE USE OF THIS SOFTWARE.
%<autoend> ------------------------ 26-May-2004 11:34:18 -----------------------

  
% /---Script Authors-------------------------------------\
% |  *** Sylvain Baillet, Ph.D.                          |
% |  Cognitive Neuroscience & Brain Imaging Laboratory   |
% |  CNRS UPR640 - LENA                                  | 
% |  Hopital de la Salpetriere, Paris, France            |
% |  sylvain.baillet@chups.jussieu.fr                    |
% |                                                      |
% |  *** Alexei Ossadtchi, Ph.D.                         |
% |  USC - SIPI                                          |
% |                                                      |
% \------------------------------------------------------/
%  
% Script History ---------------------------------------------------------------
% SB  15-Mar-2004 (BrainStorm v.1 update)
% Script History ---------------------------------------------------------------



% Memo
% FidNames0{1} = 'Nasion';
% FidNames0{2} = 'LEFT Preauricular';
% FidNames0{3} = 'RIGHT Preauricular';

if ~isfield(MRI,'SCS')
    errordlg({'MRI SCS was not defined or subjectimage file is from another version of BrainStorm',...
            'Please re-define the subject coordinate system on this MRI'},'MRI file error')
    return
end

mriCoord = ...
    inv(MRI.SCS.R) * (scsCoord - repmat(MRI.SCS.T,1,size(scsCoord,2)));

    

