function [Rcoil,Ocoil,x,y,z] = sensor_122(sensor_info);
%SENSOR_122 - Return the Neuromag 122 information
% function [Rcoil,Ocoil,x,y,z] = sensor_122(sensor_info);
% sensor_info is the 122 x 12 Neurmag information from an apos file.
% Leave null to use default information.
% Rcoil is the coil center, Ocoil is the orientation.
% Use plot3(x,y,z) to see the coils in three dimensions

%<autobegin> ---------------------- 26-May-2004 11:34:19 -----------------------
% --------- Automatically Generated Comments Block Using AUTO_COMMENTS ---------
%
% CATEGORY: Forward Modeling
%
% Subfunctions in this file, in order of occurrence in file:
%   cm = default_pos;
%
% At Check-in: $Author: Mosher $  $Revision: 12 $  $Date: 5/26/04 10:02a $
%
% This software is part of BrainStorm Toolbox Version 2.0 (Alpha) 24-May-2004
% 
% Principal Investigators and Developers:
% ** Richard M. Leahy, PhD, Signal & Image Processing Institute,
%    University of Southern California, Los Angeles, CA
% ** John C. Mosher, PhD, Biophysics Group,
%    Los Alamos National Laboratory, Los Alamos, NM
% ** Sylvain Baillet, PhD, Cognitive Neuroscience & Brain Imaging Laboratory,
%    CNRS, Hopital de la Salpetriere, Paris, France
% 
% See BrainStorm website at http://neuroimage.usc.edu for further information.
% 
% Copyright (c) 2004 BrainStorm by the University of Southern California
% This software distributed  under the terms of the GNU General Public License
% as published by the Free Software Foundation. Further details on the GPL
% license can be found at http://www.gnu.org/copyleft/gpl.html .
% 
% FOR RESEARCH PURPOSES ONLY. THE SOFTWARE IS PROVIDED "AS IS," AND THE
% UNIVERSITY OF SOUTHERN CALIFORNIA AND ITS COLLABORATORS DO NOT MAKE ANY
% WARRANTY, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO WARRANTIES OF
% MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, NOR DO THEY ASSUME ANY
% LIABILITY OR RESPONSIBILITY FOR THE USE OF THIS SOFTWARE.
%<autoend> ------------------------ 26-May-2004 11:34:19 -----------------------


if(nargin==0),
  sensor_info = [];
end

if(isempty(sensor_info)),	% load default information
    sensor_info = default_pos; % local function
else
  sensor_info = [[1:122]' sensor_info]; % original cm.pos format
end

% col 1 is the sensor number.  Col 2:4 is the position of the center, Col 5:7,
% x-axis, col 8:10, y-axis , col 11:13 z-axis.

% Center of coils is +/- 8.1 mm on x-axis.  Size of coil is 16.2 mm on a
%  side.

% Sensor origin, 0 0 0, is about [0 0 50 mm] on a standard,
%  fiducially-oriented patient coordinate system.

% y is out through the nasion.  x is out the right peri-ariculars
%  origin is at the perpendicular intersector of y with peri-aricular line


Rcenter = sensor_info(:,2:4);
Ux = sensor_info(:,5:7);			% unit x direction
Rcoil = [(Rcenter + (Ux * 8.1/1000)) (Rcenter - (Ux * 8.1/1000))];
Ocoil = [sensor_info(:,11:13) sensor_info(:,11:13)];	% directions


if(nargout > 2),		% give vertices for squares
  coilx = [0 16.2 16.2 0]'/1000;
  coily = [8.1 8.1 -8.1 -8.1]'/1000;
  coilz = zeros(4,1);
  coil = [coilx coily coilz];	% basic coil on "positive" side of sensor
  Uy = sensor_info(:,8:10);
  Uz = sensor_info(:,11:13);
  Ux = Ux';
  Uy = Uy';
  Uz = Uz';
  Ux = Ux(:)';
  Uy = Uy(:)';
  Uz = Uz(:)';
  Rotator = [Ux;Uy;Uz];
  
  % this formula will form the inverse rotator:
  %  Rotator = sensor_info(:,5:13)';
  %  Rotator = reshape(Rotator,3,size(Rotator,2)*3); % each submatrix of three
    % is now a rotator
  
  Rcenter = Rcenter'; 		% each column is now a position
  Rcenter = Rcenter(:)';	% each three cols is now a position
  Coil = [coil; [-coil(:,1) coil(:,2:3)]]*Rotator;
  Coil = Coil+ ones(8,1)*Rcenter; % centers
  ndx = [1:3:size(Coil,2)]; 	% x coordinates
  x = Coil(:,ndx);
  y = Coil(:,ndx+1);
  z = Coil(:,ndx+2);
end

return

function cm = default_pos;

%load in a default set of "apos" information on the Neuromag-122

cm = [...
1001  0.10900  0.00016 -0.03686  0.00000 -0.03767 -0.99929 -0.00124  0.99929 -0.03767  1.00000  0.00123 -0.00005 
1002  0.10900  0.00016 -0.03686 -0.00124  0.99931 -0.03706  0.00000  0.03706  0.99931  1.00000  0.00123 -0.00005 
1003  0.10893  0.00016  0.00380  0.03520 -0.03706 -0.99869 -0.00002  0.99931 -0.03708  0.99938  0.00133  0.03518 
1004  0.10893  0.00016  0.00381  0.00000  0.99929 -0.03767 -0.03520  0.03765  0.99867  0.99938  0.00133  0.03518 
1005  0.09884  0.00158  0.04401  0.40698 -0.03458 -0.91278  0.00081  0.99930 -0.03750  0.91343  0.01452  0.40673 
1006  0.09883  0.00158  0.04401  0.00062  0.99931 -0.03706 -0.40698  0.03410  0.91280  0.91343  0.01452  0.40673 
1007  0.10417  0.04107 -0.03478  0.03830 -0.03088 -0.99879 -0.19265  0.98054 -0.03771  0.98052  0.19386  0.03160 
1008  0.10417  0.04107 -0.03478 -0.19265  0.98054 -0.03767 -0.03829  0.03084  0.99879  0.98052  0.19386  0.03160 
1009  0.10291  0.04082  0.00620  0.03768 -0.03088 -0.99881 -0.19325  0.98043 -0.03761  0.98043  0.19444  0.03097 
1010  0.10291  0.04082  0.00620 -0.19325  0.98043 -0.03766 -0.03769  0.03094  0.99881  0.98043  0.19444  0.03097 
1011  0.09333  0.04162  0.04499  0.40234 -0.02530 -0.91514 -0.11357  0.99052 -0.07732  0.90842  0.13504  0.39565 
1012  0.09333  0.04162  0.04500 -0.11363  0.99052 -0.07719 -0.40233  0.02517  0.91515  0.90842  0.13504  0.39565
1013  0.07090  0.04349  0.07743  0.71198 -0.01173 -0.70210 -0.05092  0.99637 -0.06829  0.70035  0.08437  0.70880
1014  0.07090  0.04349  0.07742 -0.05127  0.99637 -0.06795 -0.71196  0.01125  0.70213  0.70035  0.08437  0.70880
1015  0.03819  0.04474  0.09903  0.92433 -0.02161 -0.38097  0.00112  0.99854 -0.05393  0.38158  0.04942  0.92301
1016  0.03819  0.04474  0.09903  0.00062  0.99856 -0.05373 -0.92433  0.02107  0.38100  0.38158  0.04942  0.92301
1017  0.09062  0.08267  0.01189  0.03458  0.05373 -0.99796 -0.42537  0.90438  0.03395  0.90436  0.42333  0.05413
1018  0.09061  0.08268  0.01189 -0.42535  0.90441  0.03334 -0.03484 -0.05317  0.99798  0.90436  0.42333  0.05413
1019  0.07515  0.08379  0.05647  0.56415 -0.02654 -0.82524 -0.34507  0.90043 -0.26486  0.75010  0.43419  0.49882
1020  0.07515  0.08379  0.05647 -0.34460  0.90041 -0.26555 -0.56444  0.02730  0.82502  0.75010  0.43419  0.49882
1021  0.04161  0.08487  0.08599  0.88993 -0.01729 -0.45577 -0.18908  0.89538 -0.40316  0.41506  0.44497  0.79356
1022  0.04160  0.08487  0.08600 -0.18896  0.89538 -0.40323 -0.88996  0.01742  0.45572  0.41506  0.44497  0.79356
1023  0.00000  0.08601  0.09564  0.00000  0.88968 -0.45658 -1.00000  0.00000  0.00000  0.00000  0.45658  0.88968
1024  0.00000  0.08601  0.09565 -1.00000  0.00000  0.00000  0.00000 -0.88968  0.45658  0.00000  0.45658  0.88968
1025  0.06379  0.11673  0.01756  0.05187  0.10065 -0.99357 -0.76964  0.63802  0.02445  0.63637  0.76342  0.11056
1026  0.06379  0.11673  0.01756 -0.76962  0.63805  0.02409 -0.05215 -0.10042  0.99358  0.63637  0.76342  0.11056
1027  0.02381  0.13634  0.02203 -0.14069  0.19191 -0.97128 -0.96106  0.20920  0.18055  0.23784  0.95886  0.15500
1028  0.02380  0.13634  0.02203 -0.96110  0.20926  0.18025  0.14039 -0.19184  0.97133  0.23784  0.95886  0.15500
1029  0.02667  0.11996  0.06107 -0.10931  0.58608 -0.80285 -0.95771  0.15418  0.24295  0.26617  0.79545  0.54444
1030  0.02666  0.11995  0.06108 -0.95774  0.15438  0.24268  0.10899 -0.58603  0.80293  0.26617  0.79545  0.54444
1031 -0.02381  0.13634  0.02203  0.14069  0.19191 -0.97128 -0.96106 -0.20920 -0.18055 -0.23784  0.95886  0.15500
1032 -0.02380  0.13634  0.02203 -0.96110 -0.20926 -0.18025 -0.14039 -0.19184  0.97133 -0.23784  0.95886  0.15500
1033 -0.02667  0.11996  0.06107  0.10931  0.58608 -0.80285 -0.95771 -0.15418 -0.24295 -0.26617  0.79545  0.54444 
1034 -0.02666  0.11995  0.06108 -0.95774 -0.15438 -0.24268 -0.10899 -0.58603  0.80293 -0.26617  0.79545  0.54444 
1035 -0.06379  0.11673  0.01756 -0.05187  0.10065 -0.99357 -0.76964 -0.63802 -0.02445 -0.63637  0.76342  0.11056 
1036 -0.06379  0.11673  0.01756 -0.76962 -0.63805 -0.02409  0.05215 -0.10042  0.99358 -0.63637  0.76342  0.11056 
1037 -0.09062  0.08267  0.01189 -0.03458  0.05373 -0.99796 -0.42537 -0.90438 -0.03395 -0.90436  0.42333  0.05413 
1038 -0.09061  0.08268  0.01189 -0.42535 -0.90441 -0.03334  0.03484 -0.05317  0.99798 -0.90436  0.42333  0.05413 
1039 -0.07515  0.08379  0.05647 -0.56415 -0.02654 -0.82524 -0.34507 -0.90043  0.26486 -0.75010  0.43419  0.49882 
1040 -0.07515  0.08379  0.05647 -0.34460 -0.90041  0.26555  0.56444  0.02730  0.82502 -0.75010  0.43419  0.49882 
1041 -0.04161  0.08487  0.08599 -0.88993 -0.01729 -0.45577 -0.18908 -0.89538  0.40316 -0.41506  0.44497  0.79356 
1042 -0.04160  0.08487  0.08600 -0.18896 -0.89538  0.40323  0.88996  0.01742  0.45572 -0.41506  0.44497  0.79356 
1043 -0.10417  0.04107 -0.03478 -0.03830 -0.03088 -0.99879 -0.19265 -0.98054  0.03771 -0.98052  0.19386  0.03160 
1044 -0.10417  0.04107 -0.03478 -0.19265 -0.98054  0.03767  0.03829  0.03084  0.99879 -0.98052  0.19386  0.03160 
1045 -0.10291  0.04082  0.00620 -0.03768 -0.03088 -0.99881 -0.19265 -0.98055  0.03759 -0.98054  0.19384  0.03100 
1046 -0.10291  0.04082  0.00620 -0.19265 -0.98054  0.03767  0.03769  0.03096  0.99881 -0.98054  0.19384  0.03100 
1047 -0.09333  0.04162  0.04499 -0.40234 -0.02530 -0.91514 -0.11357 -0.99052  0.07732 -0.90842  0.13504  0.39565 
1048 -0.09333  0.04162  0.04500 -0.11363 -0.99052  0.07719  0.40233  0.02517  0.91515 -0.90842  0.13504  0.39565 
1049 -0.07090  0.04349  0.07743 -0.71198 -0.01173 -0.70210 -0.05092 -0.99637  0.06829 -0.70035  0.08437  0.70880 
1050 -0.07090  0.04349  0.07742 -0.05127 -0.99637  0.06795  0.71196  0.01125  0.70213 -0.70035  0.08437  0.70880 
1051 -0.03819  0.04474  0.09903 -0.92433 -0.02161 -0.38097  0.00112 -0.99854  0.05393 -0.38158  0.04942  0.92301 
1052 -0.03819  0.04474  0.09903  0.00062 -0.99856  0.05373  0.92433  0.02107  0.38100 -0.38158  0.04942  0.92301 
1053  0.00000  0.04551  0.10656  0.00000  0.99862 -0.05249 -1.00000  0.00000  0.00000  0.00000  0.05249  0.99862 
1054  0.00000  0.04550  0.10656 -1.00000  0.00000  0.00000  0.00000 -0.99862  0.05249  0.00000  0.05249  0.99862 
1055 -0.10900  0.00016 -0.03686  0.00000 -0.03767 -0.99929 -0.00124 -0.99929  0.03767 -1.00000  0.00123 -0.00005 
1056 -0.10900  0.00016 -0.03686 -0.00124 -0.99931  0.03706  0.00000  0.03706  0.99931 -1.00000  0.00123 -0.00005 
1057 -0.10893  0.00016  0.00380 -0.03520 -0.03706 -0.99869 -0.00002 -0.99931  0.03708 -0.99938  0.00133  0.03518 
1058 -0.10893  0.00016  0.00381  0.00000 -0.99929  0.03767  0.03520  0.03765  0.99867 -0.99938  0.00133  0.03518 
1059 -0.09884  0.00158  0.04401 -0.40698 -0.03458 -0.91278  0.00081 -0.99930  0.03750 -0.91343  0.01452  0.40673 
1060 -0.09883  0.00158  0.04401  0.00062 -0.99931  0.03706  0.40698  0.03410  0.91280 -0.91343  0.01452  0.40673 
1061 -0.07510  0.00295  0.07783 -0.71972 -0.02595 -0.69378 -0.00045 -0.99928  0.03784 -0.69426  0.02754  0.71920 
1062 -0.07510  0.00295  0.07783 -0.00062 -0.99929  0.03767  0.71972  0.02571  0.69379 -0.69426  0.02754  0.71920 
1063 -0.04051  0.00372  0.10026 -0.92727 -0.01420 -0.37412  0.00039 -0.99932  0.03697 -0.37439  0.03413  0.92664 
1064 -0.04050  0.00372  0.10026  0.00062 -0.99931  0.03706  0.92727  0.01445  0.37411 -0.37439  0.03413  0.92664 
1065  0.00000  0.00409  0.10813  0.00000  0.99929 -0.03767 -1.00000  0.00000  0.00000  0.00000  0.03767  0.99929 
1066  0.00000  0.00409  0.10812 -1.00000  0.00000  0.00000  0.00000 -0.99929  0.03767  0.00000  0.03767  0.99929 
1067 -0.10070 -0.04171 -0.03931  0.01296 -0.03210 -0.99940  0.38232 -0.92338  0.03462 -0.92394 -0.38254  0.00030 
1068 -0.10070 -0.04171 -0.03930  0.38232 -0.92338  0.03459 -0.01295  0.03207  0.99940 -0.92394 -0.38254  0.00030 
1069 -0.10069 -0.04171  0.00158  0.00000 -0.03765 -0.99929  0.38286 -0.92315  0.03478 -0.92381 -0.38259  0.01441 
1070 -0.10069 -0.04171  0.00158  0.38286 -0.92318  0.03396  0.00031  0.03689  0.99932 -0.92381 -0.38259  0.01441 
1071 -0.08959 -0.04005  0.04558 -0.45436  0.00309 -0.89081  0.32825 -0.92905 -0.17064 -0.82814 -0.36994  0.42111 
1072 -0.08958 -0.04004  0.04558  0.32801 -0.92905 -0.17111  0.45453 -0.00357  0.89072 -0.82814 -0.36994  0.42111 
1073 -0.06186 -0.03717  0.08061 -0.77784 -0.06235 -0.62536  0.26120 -0.93713 -0.23145 -0.57161 -0.34338  0.74522 
1074 -0.06185 -0.03717  0.08061  0.26114 -0.93713 -0.23150  0.77786  0.06227  0.62534 -0.57161 -0.34338  0.74522 
1075 -0.07708 -0.07708 -0.03993  0.01913 -0.01913 -0.99963  0.70685 -0.70685  0.02705 -0.70711 -0.70711  0.00000 
1076 -0.07708 -0.07708 -0.03993  0.70687 -0.70687  0.02593 -0.01833  0.01833  0.99966 -0.70711 -0.70711  0.00000 
1077 -0.07707 -0.07707  0.00096  0.01235 -0.02470 -0.99962  0.70717 -0.70656  0.02619 -0.70693 -0.70722  0.00874 
1078 -0.07708 -0.07707  0.00095  0.70717 -0.70655  0.02656 -0.01261  0.02496  0.99961 -0.70693 -0.70722  0.00874 
1079 -0.06181 -0.07746  0.04343 -0.23033 -0.32913 -0.91576  0.78783 -0.61546  0.02305 -0.57120 -0.71616  0.40106 
1080 -0.06180 -0.07746  0.04343  0.78778 -0.61553  0.02284  0.23050  0.32899  0.91577 -0.57120 -0.71616  0.40106 
1081 -0.04171 -0.10070 -0.04105  0.01296 -0.00555 -0.99990  0.92371 -0.38282  0.01410 -0.38286 -0.92380  0.00017
1082 -0.04171 -0.10070 -0.04105  0.92370 -0.38282  0.01482 -0.01363  0.00583  0.99989 -0.38286 -0.92380  0.00017
1083 -0.04171 -0.10070  0.00000  0.01296 -0.00555 -0.99990  0.92371 -0.38282  0.01410 -0.38286 -0.92380  0.00017
1084 -0.04171 -0.10070  0.00000  0.92370 -0.38282  0.01482 -0.01363  0.00583  0.99989 -0.38286 -0.92380  0.00017
1085 -0.02113 -0.09801  0.04068 -0.00247 -0.38286 -0.92380  0.98072 -0.18144  0.07257 -0.19540 -0.90581  0.37593
1086 -0.02113 -0.09801  0.04067  0.98072 -0.18157  0.07226  0.00281  0.38280  0.92383 -0.19540 -0.90581  0.37593
1087 -0.02180 -0.07322  0.07662  0.08460 -0.73241 -0.67559  0.97577 -0.07641  0.20503 -0.20178 -0.67657  0.70819
1088 -0.02180 -0.07322  0.07662  0.97578 -0.07653  0.20491 -0.08443  0.73239  0.67563 -0.20178 -0.67657  0.70819
1089 -0.02094 -0.03739  0.09935  0.03707 -0.93775 -0.34532  0.98052 -0.03258  0.19370 -0.19290 -0.34578  0.91827
1090 -0.02094 -0.03739  0.09935  0.98050 -0.03211  0.19388 -0.03756  0.93777  0.34523 -0.19290 -0.34578  0.91827
1091  0.00000 -0.10900 -0.04072  0.00000  0.00000 -1.00000  1.00000  0.00000  0.00000  0.00000 -1.00000  0.00000
1092  0.00000 -0.10900 -0.04072  1.00000  0.00000  0.00000  0.00000  0.00000  1.00000  0.00000 -1.00000  0.00000
1093  0.00000 -0.10900  0.00032  0.00000 -0.00247 -1.00000  1.00000  0.00000  0.00000  0.00000 -1.00000  0.00247
1094  0.00000 -0.10900  0.00032  1.00000  0.00000  0.00000 -0.00000  0.00247  1.00000  0.00000 -1.00000  0.00247
1095  0.02113 -0.09801  0.04068  0.00247 -0.38286 -0.92380  0.98072  0.18144 -0.07257  0.19540 -0.90581  0.37593
1096  0.02113 -0.09801  0.04067  0.98072  0.18157 -0.07226 -0.00281  0.38280  0.92383  0.19540 -0.90581  0.37593
1097  0.02180 -0.07322  0.07662 -0.08460 -0.73241 -0.67559  0.97577  0.07641 -0.20503  0.20178 -0.67657  0.70819
1098  0.02180 -0.07322  0.07662  0.97578  0.07653 -0.20491  0.08443  0.73239  0.67563  0.20178 -0.67657  0.70819
1099  0.02094 -0.03739  0.09935 -0.03707 -0.93775 -0.34532  0.98052  0.03258 -0.19370  0.19290 -0.34578  0.91827
1100  0.02094 -0.03739  0.09935  0.98050  0.03211 -0.19388  0.03756  0.93777  0.34523  0.19290 -0.34578  0.91827
1101  0.04171 -0.10070 -0.04105 -0.01296 -0.00555 -0.99990  0.92371  0.38282 -0.01410  0.38286 -0.92380  0.00017
1102  0.04171 -0.10070 -0.04105  0.92370  0.38282 -0.01482  0.01363  0.00583  0.99989  0.38286 -0.92380  0.00017 
1103  0.04171 -0.10070  0.00000 -0.01296 -0.00555 -0.99990  0.92371  0.38282 -0.01410  0.38286 -0.92380  0.00017 
1104  0.04171 -0.10070  0.00000  0.92370  0.38282 -0.01482  0.01363  0.00583  0.99989  0.38286 -0.92380  0.00017 
1105  0.07708 -0.07708 -0.03993 -0.01913 -0.01913 -0.99963  0.70685  0.70685 -0.02705  0.70711 -0.70711  0.00000 
1106  0.07708 -0.07708 -0.03993  0.70687  0.70687 -0.02593  0.01833  0.01833  0.99966  0.70711 -0.70711  0.00000 
1107  0.07707 -0.07707  0.00096 -0.01235 -0.02470 -0.99962  0.70717  0.70656 -0.02619  0.70693 -0.70722  0.00874 
1108  0.07708 -0.07707  0.00095  0.70717  0.70655 -0.02656  0.01261  0.02496  0.99961  0.70693 -0.70722  0.00874 
1109  0.06181 -0.07746  0.04343  0.23033 -0.32913 -0.91576  0.78783  0.61546 -0.02305  0.57120 -0.71616  0.40106 
1110  0.06180 -0.07746  0.04343  0.78778  0.61553 -0.02284 -0.23050  0.32899  0.91577  0.57120 -0.71616  0.40106 
1111  0.10070 -0.04171 -0.03931 -0.01296 -0.03210 -0.99940  0.38232  0.92338 -0.03462  0.92394 -0.38254  0.00030 
1112  0.10070 -0.04171 -0.03930  0.38232  0.92338 -0.03459  0.01295  0.03207  0.99940  0.92394 -0.38254  0.00030 
1113  0.10069 -0.04171  0.00158  0.00000 -0.03765 -0.99929  0.38286  0.92315 -0.03478  0.92381 -0.38259  0.01441 
1114  0.10069 -0.04171  0.00158  0.38286  0.92318 -0.03396 -0.00031  0.03689  0.99932  0.92381 -0.38259  0.01441 
1115  0.08959 -0.04005  0.04558  0.45436  0.00309 -0.89081  0.32825  0.92905  0.17064  0.82814 -0.36994  0.42111 
1116  0.08958 -0.04004  0.04558  0.32801  0.92905  0.17111 -0.45453 -0.00357  0.89072  0.82814 -0.36994  0.42111 
1117  0.06186 -0.03717  0.08061  0.77784 -0.06235 -0.62536  0.26120  0.93713  0.23145  0.57161 -0.34338  0.74522 
1118  0.06185 -0.03717  0.08061  0.26114  0.93713  0.23150 -0.77786  0.06227  0.62534  0.57161 -0.34338  0.74522 
1119  0.07510  0.00295  0.07783  0.71972 -0.02595 -0.69378 -0.00045  0.99928 -0.03784  0.69426  0.02754  0.71920 
1120  0.07510  0.00295  0.07783 -0.00062  0.99929 -0.03767 -0.71972  0.02571  0.69379  0.69426  0.02754  0.71920 
1121  0.04051  0.00372  0.10026  0.92727 -0.01420 -0.37412  0.00039  0.99932 -0.03697  0.37439  0.03413  0.92664 
1122  0.04050  0.00372  0.10026  0.00062  0.99931 -0.03706 -0.92727  0.01445  0.37411  0.37439  0.03413  0.92664 
];

return
