function [I_pos,I_neg]=separation(v,connectivity_cell)
%SEPARATION - Splitting the brain into 2 parts
% function [I_pos,I_neg]=separation(v,connectivity_cell)
%
%  spliting the brain into 2 parts
%
%  inputs : v : vertices (brain centered), connectivity_cell : result of vertices_connectivity
%  outputs : I_pos/I_neg : indices of the vertices corresponding to the positive/negative part of the brain
%

%<autobegin> ---------------------- 26-May-2004 11:34:21 -----------------------
% --------- Automatically Generated Comments Block Using AUTO_COMMENTS ---------
%
% CATEGORY: Visualization
%
% At Check-in: $Author: Mosher $  $Revision: 14 $  $Date: 5/26/04 10:02a $
%
% This software is part of BrainStorm Toolbox Version 2.0 (Alpha) 24-May-2004
% 
% Principal Investigators and Developers:
% ** Richard M. Leahy, PhD, Signal & Image Processing Institute,
%    University of Southern California, Los Angeles, CA
% ** John C. Mosher, PhD, Biophysics Group,
%    Los Alamos National Laboratory, Los Alamos, NM
% ** Sylvain Baillet, PhD, Cognitive Neuroscience & Brain Imaging Laboratory,
%    CNRS, Hopital de la Salpetriere, Paris, France
% 
% See BrainStorm website at http://neuroimage.usc.edu for further information.
% 
% Copyright (c) 2004 BrainStorm by the University of Southern California
% This software distributed  under the terms of the GNU General Public License
% as published by the Free Software Foundation. Further details on the GPL
% license can be found at http://www.gnu.org/copyleft/gpl.html .
% 
% FOR RESEARCH PURPOSES ONLY. THE SOFTWARE IS PROVIDED "AS IS," AND THE
% UNIVERSITY OF SOUTHERN CALIFORNIA AND ITS COLLABORATORS DO NOT MAKE ANY
% WARRANTY, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO WARRANTIES OF
% MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, NOR DO THEY ASSUME ANY
% LIABILITY OR RESPONSIBILITY FOR THE USE OF THIS SOFTWARE.
%<autoend> ------------------------ 26-May-2004 11:34:21 -----------------------



% find short and long axes
larg1=max(max(v(:,1)))-min(min(v(:,1)));
larg2=max(max(v(:,2)))-min(min(v(:,2)));
if larg1<larg2
	short_axe=1;
	long_axe=2;
else
	short_axe=2;
	long_axe=1;
end
maxi=max(max(v(:,short_axe)));
mini=min(min(v(:,short_axe)));

% test to know whether the cerebellum is included or not
i_mini=find(v(:,3)==min(min(v(:,3))));
if v(i_mini,long_axe)<0
	cerebellum=1;
% 	'cerebellum in'
else
	cerebellum=2;
% 	'cerebellum out'
end

% spliting of the brain into 2 parts
I_maxi=find(v(:,short_axe)==maxi);
i_maxi=I_maxi(1,1);
v_vector=i_maxi;
front=i_maxi;
stop=0;
stop_it=zeros(size(v,1),1);
while stop~=1
	clear stop_it_test;
	stop_it_test=stop_it(front);
	I_az=find(stop_it_test==0);
	clear v_neig;
	clear fronttemp;
	fronttemp=front;
	v_neig=[];
	for i=1:size(I_az)
		v_neig=[v_neig connectivity_cell{front(I_az(i))}];
	end
	v_neigu=unique(v_neig);
	clear v_new_neig;
	v_new_neig=setdiff(v_neigu,v_vector);
	front_nav=[front v_new_neig];
	clear front;
	front=setdiff(front_nav,fronttemp(I_az));
	clear v_test;
	I_iz=find(v(v_new_neig,short_axe)<=0);
	if ~isempty(I_iz)
		if cerebellum==1
			I_z_axe=find(v(v_new_neig(I_iz),3)<4*max(max(v(:,3))));
			if  ~isempty(I_z_axe)
				I_long_axe=find(v(v_new_neig(I_iz(I_z_axe)),long_axe)<6*max(max(v(:,long_axe))));
				if ~isempty(I_long_axe)
					stop_it(v_new_neig(I_iz(I_z_axe(I_long_axe))))=1;
				end
			end
		elseif cerebellum==2
			I_z_axe=find(v(v_new_neig(I_iz),3)<0.4*max(max(v(:,3))) & v(v_new_neig(I_iz),3)>-0.6*max(max(v(:,3))));
			if  ~isempty(I_z_axe)
				I_long_axe=find(v(v_new_neig(I_iz(I_z_axe)),long_axe)<0.6*max(max(v(:,long_axe))) & v(v_new_neig(I_iz(I_z_axe)),long_axe)>-0.4*max(max(v(:,long_axe))));
				if ~isempty(I_long_axe)
					stop_it(v_new_neig(I_iz(I_z_axe(I_long_axe))))=1;
				end
			end
		end
	end
	clear I_stop;
	I_stop=find(stop_it==1);
	v_vector=unique([v_vector front]);
	if size(I_stop,1)==size(front,2)
		stop=1;
	end
end
I_neg=(setdiff(linspace(1,size(v,1),size(v,1)),v_vector'))';
I_pos=v_vector';
