function sc = weighting_scalar(Loc,Orient,Weight,Vertices,Normals);
%WEIGHTING_SCALAR - For use with Overlapping Sphere
% function sc = weighting_scalar(Loc,Orient,Weight,Vertices,Normals);
% Unchecked (for speed): Loc is 3 x n, Orient is 3 x n or null, Weight is length
%  n, Vertices is 3 x N, Normals is 3 x N.
% Given a single location and optional orientation, calculate the weighting function
%  to each vertex, using it's corresponding normal.
% Let d = Loc - Vertex, d3 = abs(d)^3, calculate for each vertex in Vertices.
% Let n be the normal pointing vector at each vertex
% If orientation is given, assume MEG case, then replace n with Orient cross n.
% Then
%  sc = n dot d/d3.
% Repeat for each location in Loc, summing by the corresponding scalar in Weight

%<autobegin> ---------------------- 26-May-2004 11:34:43 -----------------------
% --------- Automatically Generated Comments Block Using AUTO_COMMENTS ---------
%
% CATEGORY: Forward Modeling
%
% At Check-in: $Author: Mosher $  $Revision: 14 $  $Date: 5/26/04 10:02a $
%
% This software is part of BrainStorm Toolbox Version 2.0 (Alpha) 24-May-2004
% 
% Principal Investigators and Developers:
% ** Richard M. Leahy, PhD, Signal & Image Processing Institute,
%    University of Southern California, Los Angeles, CA
% ** John C. Mosher, PhD, Biophysics Group,
%    Los Alamos National Laboratory, Los Alamos, NM
% ** Sylvain Baillet, PhD, Cognitive Neuroscience & Brain Imaging Laboratory,
%    CNRS, Hopital de la Salpetriere, Paris, France
% 
% See BrainStorm website at http://neuroimage.usc.edu for further information.
% 
% Copyright (c) 2004 BrainStorm by the University of Southern California
% This software distributed  under the terms of the GNU General Public License
% as published by the Free Software Foundation. Further details on the GPL
% license can be found at http://www.gnu.org/copyleft/gpl.html .
% 
% FOR RESEARCH PURPOSES ONLY. THE SOFTWARE IS PROVIDED "AS IS," AND THE
% UNIVERSITY OF SOUTHERN CALIFORNIA AND ITS COLLABORATORS DO NOT MAKE ANY
% WARRANTY, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO WARRANTIES OF
% MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, NOR DO THEY ASSUME ANY
% LIABILITY OR RESPONSIBILITY FOR THE USE OF THIS SOFTWARE.
%<autoend> ------------------------ 26-May-2004 11:34:43 -----------------------


% Copyright (c) 1999
% John C. Mosher, Ph.D. See Copyright file for information
% $Date: 5/26/04 10:02a $ $Revision: 14 $

MIN_DIST = 10/1000; % minimum acceptable distance. Too close causes trouble

n = size(Loc,2); % number of sensors
N = size(Vertices,2); % number of vertices
ZeroN = zeros(1,N); % preallocate
sc = zeros(1,N); % preallocate the answer

for iS = 1:n, % for each sensor location
  
  if(~isempty(Orient)),
    % user gave an orientation, cross it with all normals
    n = cross(Orient(:,ZeroN+iS),Normals);
  else
    % EEG case, just use the normal
    n = Normals;
  end
    
  d = Loc(:,ZeroN+iS) - Vertices; % distance vector
  d3 = sqrt(sum(d.^2)).^3; % cubed distance
  ndx = find(d3 >= (MIN_DIST^3));
  temp = sum(n(:,ndx) .* d(:,ndx)) ./ d3(ndx);
  
  sc(ndx) = sc(ndx) + temp * (Weight(iS)/Weight(1)); % always scale relative to first
  
end

sc = sc.'; % return column vector

return
