% Regularization Tools.
% Version 2.0  16-March-93.
% Copyright (c) 1993 by Per Christian Hansen and UNI-C.
%
% Demonstration.
%   regudemo  - Tutorial introduction to Regularization Tools.
%
% Test examples.
%   baart     - Fredholm integral equation of the first kind.
%   deriv2    - Computation of the second derivative.
%   foxgood   - Severely ill-posed problem.
%   heat      - Inverse heat equation.
%   ilaplace  - Inverse Laplace transformation.
%   parallax  - Stellar parallax problem with 28 fixed observations.
%   phillips  - Philips' "famous" test problem.
%   shaw      - One-dimensional image restoration problem.
%   spikes    - Test problem with a "spiky" solution.
%   ursell    - Integral equation with no square integrable solution.
%   wing      - Test problem with a discontinuous solution.
%
% Regularization routines.
%   cgls      - Computes the least squares solution based on k steps
%               of the conjugate gradient algorithm.
%   discrep   - Minimizes the solution (semi-)norm subject to an upper
%               bound on the residual norm (discrepancy principle).
%   dsvd      - Computes a damped SVD/GSVD solution.
%   lsqi      - Minimizes the residual norm subject to an upper bound
%               on the (semi-)norm of the solution.
%   lsqr      - Computes the least squares solution based on k steps
%               of the LSQR algorithm (Lanczos bidiagonalization).
%   maxent    - Computes the maximum entropy regularized solution.
%   mtsvd     - Computes the modified TSVD solution.
%   nu        - Computes the solution based on k steps of Brakhage's
%               iterative nu-method.
%   pcgls     - Same as cgls, but for general-form regularization.
%   plsqr     - Same as lsqr, but for general-form regularization.
%   pnu       - Same as nu, but for general-form regularization.
%   tgsvd     - Computes the truncated GSVD solution.
%   tikhonov  - Computes the Tikhonov regularized solution.
%   tsvd      - Computes the truncated SVD solution.
%   ttls      - Computes the truncated TLS solution.
%
% Analysis routines.
%   fil_fac   - Computes filter factors for some regularization methods.
%   gcv       - Plots the GCV function and computes its minimum.
%   l_corner  - Locates the L-shaped corner of the L-curve.
%   l_curve   - Computes the L-curve, plots it, and computes its corner.
%   lagrange  - Plots the Lagrange function ||Ax-b||^2 + lambda^2*||Lx||^,
%               and its derivative.
%   picard    - Plots the (generalized) singular values,
%               the Fourier coefficient for the right-hand side, and a
%               (smoothed curve of) the solution Fourier-coefficients.
%   plot_lc   - Plots an L-curve.
%   quasiopt  - Plots the quasi-optimality function and computes its minimum.
%
% Routines for transforming a problem in general form into one in
% standard form, and back again.
%   gen_form  - Transforms a standard-form solution back into the
%               general-form setting.
%   std_form  - Transforms a general-form problem into one in
%               standard form.
%
% Utility routines.
%   bidiag    - Bidiagonalization of a matrix by Householder transformations.
%   bsvd      - Computes the singular values, or the compact SVD,
%               of a bidiagonal matrix stored in compact form.
%   csd       - Computes the CS decomposition.
%   csvd      - Computes the compact SVD of an m-by-n matrix.
%   get_l     - Produces a p-by-n matrix which is the discrete
%               approximation to the d'th order derivative operator.
%   gsvd      - Computes the generalized SVD of a matrix pair.
%   lanc_b    - Performs k steps of the Lanczos bidiagonalization
%               process with/without reorthogonalization.
%
% Auxiliary routines required by some of the above routines.
%   app_hh_l  - Applies a Householder transformation from the left.
%   gen_hh    - Generates a Householder transformation.
%   heb_new   - Newton-Raphson iteration with Hebden's rational
%               approximation, used in lsqi.
%   heb_new2  - Ditto, used in discrep.
%   lsolve    - Inversion with A-weighted generalized inverse of L.
%   ltsolve   - Inversion with transposed A-weighted inverse of L.
%   mgs       - Modified Gram-Schmidt orthonormalization.
%   newton    - Newton-Raphson iteration, used in discrep.
%   pinit     - Initialization for treating general-form problems.
%   pythag    - Computes sqrt(a^2 + b^2).
%   spleval   - Computes points on a spline or spline curve.
%
% The routine l_corner requires the following routines from the Spline
% Toolbox:
%   fnder, ppbrk, ppcut, ppmak, sp2pp, spbrk, spmak.
% If the Spline Toolbox is not available, then dummy functions with these
% names should reside in the same directory as Regularization Tools.
