function points = spleval(f)
%SPLEVAL Evaluation of a spline or spline curve.
%
% points = spleval(f)
%
% Computes points on the given spline or spline curve f between
% its extreme breaks.

% Original routine fnplt by C. de Boor / latest change: Feb.25, 1989
% Simplified by Per Christian Hansen, UNI-C, 11/19/91.

if (f(1)==11), f = sp2pp(f); end

[breaks,coefs,l,k,d] = ppbrk(f);
npoints=100;
x = breaks(1) + [0:npoints]*((breaks(l+1)-breaks(1))/npoints);
v=ppual(f,x);

if (d==1), points=[x;v]; else, points = v; end
