function Colors = bst_color_scheme(h);
%BST_COLOR_SCHEME - apply the BrainStorm color, font, size scheme to the figure
% function Colors = bst_color_scheme(h);
% h is the figure handle.
% Set uniform coloring for different uicontrols, set all fontnames to system default.
% Return Colors structure if requested.
%
% In the switchyard, after the figure is opened, run this command on the figure.
%  All uicontrols have their units set to normalized, their fontname set to 'default', 
%  and their fontunits set to 'normalized'.
% The BrainStorm startup file defines 'default' as 'arial' on PCs or 'Helvetica' on unix.
%
% If custom colors or fonts are desired, set them after this command.
% The following first letters of the tags cause special action, 
%  or optionally, if the userdata for the object is the same first letter,
%  then 'Style' is set to the single letter.
% FRAME, CHECKBOX or TEXT (i.e. STATICTEXT) has a tag that starts with a 
%  Capital T, then the frame or text is treated as a "Title"
%    object, which we use to label our main GUIs.
%  Capital B, then frame is "banner text" and gets Bright Blue
% FRAME, TEXT, or EDIT (i.e. editable text) uicontrol starts with a 
%  Capital S, then the uicontrol is treated as "special" and 
%    no colors are applied.
% PUSHBUTTON starts with an 
%  Capital H, then it's a "hot" button that gets colored orange.
%  Capital Q, then it's a "quit" button that gets pink
% 
% EXAMPLE
%  a frame with tag h has userdata set to 'BillyBob', then that frame will be
%  treated as Banner Text

%<autobegin> ---------------------- 21-Jun-2004 16:44:35 -----------------------
% --------- Automatically Generated Comments Block Using AUTO_COMMENTS ---------
%
% CATEGORY: GUI and Related
%
% At Check-in: $Author: Mosher $  $Revision: 21 $  $Date: 6/21/04 3:11p $
%
% This software is part of BrainStorm Toolbox Version 2.0 (Alpha) 21-Jun-2004
% 
% Principal Investigators and Developers:
% ** Richard M. Leahy, PhD, Signal & Image Processing Institute,
%    University of Southern California, Los Angeles, CA
% ** John C. Mosher, PhD, Biophysics Group,
%    Los Alamos National Laboratory, Los Alamos, NM
% ** Sylvain Baillet, PhD, Cognitive Neuroscience & Brain Imaging Laboratory,
%    CNRS, Hopital de la Salpetriere, Paris, France
% 
% See BrainStorm website at http://neuroimage.usc.edu for further information.
% 
% Copyright (c) 2004 BrainStorm by the University of Southern California
% This software distributed  under the terms of the GNU General Public License
% as published by the Free Software Foundation. Further details on the GPL
% license can be found at http://www.gnu.org/copyleft/gpl.html .
% 
% FOR RESEARCH PURPOSES ONLY. THE SOFTWARE IS PROVIDED "AS IS," AND THE
% UNIVERSITY OF SOUTHERN CALIFORNIA AND ITS COLLABORATORS DO NOT MAKE ANY
% WARRANTY, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO WARRANTIES OF
% MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, NOR DO THEY ASSUME ANY
% LIABILITY OR RESPONSIBILITY FOR THE USE OF THIS SOFTWARE.
%<autoend> ------------------------ 21-Jun-2004 16:44:35 -----------------------


% /---Script Authors--------------------------------------\
% |  *** John C. Mosher, Ph.D.                            |
% |  Biophysics Group                                     |
% |                                                       |
% |  *** Sylvain Baillet, Ph.D.                           |
% |  Cognitive Neuroscience & Brain Imaging Laboratory    |
% |  CNRS UPR640 - LENA                                   | 
% |  Hopital de la Salpetriere, Paris, France             |
% |  sylvain.baillet@chups.jussieu.fr                     |
% \------------------------------------------------------/
%
% Script History -------------------------------------------------------------------------------------
% JCM Feb, March 2002 original design
% SB 08-Apr-2002  - Force fixedwidth fonts for listbox so that text tables are properly displayed
% SB 16-Apr-2002  - Added brightblue and pink color styles + Quit and Banner styles  
% JCM 20-Apr-2002 - Added an "or" function to the userdata of each button, keeps us from 
% ...............   having to rename all references to the tag. See help above
% SB  24-May-2002 - Added the light frame style
% ...............   Modified the Title style
% SB  28-May-2002 - Added DarkText Style and new color schemes
% JCM 28-May-2002 - Rearranged switch to show new scheme as "May" (i.e. May 2002).
% JCM 29-May-2002 - Added some figure options. If you want to reverse one, just do it
%                    custom after the bst_color_scheme call. Moved the figure options to be
%                    above the main loop.
% JCM 25-Jun-2002 - Added Colors structure output, to allow GUIs to be custom recolored
%                     if needed, particularly the Togglebuttons. If no input handle given,
%                     simply returns.
% SB  27-Jun-2002 - Added CHECKBOX as a candidate to Title color scheme
% JCM 17-Jun-2004 - Ensure that "HandleVisibility" is "On"
% ----------------------------------------------------------------------------------------------------

% set the default colors here for use below
dark = [.4 .4 .4]; % the dark color for button backgrounds
light = [.83 .8 .73]; % the light color as contrast, default matlab on PC
white = [1 1 1];
textdark = [.2 .2 .2]; % dark text
textlight = [.9 .9 .9]; % light text
titledark = [.2 .2 .2]; % our titles are slightly more greyer
blue = [.513 .6 .694]; % default BrainStorm background color, bluish
darkblue = [.05 .45 .8]; % dark blue used in BrainStorm frames
orange = [1 .66 .43]; % default background style 2, orangish, also used for "hot" buttons
green = [.66 .9 .43]; % bright green for active toggled buttons
gray = [.7 .75 .75]; % for title frames, such as "Data Viewer"
pink = [1 .5 1]; % for 'Quit' buttons foreground 
brightblue = [.05 .45 .8]; % For 'Banner' static text background
yellow = [1 .8 0];

% Sylvain's testing for color scheme----------------------------------------------
defaultback = [.4 .6 .6];
%brightblue = [.25 .5 .8]; % For 'Banner' static text background
brightblue = defaultback; % For 'Banner' static text background
lightblue = [.98 .98 1];%[.88 .94 .94]; % For listboxes and popups
%orange2 = [.9 .67 .42]; % For TitleText and Frames
orange2 = [.2 .4 .55]; % For TitleText and Frames
orange = [1 .6 .2]; % default background style 2, orangish, also used for "hot" buttons
%green2 = [.66 .9 .43]; % For hot buttons
gray = [.75 .8 .8]; % for Light frames
%---------------------------------------------------------------------------------

% JCM 22-May-2002, don't like pink on brightblue for quit button. Our best bet is to go to
%  powerpoint and imitate some of their color schemes, since these work well for
%  color on color schemes

% Powerpoint names:
[Scheme(1:2)] = deal(struct('Background',[],'TextandLines',[],...
    'Shadows',[],'TitleText',[],'Fills',[],'Accent',[],...
    'AccentandHyperLink',[],'AccentandFollowed',[]));

% Powerpoint Standard Color Schemes
% A dark Brown background one

Scheme(1).Background = [82 62 38]/255;
Scheme(1).TextandLines = [255 255 255]/255;
Scheme(1).Shadows = [45 32 21]/255;
Scheme(1).TitleText = [223 192 141]/255;
Scheme(1).Fills = [140 123 112]/255;
Scheme(1).Accent = [143 95 47]/255;
Scheme(1).AccentandHyperLink = [204 180 0]/255;
Scheme(1).AccentandFollowed = [140 158 160]/255;

% a greenish background one
Scheme(2).Background = [245 240 189]/255;
Scheme(2).TextandLines = [0 0 0]/255;
Scheme(2).Shadows = [255 255 204]/255;
Scheme(2).TitleText = [189 157 105]/255;
Scheme(2).Fills = [205 187 119]/255;
Scheme(2).Accent = [248 235 208]/255;
Scheme(2).AccentandHyperLink = [255 153 0]/255;
Scheme(2).AccentandFollowed = [198 75 0]/255;

% But as of 22-May, while these colors work, they don't work
%  universally well. So keep the April scheme for now

% Make any color changes in this switch case, using these
%  Scheme names, and avoid customizing below here.
switch 'May'
case 'April'
    % scheme in April 2002 imitated mostly from Baillet's initial color designs
    
    FigureBack = blue; % overall background color
    TitleBack = gray; % color of the special title frames
    ButtonBack = dark; % background color of the buttons
    ToggleOff = ButtonBack; % when off
    ToggleOn = green; % when on
    TextBack = light; % background color of items containing text
    HotBack = orange;
    %   QuitBack = darkblue;
    QuitBack = dark*.75; % slightly darker
    BannerBack = brightblue;
    
    FigureText = textlight; % text laying on the figure
    TitleText = titledark; % special title frames
    ButtonText = textlight;
    Text = textdark; % text on listboxes, popups
    HotText = textdark;
    % QuitText = pink;
    QuitText = yellow;
    BannerText = white;
    
case 'May'
    % Baillet's new May 2002 scheme
    
    FigureBack = defaultback; % overall background color
    TitleBack = orange2;
    ButtonBack = dark; % background color of the buttons
    ToggleOff = ButtonBack; % when off
    ToggleOn = green; % when on
    TextBack = lightblue; % background color of items containing text
    HotBack = orange;
    QuitBack = dark*.75; % slightly darker
    BannerBack = brightblue;
    
    FigureText = textlight; % text laying on the figure
    TitleText = textlight; % special title frames   
    ButtonText = textlight;
    Text = textdark; % text on listboxes, popups
    HotText = textdark;
    QuitText = yellow;
    BannerText = white;
    
case 'scheme'
    i = 2; % pick a number from above
    FigureBack = Scheme(i).Background; % lighter color
    TitleBack = Scheme(i).Fills; % even lighter color relative to figure
    ButtonBack = Scheme(i).Accent; % darker color
    ToggleOff = ButtonBack; % when off
    ToggleOn = green; % when on
    TextBack = Scheme(i).TitleText; % lighter color
    HotBack = Scheme(i).AccentandHyperLink; % lighter color
    QuitBack = Scheme(i).AccentandFollowed; % darker color
    BannerBack = Scheme(i).Shadows; % lighter color
    
    FigureText = Scheme(i).TitleText; % very light color
    TitleText = Scheme(i).TitleText; % darker color
    ButtonText = Scheme(i).TextandLines; % lighter color
    Text = Scheme(i).Shadows; % darker color
    HotText = Scheme(i).Background; % darker color
    QuitText = Scheme(i).TitleText; % lighter color
    BannerText = Scheme(i).TextandLines; % very light color
    
end

if(nargout),
    % user wants colors
    Colors = struct('FigureBack',FigureBack,'TitleBack',TitleBack,...
        'ButtonBack',ButtonBack,'ToggleOff',ToggleOff,'ToggleOn',ToggleOn,...
        'TextBack',TextBack,'HotBack',HotBack,...
        'QuitBack',QuitBack,'BannerBack',BannerBack,'FigureText',FigureText,...
        'TitleText',TitleText,'ButtonText',ButtonText,'Text',Text,...
        'HotText',HotText,'QuitText',QuitText,'BannerText',BannerText);
end

if(~nargin),
    % user did not provide a figure handle, probably only wanted the current 
    %  colors
    return
end

% set(0,'showhiddenhandles','off'); % don't show all handles

% first, let's setup the figure with some desirable properties

set(h,'resize','on'); % allow figure to be resized
set(h,'color',FigureBack); % default background color
set(h,'units','normalized'); % keeps all objects relative to each other
% some additional good stuff 29-May-2002 JCM
set(h,'numbertitle','off', ... % don't want no number
    'menubar','none', ... % no menubar. If you need one, set it manually on
    'toolbar','none', ... % no toolbar. If you need one
    'doublebuffer','off', ... % cut's down on memory requirements
    'backingstore','off', ...% ditto, may need to manually refresh screen
    'HandleVisibility','On'...% so that user can find it as the GCF
    ); 

%   'integerhandle','off' is good, too, but needs to be set in GUIDE.
% helps keep user from accidently accessing, but if set here changes the handle number


% now with the menu and toolbars turned off, and the integerhandle off, let's scan the figure

handles = guihandles(h); % all handles should be visible to callbacks

if isempty(handles)
    return
end

names = fieldnames(handles); % all of the fieldnames

% now lets load up the handles directly
hi = zeros(length(names),1);

for i = 1:length(names),
    temp = getfield(handles,names{i}); % this handle
    if(length(temp) > 1),
        disp(sprintf('Figure has two handles with same tag!: %s',names{i}));
        temp = temp(1); % alter only the first one
    end
    hi(i) = temp;
end

% now all handles are loaded


for i = 1:length(hi),
    
    htype = get(hi(i),'type'); % what kind of object
    
    switch htype
        
    case 'figure'
        % do nothing more, all done above
        
    case 'axes'
        set(hi(i),'color',TextBack); % background color
        set(hi(i),'units','normalized'); % scalable
        
    case 'uimenu'
        set(hi(i),'foregroundcolor',Text); % words on the menu
        
    case 'uicontextmenu'
        % do nothing, their children are uimenu items
        
    case 'uicontrol'
        
        % force the fontnames to default for cross platform consistency
        % Note that ORDERING OF UNITS CHANGES IS IMPORTANT
        set(hi(i),'units','normalized');
        set(hi(i),'fontunits','normalized');
        
        hstyle = get(hi(i),'style'); % what style of uicontrol
        
        switch hstyle
            
        case 'edit'
            TAG = get(hi(i),'Tag');
            
            Special = TAG(1); % set to the first letter
            % alternative to the tag is the UserData set to appropriate letter
            UserData = get(hi(i),'UserData');
            if ~isempty(UserData)
                Special = char(UserData(1));
            end
            
            switch Special
            case 'S'
                % special, don't touch
            otherwise
                set(hi(i),'backgroundcolor',TextBack,'foregroundcolor',Text);
            end
            set(hi(i),'fontname','default');   
            
        case {'frame','checkbox','text'}
            set(hi(i),'fontname','default');
            % Allow for the case of important Title Text
            
            TAG = get(hi(i),'Tag'); % the tag name for this text field
            
            Special = TAG(1); % set to the first letter
            % alternative to the tag is the UserData set to appropriate letter
            UserData = get(hi(i),'UserData');
            if ~isempty(UserData)
                Special = char(UserData(1));
            end
            
            switch Special % switch on the first letter
                %case 'S' SB 16-Apr-2002 : Could be confounded with the 'StaticText' default tag. 
                % special, do nothing
            case 'T' % a title tag
                set(hi(i),'backgroundcolor',TitleBack,'foregroundcolor',TitleText,'HorizontalAlignment','left');
            case 'B' % a banner of static text
                set(hi(i),'backgroundcolor',BannerBack,'foregroundcolor',BannerText,'FontWeight','Bold');
            case 'L' % Light frame style
                set(hi(i),'backgroundcolor',gray,'foregroundcolor',gray);
            case 'D' % Dark textstyle - Good for text on Light-style frames
                set(hi(i),'backgroundcolor',gray,'foregroundcolor',textdark);
            case 'S'
                % do nothing, special
            otherwise
                % ordinary text
                set(hi(i),'backgroundcolor',FigureBack,'foregroundcolor',FigureText);
            end
            
        case 'listbox'
            set(hi(i),'backgroundcolor',TextBack,'foregroundcolor',Text);
            % SB - 08-Apr-2002 - Force fixedwidth fonts for listbox so that 
            %  text tables are properly displayed
            set(hi(i),'fontname','FixedWidth'); 
            
        case 'pushbutton'
            set(hi(i),'fontname','default');
            % Allow for "hot buttons"
            
            TAG = get(hi(i),'Tag'); % the tag name for this text field
            
            Special = TAG(1); % set to the first letter
            % alternative to the tag is the UserData set to appropriate letter
            UserData = get(hi(i),'UserData');
            if ~isempty(UserData)
                Special = char(UserData(1));
            end
            
            switch Special % switch on the first letter
            case 'H' % a hot button
                set(hi(i),'backgroundcolor',HotBack,'foregroundcolor',HotText,...
                    'fontweight','bold');            
            case 'Q' % a quit button
                set(hi(i),'backgroundcolor',QuitBack,'foregroundcolor',QuitText,...
                    'fontweight','bold');            
                
            otherwise
                % ordinary button
                set(hi(i),'backgroundcolor',ButtonBack,'foregroundcolor',ButtonText);
            end
            
            
        case 'popupmenu'
            set(hi(i),'fontname','default');
            set(hi(i),'backgroundcolor',TextBack,'foregroundcolor',Text);
            
        case 'radiobutton'
            set(hi(i),'fontname','default');
            set(hi(i),'backgroundcolor',FigureBack,'foregroundcolor',FigureText);
            
        case 'slider'
            set(hi(i),'fontname','default');
            set(hi(i),'backgroundcolor',TextBack,'foregroundcolor',Text);
            
        case 'togglebutton'
            set(hi(i),'fontname','default');
            % For toggle buttons, set the background different when it's
            %  toggled down
            val = get(hi(i),'value'); % is the button up or down
            switch val
            case 0 % up, off
                set(hi(i),'backgroundcolor',ToggleOff,'foregroundcolor',ButtonText);
            case 1 % down, on
                set(hi(i),'backgroundcolor',ToggleOn,'foregroundcolor',dark);
            end
            
        case 'uitoolbar'
            % do nothing, uitoolbars are a new undocumented feature
            
        otherwise
            disp(['BST_COLOR_SCHEME: unknown UICONTROL STYLE to color: ' hstyle])
            
        end % switch hstyle for the uicontrol style
        
    case 'text'
        % do nothing
        
    otherwise
        disp(['BST_COLOR_SCHEME: unknown OBJECT TYPE to color: ',htype])
        
    end % switch htype for the type of object
    
end % for all handles
