function varargout = bst_static_taskbar(varargin)
%BST_STATIC_TASKBAR - BrainStorm's primary taskbar always visible
% function varargout = bst_static_taskbar(varargin)
%    FIG = BST_STATIC_TASKBAR launch bst_static_taskbar GUI.
%    BST_STATIC_TASKBAR('callback_name', ...) invoke the named callback.
%
% Comments on this taskbar, programming guide, etc:
%
% Important Application data are maintained in this GUI, for referencing by other 
%  dynamic toolbars and tiles. Handle visibility is on and non-integer. 
% Tag for the gui is the "static_taskbar".
% Let fig = findobj(get(0,'chil'),'flat','tag','static_taskbar');
% These application data are stored in the figure handle, accessible as
%  getappdata(fig,<appname>), or getappdata(gcf,<appname>) inside these callbacks.
% STUDY, MRI, TESS, HEADMODEL, DATA, RESULTS
%  For each of these appdata, a list of full referential filenames are returned in
%  a cell array. STUDY is simply the Comment displayed in the static taskbar
% To get the current MRI filename displayed, use 
%  [fname,h,AllFilenames] = bst_static_taskbar('GET','MRI');
% fname is a CELL ARRAY of strings currently selected
% and similarly for the other tags
% h is the handle of the popup
% AllFilenames is the cell array of all names in the popup
%  (identical to getappdata(fig,<appname>));
% For the EEG, MEG, and Other checkboxes, use
%  [val,enable,h] = bst_static_taskbar('GET','MEG'),
%  or 'EEG', or 'OTHER'.
%
% AllFilenames = bst_static_taskbar('RefreshResults') will return
%  the cellarray of all filenames after refreshing the list.
%
% Examples:
%  Assume fig points to the bst_static_taskbar
%  fig = findobj(get(0,'chil'),'flat','tag','static_taskbar');
%
%  To get the full list of current data files in the study
%  datanames = getappdata(fig,'DATA'); % referential filenames
%  
%  To get the data name currently pointed at in the taskbar
%  [fname,h] = bst_static_taskbar('GET','DATA'); % referential filename
% 
%  To see if the user wants MEG data
%  [val,enable,h] = bst_static_taskbar('GET','MEG');
%  or simply
%  val = bst_static_taskbar('GET','MEG');

%<autobegin> ---------------------- 14-Jun-2004 17:10:10 -----------------------
% --------- Automatically Generated Comments Block Using AUTO_COMMENTS ---------
%
% CATEGORY: GUI and Related
%
% Alphabetical list of external functions (non-Matlab):
%   toolbox\bst_color_scheme.m
%   toolbox\bst_headmodeler.m
%   toolbox\bst_layout.m
%   toolbox\bst_message_window.m
%   toolbox\bst_mriviewer.m
%   toolbox\bst_splashscreen.m
%   toolbox\bst_static_taskbar.m  NOTE: Routine calls itself explicitly
%   toolbox\bst_win_manager.m
%   toolbox\data_manager.m
%   toolbox\dataplot_cb.m
%   toolbox\get_user_directory.m
%   toolbox\headmodeler_gui.m
%   toolbox\help_data_raw.m
%   toolbox\help_database_list.m
%   toolbox\help_editing_brainstorm.m
%   toolbox\help_manager.m
%   toolbox\layout_manager.m
%   toolbox\makeuswait.m
%   toolbox\mri_read_tool.m
%   toolbox\mritool_cb.m
%   toolbox\parametric_estimation.m
%   toolbox\rap_music_parameters.m
%   toolbox\readme.m
%   toolbox\simulator.m
%   toolbox\simulator_mri.m
%   toolbox\sourceimaging.m
%   toolbox\subject_editor.m
%   toolbox\web_pages.m
%
% Subfunctions in this file, in order of occurrence in file:
%   varargout = GET(TAG);
%   varargout = SET(TAG,CELLSTRING);
%   set_isRefreshData;
%   set_isRefreshResults;
%   select_deselect_all(h, handles);
%   select_deselect_file(h, handles, action);
%   AllFilenames = RefreshResults;
%   varargout = popupmenu_MRI_Callback(h, eventdata, handles, varargin)
%   varargout = popupmenu_TESS_Callback(h, eventdata, handles, varargin)
%   varargout = popupmenu_HEADMODEL_Callback(h, eventdata, handles, varargin)
%   varargout = popupmenu_DATA_Callback(h, eventdata, handles, varargin)
%   varargout = pushbutton_previous_data_Callback(h, eventdata, handles, varargin)
%   varargout = pushbutton_next_data_Callback(h, eventdata, handles, varargin)
%   varargout = checkbox_MEG_Callback(h, eventdata, handles, varargin)
%   varargout = checkbox_EEG_Callback(h, eventdata, handles, varargin)
%   varargout = checkbox_OTHER_Callback(h, eventdata, handles, varargin)
%   varargout = popupmenu_RESULTS_Callback(h, eventdata, handles, varargin)
%   varargout = pushbutton_previous_results_Callback(h, eventdata, handles, varargin)
%   varargout = pushbutton_next_results_Callback(h, eventdata, handles, varargin)
%   varargout = menu_datamanager_Callback(h, eventdata, handles, varargin)
%   varargout = menu_mri_viewer_baillet_Callback(h, eventdata, handles, varargin)
%   varargout = menu_mri_alex_Callback(h, eventdata, handles, varargin)
%   varargout = menu_results_visualization_Callback(h, eventdata, handles, varargin)
%   varargout = menu_tesselation_manager_Callback(h, eventdata, handles, varargin)
%   varargout = menu_simulate_mri_Callback(h, eventdata, handles, varargin)
%   varargout = menu_simulate_data_Callback(h, eventdata, handles, varargin)
%   varargout = menu_quit_Callback(h, eventdata, handles, varargin)
%   varargout = menu_information_Callback(h, eventdata, handles, varargin)
%   varargout = menu_editor_Callback(h, eventdata, handles, varargin)
%   varargout = menu_viewer_Callback(h, eventdata, handles, varargin)
%   varargout = menu_default_headmodel_Callback(h, eventdata, handles, varargin)
%   varargout = menu_advanced_headmodels_Callback(h, eventdata, handles, varargin)
%   varargout = menu_MinNorm_Callback(h, eventdata, handles, varargin)
%   varargout = menu_MinNorm_recursive_Callback(h, eventdata, handles, varargin)
%   varargout = menu_STmap_Callback(h, eventdata, handles, varargin)
%   varargout = menu_Tiling_Callback(h, eventdata, handles, varargin)
%   varargout = menu_LCMV_scan_Callback(h, eventdata, handles, varargin)
%   varargout = menu_MUSIC_cortical_Callback(h, eventdata, handles, varargin)
%   varargout = menu_LCMV_Callback(h, eventdata, handles, varargin)
%   varargout = menu_RAPmusic_Callback(h, eventdata, handles, varargin)
%   varargout = menu_Rmusic_Callback(h, eventdata, handles, varargin)
%   varargout = menu_LeastSquares_Callback(h, eventdata, handles, varargin)
%   varargout = menu_layout_Callback(h, eventdata, handles, varargin)
%   varargout = menu_snap_Callback(h, eventdata, handles, varargin)
%   varargout = MRIViewer_Callback(h, eventdata, handles, varargin)
%   varargout = menu_message_Callback(h, eventdata, handles, varargin)
%   varargout = menu_help_contents_Callback(h, eventdata, handles, varargin)
%   menu_help_whatsnew_Callback(hObject, eventdata, handles)
%   varargout = menu_help_online_Callback(h, eventdata, handles, varargin)
%   varargout = menu_help_html_Callback(h, eventdata, handles, varargin)
%   varargout = menu_help_newuser_Callback(h, eventdata, handles, varargin)
%   menu_help_montreal_Callback(hObject, eventdata, handles)
%   varargout = menu_help_tutorial_Callback(h, eventdata, handles, varargin)
%   help_editing_bst_Callback(hObject, eventdata, handles)
%   menu_help_forum_Callback(hObject, eventdata, handles)
%   AboutBrainStorm_Callback(hObject, eventdata, handles)
%   help_DatabaseStructure_Callback(hObject, eventdata, handles)
%   help_formatRAW_Callback(hObject, eventdata, handles)
%   varargout = pushbutton_data_Callback(h, eventdata, handles, varargin)
%   varargout = pushbutton_quit_Callback(h, eventdata, handles, varargin)
%   varargout = pushbutton_snap_Callback(h, eventdata, handles, varargin)
%   varargout = pushbutton_layout_Callback(h, eventdata, handles, varargin)
%   varargout = pushbutton_view_Callback(h, eventdata, handles, varargin)
%   varargout = pushbutton_info_Callback(h, eventdata, handles, varargin)
%   varargout = pushbutton_help_Callback(h, eventdata, handles, varargin)
%   varargout = pushbutton_editor_Callback(h, eventdata, handles, varargin)
%   varargout = pushbutton_msgs_Callback(h, eventdata, handles, varargin)
%
% Group : Preference data and their calls in this file:
%   'BrainStorm' : 'CurrentData'
%   
%   setpref('BrainStorm','CurrentData',CurrentData);
%   
%   CurrentData = getpref('BrainStorm','CurrentData');
%   L = getpref('BrainStorm','Layout');
%   VER = getpref('BrainStorm','Version');
%   brainstormHomeDirectory = getpref('BrainStorm','brainstormHomeDir');
%
% Application data and their calls in this file:
%    
%   'DefaultCheckChar'
%   'TileType'
%   'isRefreshData'
%   'isRefreshResults'
%   
%   setappdata(fig,'DefaultCheckChar','*');
%   setappdata(fig,'TileType','S');
%   setappdata(fig,TAG,CELLSTRING);
%   setappdata(fig_view_manager,'isRefreshData',1);
%   setappdata(fig_view_manager,'isRefreshResults',1);
%   
%   APPDATA = getappdata(fig,TAG);
%   AllFilenames = getappdata(fig,'RESULTS');
%   DATA = getappdata(fig,'DATA');
%   DATA = getappdata(handles.static_taskbar,'DATA');
%   DefaultCheckChar = getappdata(fig,'DefaultCheckChar');
%   HEADMODEL = getappdata(fig,'HEADMODEL');
%   MRI = getappdata(fig,'MRI');
%   RESULTS = getappdata(fig,'RESULTS');
%   RESULTS = getappdata(handles.static_taskbar,'RESULTS');
%   TESS = getappdata(fig,'TESS');
%   fig = getappdata(0,'BrainStormMessageWindow');
%
% Figure Files opened by this function:
%   mfilename
%
%   Format of strings below: Type:Style:Tag, "String", CallBack Type and Call
%   <automatic> callback is <Tag>_Callback by Matlab default
%
% Callbacks by figure bst_static_taskbar.fig
%   uicontrol:checkbox:checkbox_EEG "EEG" uses Callback for <automatic>
%   uicontrol:checkbox:checkbox_MEG "MEG" uses Callback for <automatic>
%   uicontrol:checkbox:checkbox_OTHER "Other" uses Callback for <automatic>
%   uicontrol:popupmenu:popupmenu_DATA "Data file(s)" uses Callback for <automatic>
%   uicontrol:popupmenu:popupmenu_HEADMODEL "Headmodel(s)" uses Callback for <automatic>
%   uicontrol:popupmenu:popupmenu_MRI "MRI files" uses Callback for <automatic>
%   uicontrol:popupmenu:popupmenu_RESULTS "Results file(s)" uses Callback for <automatic>
%   uicontrol:popupmenu:popupmenu_TESS "Tessellation files" uses Callback for <automatic>
%   uicontrol:pushbutton:pushbutton_next_data ">" uses Callback for <automatic>
%   uicontrol:pushbutton:pushbutton_next_results ">" uses Callback for <automatic>
%   uicontrol:pushbutton:pushbutton_previous_data "<" uses Callback for <automatic>
%   uicontrol:pushbutton:pushbutton_previous_results "<" uses Callback for <automatic>
%   uimenu::AboutBrainStorm "" uses Callback for <automatic>
%   uimenu::help_DatabaseStructure "" uses Callback for <automatic>
%   uimenu::help_editing_bst "" uses Callback for <automatic>
%   uimenu::help_formatRAW "" uses Callback for <automatic>
%   uimenu::menu_advanced_headmodels "" uses Callback for <automatic>
%   uimenu::menu_datamanager "" uses Callback for <automatic>
%   uimenu::menu_default_headmodel "" uses Callback for <automatic>
%   uimenu::menu_editor "" uses Callback for <automatic>
%   uimenu::menu_help_contents "" uses Callback for <automatic>
%   uimenu::menu_help_forum "" uses Callback for <automatic>
%   uimenu::menu_help_html "" uses Callback for <automatic>
%   uimenu::menu_help_montreal "" uses Callback for <automatic>
%   uimenu::menu_help_newuser "" uses Callback for <automatic>
%   uimenu::menu_help_online "" uses Callback for <automatic>
%   uimenu::menu_help_tutorial "" uses Callback for <automatic>
%   uimenu::menu_help_whatsnew "" uses Callback for <automatic>
%   uimenu::menu_information "" uses Callback for <automatic>
%   uimenu::menu_layout "" uses Callback for <automatic>
%   uimenu::menu_LCMV "" uses Callback for <automatic>
%   uimenu::menu_LCMV_scan "" uses Callback for <automatic>
%   uimenu::menu_LeastSquares "" uses Callback for <automatic>
%   uimenu::menu_message "" uses Callback for <automatic>
%   uimenu::menu_MinNorm "" uses Callback for <automatic>
%   uimenu::menu_MinNorm_recursive "" uses Callback for <automatic>
%   uimenu::menu_mri_alex "" uses Callback for <automatic>
%   uimenu::menu_mri_viewer_baillet "" uses Callback for <automatic>
%   uimenu::menu_MUSIC_cortical "" uses Callback for <automatic>
%   uimenu::menu_quit "" uses Callback for <automatic>
%   uimenu::menu_RAPmusic "" uses Callback for <automatic>
%   uimenu::menu_results_visualization "" uses Callback for <automatic>
%   uimenu::menu_Rmusic "" uses Callback for <automatic>
%   uimenu::menu_simulate_data "" uses Callback for <automatic>
%   uimenu::menu_simulate_mri "" uses Callback for <automatic>
%   uimenu::menu_snap "" uses Callback for <automatic>
%   uimenu::menu_STmap "" uses Callback for <automatic>
%   uimenu::menu_tesselation_manager "" uses Callback for <automatic>
%   uimenu::menu_Tiling "" uses Callback for <automatic>
%   uimenu::menu_viewer "" uses Callback for <automatic>
%   uimenu::MRIViewer "" uses Callback for <automatic>
%
% At Check-in: $Author: Mosher $  $Revision: 56 $  $Date: 6/14/04 3:37p $
%
% This software is part of BrainStorm Toolbox Version 2.0 (Alpha) 14-Jun-2004
% 
% Principal Investigators and Developers:
% ** Richard M. Leahy, PhD, Signal & Image Processing Institute,
%    University of Southern California, Los Angeles, CA
% ** John C. Mosher, PhD, Biophysics Group,
%    Los Alamos National Laboratory, Los Alamos, NM
% ** Sylvain Baillet, PhD, Cognitive Neuroscience & Brain Imaging Laboratory,
%    CNRS, Hopital de la Salpetriere, Paris, France
% 
% See BrainStorm website at http://neuroimage.usc.edu for further information.
% 
% Copyright (c) 2004 BrainStorm by the University of Southern California
% This software distributed  under the terms of the GNU General Public License
% as published by the Free Software Foundation. Further details on the GPL
% license can be found at http://www.gnu.org/copyleft/gpl.html .
% 
% FOR RESEARCH PURPOSES ONLY. THE SOFTWARE IS PROVIDED "AS IS," AND THE
% UNIVERSITY OF SOUTHERN CALIFORNIA AND ITS COLLABORATORS DO NOT MAKE ANY
% WARRANTY, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO WARRANTIES OF
% MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, NOR DO THEY ASSUME ANY
% LIABILITY OR RESPONSIBILITY FOR THE USE OF THIS SOFTWARE.
%<autoend> ------------------------ 14-Jun-2004 17:10:10 -----------------------

% ACTIONS ---------------------------------------------------------
% When data are selected in the data_manager, the fields in this
%  GUI are updated. The reverse does not happen, i.e. actions in
%  this GUI do not update fields in the data_manager.
%
% When data or results are changed, the isRefreshData and isRefreshResults
%  flags are set in the GUI view_manager. It is up to the view_manager
%  to act later on those flags. See view_manager.
% -----------------------------------------------------------------

% HISTORY ---------------------------------------------------------
% 28 May 2003 JCM  First build from the dummy version created in Paris. Defined
%                  application data, setup the SET/GET utility function.
% 18 Jun 2003 SB   Added callback to check/uncheck selected file names in pulldown menus
%                  Changed specific callback for get(DATA) and get(RESULTS) command : multiple file names might be returned when several files are checked
%                  fname is a CELL ARRAY of strings
% 11 Jul 2003 SB   Properly display results files 
% 15-Sep-2003 JCM  Refresh data flags in the view_manager, select/deselect all
% 17-Sep-2003 JCM  Enhanced features to select or deselect a particular file, added
%                  select_deselect_file local function
%  7-Oct-2003 JCM  Added extra return to the "GET" function to return the full list
%                  of filenames in the popups. Added RefreshResults local function
% 12-Nov-2003 JCM  Fixed position of exploded message window to be lower left
%                  Dramatic change to menus rather than buttons
% 19-Jan-2004 SB   Make us wait using Watch pointer while loading data into Viewer
% 22-Jan-2004 SB   Added errordlg when user has not selected proper object from pulldown menus
% 10-Mar-2004 SB   Added call to new MRIViewer
% 19-Apr-2004 JCM  Fixed html help to point to "1Toolbox"
% 28-Apr-2004 JCM  Greyed out unused fast analysis routines in the "create"
%                  script below
% -------------------- History ------------------------------------

% Last Modified by GUIDE v2.5 11-Jun-2004 16:23:47

if nargin == 0  % LAUNCH GUI
   
   fig = openfig(mfilename,'reuse');
   
   % Generate a structure of handles to pass to callbacks, and store it. 
   handles = guihandles(fig);
   guidata(fig, handles);
   
   % some customizations are done here, to avoid always using GUIDE on the .fig
   % Help labels

   % The contents help uses the Contents.m convention of Matlab
   set(handles.menu_help_contents,'Label','BrainStorm Contents')
   % The html help is generated by a Perl script 
   set(handles.menu_help_html,'Label','Local Web Pages')
   
   bst_color_scheme(fig);
   setappdata(fig,'TileType','S'); % static toolbar, only one allowed
   bst_layout('align',fig); % align this taskbar
   
   VER = getpref('BrainStorm','Version');
   set(fig,'Name',sprintf('%s Version %s %s %s',VER.Name,VER.Version,VER.Release,VER.Date));
   
   % Fast analysis menu activiate/deactivate list
   % Non operational menu items, remove as they become operational:
   NOOP = {'menu_MinNorm','menu_MinNorm_recursive','menu_STmap','menu_Tiling',...
         'menu_LCMV_scan','menu_MUSIC_cortical','menu_LCMV','menu_Rmusic','menu_LeastSquares'};
   
   for i = 1:length(NOOP),
      eval(sprintf('h = handles.%s;',NOOP{i})); % get handle
      set(h,'enable','off');
   end
   
   set(fig,'visible','on');
   
   setappdata(fig,'DefaultCheckChar','*'); % flag that file is selected
   % i.e. we prepend the DefaultCheckChar to the filename if the
   % user has selected this file.
   
   if nargout > 0
      varargout{1} = fig;
   end
   
elseif ischar(varargin{1}) % INVOKE NAMED SUBFUNCTION OR CALLBACK
   
   try
      if (nargout)
         [varargout{1:nargout}] = feval(varargin{:}); % FEVAL switchyard
      else
         feval(varargin{:}); % FEVAL switchyard
      end
   catch
      disp(lasterr);
   end
   
end

% local callback functions here
% --------------- GET STUDY INFORMATION ----------------------------
function varargout = GET(TAG);
% utility function for retrieving tag information
%
% retrieve the fully qualified filename and the handle to the popup
% If the varargin is 'GET', then the second argument of the popups
% 'MRI' 
% 'TESS'
% 'HEADMODEL'
% 'DATA'
% 'RESULTS'
% return the filename, the handle of the uicontrol, and the
%  full cell array of filenames
% [fname,h,AllFiles] = bst_static_taskbar('GET','MRI');
%
% Similarly, for the second arguments of the checkboxes
% 'MEG'
% 'EEG'
% 'OTHER'
% return the enable status, the value and the handle
%  [val,enable,h] = bst_static_taskbar('GET','MEG');

% find the static taskbar
fig = findobj(get(0,'children'),'flat','tag','static_taskbar'); 

switch TAG
case {'MRI','TESS','HEADMODEL'} % popups
   % e.g. [fname,h,AllFilenames] = bst_static_taskbar('GET','MRI');
   
   POPTAG = sprintf('popupmenu_%s',TAG); % make the tag
   h = findobj(fig,'TAG',POPTAG); % find the handle to the popup
   val = get(h,'val'); % what value is it
   APPDATA = getappdata(fig,TAG); % get the filenames
   if isempty(APPDATA)
      fname = [];
   else
       if val > length(APPDATA) % User has not selected a filename in pulldown but a call to a tool. e.g. tessellation handler etc.
           switch(TAG)
           case 'TESS'
               errordlg('Please make sure you have selected a tessellated envelope in pulldown menu from static taskbar.')
               varargout{1} = []; varargout{2} = [];
               return
           end
       else
           fname = APPDATA{val}; % the present filename
       end
       
   end
   varargout{1} = fname;
   varargout{2} = h;
   varargout{3} = APPDATA; % All Filenames
   
case {'DATA','RESULTS'} 
   % SB 18-Jun-2003 | Special case for data handling - several files might be selected
   
   DefaultCheckChar = getappdata(fig,'DefaultCheckChar');
   
   POPTAG = sprintf('popupmenu_%s',TAG); % make the tag
   h = findobj(fig,'TAG',POPTAG); % find the handle to the popup
   
   str = get(h,'String');
   val = find(strncmp(str,DefaultCheckChar,1)); 
   % Index of data file names that are checked in the popupmenu list
   
   APPDATA = getappdata(fig,TAG); % get the filenames
   fname = APPDATA(val); % cell array of selected filenames
   
   varargout{1} = fname;
   varargout{2} = h;
   varargout{3} = APPDATA; % All Filenames
   
   
case {'MEG','EEG','OTHER'}
   % e.g. [enable,val,h] = bst_static_taskbar('GET','MEG');
   
   POPTAG = sprintf('checkbox_%s',TAG); % make the tag
   h = findobj(fig,'TAG',POPTAG); % find the handle to the popup
   enable = get(h,'enable'); % its status 'off' is no such data, 'on' is available
   val = get(h,'val'); % what value is it, 1 means use, 0 means no
   varargout{1} = val;
   varargout{2} = enable;
   varargout{3} = h;
   
case 'STUDY'
   % [fname,h] = bst_static_taskbar('GET','STUDY');
   POPTAG = sprintf('text_%s',TAG);
   h = findobj(fig,'TAG',POPTAG);
   fname = get(h,'string');
   varargout{1} = fname;
   varargout{2} = h;
   
otherwise
   error(sprintf('unknown tag in %s, ''GET(%s)''',mfilename,TAG))
end


% ------------ SET STUDY INFORMATION ------------------------
function varargout = SET(TAG,CELLSTRING);
% utility function to SET the popups and checkboxes
% Same tags anticipated as in GET above
% For the checkboxes, the CELLSTRING should be 'on' or 'off'
%  to indicate the status. Otherwise,the CELLSTRING should be the 
%  cell array of fully qualified filenames. This routine will then set the
%  popup strings accordingly.
% If TAG is sent with the null data, then display set accordingly with (none).

% find the static taskbar
fig = findobj(get(0,'children'),'flat','tag','static_taskbar'); 

switch TAG
case {'MRI','TESS','HEADMODEL','DATA','RESULTS'} % popups
   % e.g. [fname,h] = bst_static_taskbar('GET','MRI');
   
   POPTAG = sprintf('popupmenu_%s',TAG); % make the tag
   h = findobj(fig,'tag',POPTAG); % find the handle to the popup
   
   % now make the popup strings from the filenames
   popupstr = cell(length(CELLSTRING),1); % cell array allocate
   popupstr{1} = '(no files)'; % default initialize for empty string
   for i = 1:length(CELLSTRING),
      [pathstr,name,ext,versn] = fileparts(CELLSTRING{i});
      popupstr{i} = name;
   end
   
   switch TAG
      % now custom popup string developments
   case 'MRI'
      popupstr{end+1} = '(MRI Manager)';
   case 'TESS'
      popupstr{end+1} = '(Tesselation Manager)';
   case 'HEADMODEL'
      popupstr{end+1} = '(Head Model Generator)';
   case 'DATA'
      popupstr{end+1} = '(Select/Deselect All)';
      popupstr{end+1} = '(Data Manager)';
   case 'RESULTS'
      popupstr{end+1} = '(Select/Deselect All)';
      popupstr{end+1} = '(Action?)';
   end
   
   set(h,'val',1,'string',popupstr); % set value to first, load string
   
   setappdata(fig,TAG,CELLSTRING); % set the filenames into the figure
   
case {'MEG','EEG','OTHER'}
   % e.g. [enable,val,h] = bst_static_taskbar('GET','MEG');
   
   POPTAG = sprintf('checkbox_%s',TAG); % make the tag
   h = findobj(fig,'TAG',POPTAG); % find the handle to the popup
   set(h,'enable',CELLSTRING); % its status 'off' is no such data, 'on' is available
   set(h,'val',0); % default off
   
case 'STUDY'
   POPTAG = sprintf('text_%s',TAG);
   h = findobj(fig,'TAG',POPTAG);
   set(h,'string',CELLSTRING);
   
   
otherwise
   error(sprintf('unknown tag in %s, ''GET(%s)''',mfilename,TAG))
end



% ----------------- Set the Refresh Flag --------------
function set_isRefreshData;
% If the view_manager is up, set its refresh flag
fig_view_manager = findobj(0,'tag','view_manager');
if ~isempty(fig_view_manager),
   setappdata(fig_view_manager,'isRefreshData',1);
end




% ----------------- Set the Refresh Flag --------------
function set_isRefreshResults;
% If the view_manager is up, set its refresh flag
fig_view_manager = findobj(0,'tag','view_manager');
if ~isempty(fig_view_manager),
   setappdata(fig_view_manager,'isRefreshResults',1);
end



% ------------------ Select or Deselect all files -----
function select_deselect_all(h, handles);
% select all or none of the files

fig = handles.static_taskbar; % handy shortcut
DefaultCheckChar = getappdata(fig,'DefaultCheckChar');

str = get(h,'string'); % cell array of names

selected = strncmp(str,DefaultCheckChar,1); % check first character
selected([-1:0]+end) = []; % don't care about last two

if all(selected),
   selected(1:end) = 0; % unselect
elseif ~all(selected),
   selected(1:end) = 1; % select all
end

% mixed case
if(any(selected)),
   %then they are all selected
   selected(1:end) = 1;
end

% now selected is either all ones or zeros
selected = any(selected); % now its a scalar

% now fix each of the strings
for i = 1:(length(str)-2), % not the last two
   switch selected
   case 0
      if strncmp(str{i},DefaultCheckChar,1),
         % remove it
         str{i} = str{i}(2:end);
      end
   case 1
      if ~strncmp(str{i},DefaultCheckChar,1)
         % add it
         str{i} = sprintf('%s%s',DefaultCheckChar,str{i});
      end
   end
end

set(h,'string',str);



% ------------------ Select or Deselect one file -----
function select_deselect_file(h, handles, action);
% ACTION is {'SET','CLEAR','TOGGLE'};
% select (mark as checked) the selected file
% unselect (clear the mark) for the selecte file
% toggle the state from select to unselect or vice versa

fig = handles.static_taskbar; % handy shortcut
DefaultCheckChar = getappdata(fig,'DefaultCheckChar');

str = get(h,'string'); % cell array of names
val = get(h,'val'); % which file are we looking at

% just care about the current one
selected = strncmp(str(val),DefaultCheckChar,1); % check first character

switch action
case 'SET'
   if ~selected,
      % file wasn't already checked, prepend check mark
      str{val} = sprintf('%s%s',DefaultCheckChar,str{val});
      set(h, 'string', str);
   end
   
case 'CLEAR'
   if selected
      % was not clear
      str{val} = str{val}(2:end); % clear the check mark
      set(h, 'string', str);
   end
   
case 'TOGGLE'
   if selected
      str{val} = str{val}(2:end); % clear the check mark
   else
      str{val} = sprintf('%s%s',DefaultCheckChar,str{val});
   end 
   
   set(h, 'string', str);
   
otherwise
   error(sprintf('Unknown action in %s : %s',mfilename,action));
end


% ---------- Refresh the results file -----------------
function AllFilenames = RefreshResults;
% call as AllFilenames = bst_static_taskbar('RefreshResults');

% find the static taskbar
fig = findobj(get(0,'children'),'flat','tag','static_taskbar'); 

handles = guihandles(fig);  % all of the handles

% now call the DATA popup as though it had been pressed
popupmenu_DATA_Callback(handles.popupmenu_DATA, [], handles);

% this will rebuild the RESULTS popup for the current data
AllFilenames = getappdata(fig,'RESULTS'); % the list of filenames



% --------------- CALLBACK FUNCTIONS -------------------------------

% --------------------------------------------------------------------
function varargout = popupmenu_MRI_Callback(h, eventdata, handles, varargin)
% list of MRIs available for the current study, or call the MRI viewer

fig = handles.static_taskbar; % handy shortcut
val = get(h,'val'); % where are we in the popup
MRI = getappdata(fig,'MRI');

if(val > length(MRI)),
   % launch the mri tool
   mritool_cb('create');
end

set(h,'Value',1); % back to beginning



% --------------------------------------------------------------------
function varargout = popupmenu_TESS_Callback(h, eventdata, handles, varargin)
% list of tesselations available for the current study, or call the tesselation manager

fig = handles.static_taskbar; % handy shortcut
val = get(h,'val'); % where are we in the popup
TESS = getappdata(fig,'TESS');

if(val > length(TESS)),
   % launch the tool
   editfig = subject_editor('create'); % CHEAT, for now launch the mri tool
end

%set(h,'Value',1); % back to beginning | Leave user see which file he has selected  



% --------------------------------------------------------------------
function varargout = popupmenu_HEADMODEL_Callback(h, eventdata, handles, varargin)
% list of headmodels available for the current study, or call the headmodeler

fig = handles.static_taskbar; % handy shortcut
val = get(h,'val'); % where are we in the popup
HEADMODEL = getappdata(fig,'HEADMODEL');

if(val > length(HEADMODEL)),
   % Basic call - will change when new headmodelling routine will be available
   %GuiData = guidata(h); % obsolete
   Users = get_user_directory; 
   headmodeler_gui('LoadStudy',Users.CurrentData.StudyFile)
end

%set(h,'Value',1); % back to beginning | %SB : no, we need to get the value of selected headmodel file
% in list when calling e.g. sourceimaging.m

% check if source imaging window is open - if yes, load selected headmodel
SrcImagingGUI = bst_win_manager;
if isfield(SrcImagingGUI,'Source')
    if ishandle(SrcImagingGUI.Source)
        sourceimaging('LHeadModels')
    end
end




% --------------------------------------------------------------------
function varargout = popupmenu_DATA_Callback(h, eventdata, handles, varargin)
% list of data files in this study, or call the data manager
% for each data file selected, update the list of results for this file

fig = handles.static_taskbar; % handy shortcut
val = get(h,'val'); % where are we in the popup
DATA = getappdata(fig,'DATA');
DefaultCheckChar = getappdata(fig,'DefaultCheckChar');

if(val > length(DATA)),
   
   % this case handles the extra tags below the data names for 
   %  other actions.
   val = val - length(DATA); % subtract the number of data files
   
   if(length(DATA) == 0), 
      % there were no files, just the first line of "none"
      val = val - 1;
   end
   
   switch val
      
   case 1
      % select deselect all
      select_deselect_all(h, handles); % add or remove the check char
      
   case 2
      % activate data manager
      data_manager;
      
   end
   
   val = 1; % set it to the first value
   set(h,'Value',val); % back to beginning
   
else
   % SB 18-Jun-2003 | Select/Unselect file names by placing/removing a check mark
   % JCM 17-Sep-2003 used local function call instead
   select_deselect_file(h, handles, 'TOGGLE'); % toggle state of file
   
   % local function to refresh data in the view_manager
   set_isRefreshData;
end

% set the results popup


% Now also update the popup in the static taskbar
% set the results popup to default to the first file
if(~isempty(DATA)),
   
   % set the current data to this file
   CurrentData = getpref('BrainStorm','CurrentData');
   CurrentData.DataFile = DATA{val};
   setpref('BrainStorm','CurrentData',CurrentData);
   
   Users = get_user_directory;
   
   cd(Users.STUDIES);
   
   [refpath,tempname] = fileparts(DATA{val}); % the file, name only
   cd(refpath);
   
   ResultsFiles = dir(sprintf('*%s*results*',tempname)); % SB | Older version of results filename format - enforce backward compatibility
   tempname = strrep(tempname,'data','results'); % leader with results substituted
   ResultsFiles = [ResultsFiles;dir(sprintf('*%s*',tempname))];
   
   if(~isempty(ResultsFiles)),
      ResultsFiles = {ResultsFiles.name};
      for i = 1:length(ResultsFiles),
         ResultsFiles{i} = fullfile(refpath,ResultsFiles{i});
      end
   else
      ResultsFiles = [];
   end
   
   bst_static_taskbar('SET','RESULTS',ResultsFiles);
   
   % local function to refresh data in the view_manager
   set_isRefreshResults;
   
else
   bst_static_taskbar('SET','RESULTS',[]);
end






% --------------------------------------------------------------------
function varargout = pushbutton_previous_data_Callback(h, eventdata, handles, varargin)
% "arrow" button to sequence in the data list

h = handles.popupmenu_DATA; % shortcut
DATA = getappdata(handles.static_taskbar,'DATA');

val = get(h,'val'); % where are we pointed now

if(val > 1),
   % valid location in popup
   newval = val - 1;
   % first unselect the current file
   select_deselect_file(h, handles, 'CLEAR'); % clear state of file
   set(h,'val',newval);
   % now set the new file
   select_deselect_file(h, handles, 'SET'); % mark state of file
   
   % local function to refresh data in the view_manager
   set_isRefreshData;
else
   % val is one, stay where we are, no-op
end

% Load data
menu_viewer_Callback(h, eventdata, handles)

% --------------------------------------------------------------------
function varargout = pushbutton_next_data_Callback(h, eventdata, handles, varargin)
% "arrow" button to sequence in the data list

h = handles.popupmenu_DATA; % shortcut
DATA = getappdata(handles.static_taskbar,'DATA');

val = get(h,'val'); % where are we pointed now

if(val < length(DATA)),
   newval = val + 1;
   % first unselect the current file
   select_deselect_file(h, handles, 'CLEAR'); % clear state of file
   set(h,'val',newval);
   % now set the new file
   select_deselect_file(h, handles, 'SET'); % mark state of file
   % local function to refresh data in the view_manager
   set_isRefreshData;
else
   % val is at end of data list, stay here, no-op
end




% --------------------------------------------------------------------
function varargout = checkbox_MEG_Callback(h, eventdata, handles, varargin)




% --------------------------------------------------------------------
function varargout = checkbox_EEG_Callback(h, eventdata, handles, varargin)




% --------------------------------------------------------------------
function varargout = checkbox_OTHER_Callback(h, eventdata, handles, varargin)




% --------------------------------------------------------------------
function varargout = popupmenu_RESULTS_Callback(h, eventdata, handles, varargin)

fig = handles.static_taskbar; % handy shortcut
val = get(h,'val'); % where are we in the popup
RESULTS = getappdata(fig,'RESULTS');

if(val > length(RESULTS)),
   
   val = val - length(RESULTS); % subtract the number of data files
   
   if(length(RESULTS) == 0), 
      % there were no files, just the first line of "none"
      val = val - 1;
   end
   
   switch val
   case 1
      % select deselect all
      select_deselect_all(h,handles);
      
   case 2
      % undecided action
   end
   
   set(h,'val',1); % set back to the beginning
   
else
   % SB 18-Jun-2003 | Select/Unselect file names by placing/removing a check mark
   % JCM 17-Sep-2003 replaced with function
   select_deselect_file(h, handles, 'TOGGLE'); % Toggle state of file
   % local function to refresh data in the view_manager
   set_isRefreshResults;
   
end



% --------------------------------------------------------------------
function varargout = pushbutton_previous_results_Callback(h, eventdata, handles, varargin)
% "arrow" button to sequence in the results list

h = handles.popupmenu_RESULTS; % shortcut
RESULTS = getappdata(handles.static_taskbar,'RESULTS');

val = get(h,'val'); % where are we pointed now

if(val > 1),
   newval = val - 1;
   % first unselect the current file
   select_deselect_file(h, handles, 'CLEAR'); % clear state of file
   set(h,'val',newval);
   % now set the new file
   select_deselect_file(h, handles, 'SET'); % mark state of file
   % local function to refresh data in the view_manager
   set_isRefreshResults;
else
  % stay there, we're at beginning, no-op
end

% Load in memory 
menu_viewer_Callback(h, eventdata, handles, []),


% --------------------------------------------------------------------
function varargout = pushbutton_next_results_Callback(h, eventdata, handles, varargin)
% "arrow" button to sequence in the results list

h = handles.popupmenu_RESULTS; % shortcut
RESULTS = getappdata(handles.static_taskbar,'RESULTS');

val = get(h,'val'); % where are we pointed now

if(val < length(RESULTS)),
   newval = val + 1;
   % first unselect the current file
   select_deselect_file(h, handles, 'CLEAR'); % clear state of file
   set(h,'val',newval);
   % now set the new file
   select_deselect_file(h, handles, 'SET'); % mark state of file
   % local function to refresh data in the view_manager
   set_isRefreshResults;
else
  % stay there, we're at end
end

% Load in memory 
menu_viewer_Callback(h, eventdata, handles, []),


% ------------------  MENU ACTION SECTION -----------------------
% ----------------- FILE MENU ITEMS -----------------------------------
% --------------------------------------------------------------------
function varargout = menu_datamanager_Callback(h, eventdata, handles, varargin)
% activate the data manager

data_manager


% --------------------------------------------------------------------
function varargout = menu_mri_viewer_baillet_Callback(h, eventdata, handles, varargin)

mritool_cb('create');


% --------------------------------------------------------------------
function varargout = menu_mri_alex_Callback(h, eventdata, handles, varargin)

mri_read_tool;

% --------------------------------------------------------------------
function varargout = menu_results_visualization_Callback(h, eventdata, handles, varargin)

results_files = bst_static_taskbar('GET','RESULTS');


if 0 % old AOS code
   fig = results_visualization;
   fighandles = guihandles(fig);
   for i = 1:length(results_files),
      results_visualization('loadparametric_Callback',...
         fighandles.loadparametric, [], fighandles, results_files{i});
   end
else
   % new Baillet viewer
   for i = 1:length(results_files),
      bst_mriviewer('LoadSourceMap_Callback','','','',results_files{i})
   end
end


% --------------------------------------------------------------------
function varargout = menu_tesselation_manager_Callback(h, eventdata, handles, varargin)

editfig = subject_editor('create'); % which has tesselation as a subset



% --------------------------------------------------------------------
function varargout = menu_simulate_mri_Callback(h, eventdata, handles, varargin)

simulator_mri;



% --------------------------------------------------------------------
function varargout = menu_simulate_data_Callback(h, eventdata, handles, varargin)

simulator;




% --------------------------------------------------------------------
function varargout = menu_quit_Callback(h, eventdata, handles, varargin)
% quit all of brainstorm, but not matlab

str = {'','You are about to shutdown all BrainStorm Windows!',''}; 
bst_message_window('append',str);

ButtonName = questdlg('Close the BrainStorm Session?','Message Window','Yes','No','No');

switch ButtonName
case 'Yes'
   bst_message_window('close'); % closes windows and removes application data
   set(0,'showhidden','on');
   hobj = get(0,'chil');
   delete(hobj)
   rmappdata(0,'BrainStormTaskbar'); % remove from the command window
   default_brainstorm = fileparts(which('startup')); % where is the Bst Folder
   cd(default_brainstorm); % move there
   disp(' ');
   disp('Type ''startup'' to begin another BrainStorm Session')
otherwise
   bst_message_window({'','Shutdown halted.',''})
end




% ----------------- EDIT MENU ITEMS -----------------------------------
% --------------------------------------------------------------------
function varargout = menu_information_Callback(h, eventdata, handles, varargin)
bst_message_window('Not implemented')



% --------------------------------------------------------------------
function varargout = menu_editor_Callback(h, eventdata, handles, varargin)
bst_message_window('Not implemented')



% ----------------- VIEW MENU ITEMS -----------------------------------

% --------------------------------------------------------------------
function varargout = menu_viewer_Callback(h, eventdata, handles, varargin)

% Make us wait while loading data into viewer
makeuswait('start')

hfigs = findobj(0,'type','figure');
set(hfigs,'pointer','watch') 
dataplot_cb('create')

makeuswait('stop') % that's it.

% ------------------ HEADMODELS ITEMS --------------------------------
% --------------------------------------------------------------------
function varargout = menu_default_headmodel_Callback(h, eventdata, handles, varargin)

% Compute head model(s) of selected study(ies) with default 
%  parameters as described in bst_headmodeler;

% Fetch StudyFile
Users = get_user_directory;
GUIs = bst_win_manager;

set(GUIs.DataManager,'Pointer','Watch')

bst_message_window('wrap',{...
      'Computing head model for study: ',...
      strrep(Users.CurrentData.StudyFile,'.mat',''),...
      'with default parameters',...
   });

OPTIONS.HeadModelFile = 'Default';

bst_headmodeler(Users.CurrentData.StudyFile,OPTIONS);

bst_message_window('wrap',{...
      strrep(Users.CurrentData.StudyFile,'.mat',''),...
      '-> DONE',...
   });

set(GUIs.DataManager,'Pointer','Arrow')





% --------------------------------------------------------------------
function varargout = menu_advanced_headmodels_Callback(h, eventdata, handles, varargin)
Users = get_user_directory; 
headmodeler_gui('LoadStudy',Users.CurrentData.StudyFile)




% ----------------- ANALYZE MENU ITEMS --------------------------------

% --------------------------------------------------------------------
function varargout = menu_MinNorm_Callback(h, eventdata, handles, varargin)




% --------------------------------------------------------------------
function varargout = menu_MinNorm_recursive_Callback(h, eventdata, handles, varargin)




% --------------------------------------------------------------------
function varargout = menu_STmap_Callback(h, eventdata, handles, varargin)




% --------------------------------------------------------------------
function varargout = menu_Tiling_Callback(h, eventdata, handles, varargin)




% --------------------------------------------------------------------
function varargout = menu_LCMV_scan_Callback(h, eventdata, handles, varargin)




% --------------------------------------------------------------------
function varargout = menu_MUSIC_cortical_Callback(h, eventdata, handles, varargin)




% --------------------------------------------------------------------
function varargout = menu_LCMV_Callback(h, eventdata, handles, varargin)




% --------------------------------------------------------------------
function varargout = menu_RAPmusic_Callback(h, eventdata, handles, varargin)
% designed to execute RAP-MUSIC with minimal user interaction

dataplot_cb('create'); % ensure exists
global data
if ~isfield(data.Measures,'F') % call data display
   tmp = bst_static_taskbar('GET','DATA');
   if ~isempty(tmp{1})
      % only the first file for now
      dataplot_cb('loadfile',tmp); %Users.CurrentData.StudyFile
   end
   dataplot_cb('Plot','measures');
end

% now establish the signal subspace
figP = parametric_estimation;
figP_handles = guihandles(figP);
% decompose the data
parametric_estimation('Pushbutton_decompose_Callback',...
   figP_handles.Pushbutton_decompose,[],figP_handles);
% quit using the default rank calculated in parametric_estimation
parametric_estimation('Quit_Callback',...
   figP_handles.Quit,[],figP_handles);

% setup the rest of the parameters
hf = rap_music_parameters; % setup
hf_handles = guihandles(hf);
% load the parameters
rap_music_parameters('load_parameters', hf, ...
   data.Measures.NoiseModelParam.StudySubject,data.Measures.NoiseModelParam);
% set the correlation threshold
set(hf_handles.edit_threshold,'string','0.85'); % desired correlation level
% activate the correlation
rap_music_parameters('edit_threshold_Callback',hf_handles.edit_threshold,[],hf_handles);
% set the regularization
set(hf_handles.PopupReg,'val',4); % 4 is tikhonov reg
% activate the popup
rap_music_parameters('PopupReg_Callback',hf_handles.PopupReg,[],hf_handles);

% execute!
rap_music_parameters('pushbutton_execute_Callback',hf_handles.pushbutton_execute,...
   [],hf_handles);



% --------------------------------------------------------------------
function varargout = menu_Rmusic_Callback(h, eventdata, handles, varargin)




% --------------------------------------------------------------------
function varargout = menu_LeastSquares_Callback(h, eventdata, handles, varargin)





% ----------------- WINDOW MENU ITEMS ---------------------------------
% --------------------------------------------------------------------
function varargout = menu_layout_Callback(h, eventdata, handles, varargin)

% call the layout manager

layout_manager



% --------------------------------------------------------------------
function varargout = menu_snap_Callback(h, eventdata, handles, varargin)

% quick call to snap the tiles into place, rather than call the full layout manager
% align the tiles into their correct positions

bst_layout('align');



% --------------------------------------------------------------------
function varargout = MRIViewer_Callback(h, eventdata, handles, varargin)
% The Baillet call

bst_mriviewer


% ----------------- MESSAGE TOGGLE ITEMS ------------------------------
% --------------------------------------------------------------------
function varargout = menu_message_Callback(h, eventdata, handles, varargin)

% enlarge the message window for easier viewing
% Make it the same size as a single field tile i.e. 1,1,1
% If already enlarged, return to normal size

% find the BrainStorm Message Window
fig = getappdata(0,'BrainStormMessageWindow');

L = getpref('BrainStorm','Layout'); % the current settings

pos = get(fig, 'Position'); % where is the message window now

% simply look at the current height of the message window.
% If it is closer to the enlarged height, then toggle it small

origHeight = L.winpos(1,4); % the original height
enlargedHeight = L.tilepos{1,1}(4); % the enlarged height

heightDiff = abs([origHeight enlargedHeight] - pos(4)); % height differences
[ignore,heightNow] = min(heightDiff); % which is the smaller difference

switch heightNow
case 1
   % the heightNow is original, so enlarge it
   % put in the lower left of the BST window, with height of one tile
   set(fig, 'Position', [L.ScreenPosition(1:2) L.tilepos{1,1}(3:4)]);
   
case 2
   % the heightNow is enlarged, so snap it back to where it should be
   set(fig,'Position',L.winpos(1,:));
end

figure(fig); % bring to the front



% ----------------- HELP MENU ITEMS -----------------------------------
% --------------------------------------------------------------------
function varargout = menu_help_contents_Callback(h, eventdata, handles, varargin)

fig = handles.static_taskbar; % handy shortcut
set(fig,'pointer','watch');

bst_message_window({'','Loading Contents into help windows. Wait . . .'});

% launch the matlab help pointed to our contents.m area
brainstormHomeDirectory = fileparts(which('startup.m'));
helpwin([brainstormHomeDirectory filesep 'toolbox'])

bst_message_window({'See Matlab help window.'});
set(fig,'pointer','arrow');




% --------------------------------------------------------------------
function menu_help_whatsnew_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

readme % display the readme.m file in the Toolbox


% --------------------------------------------------------------------
function varargout = menu_help_online_Callback(h, eventdata, handles, varargin)

% activate the web pages GUI
web_pages; 




% --------------------------------------------------------------------
function varargout = menu_help_html_Callback(h, eventdata, handles, varargin)

brainstormHomeDirectory = getpref('BrainStorm','brainstormHomeDir');

web(fullfile(brainstormHomeDirectory,'html','5Toolbox','index.html'));




% --------------------------------------------------------------------
function varargout = menu_help_newuser_Callback(h, eventdata, handles, varargin)

% show brief help in the message window
% Would like to show an html document

brainstormHomeDirectory = getpref('BrainStorm','brainstormHomeDir');

bst_message_window({'','BrainStorm Toolbox Help'});

msg_str = ['The Data Manager selects the trial from the database. ',...
      'Visualization allows spatial and temporal views of the data. ',...
      'Estimation uses parametric or imaging approaches to estimate a ',...
      'source solution. Visualization also allows views of the estimation ',...
      'results.'];
bst_message_window('wrap',msg_str);

web(fullfile(brainstormHomeDirectory,'Documents','New_User_Quick_Guide.htm'));


% --------------------------------------------------------------------
function menu_help_montreal_Callback(hObject, eventdata, handles)
% Bring up the document showing how to create and process the Montreal Phantom
% data

brainstormHomeDirectory = getpref('BrainStorm','brainstormHomeDir');

web(fullfile(brainstormHomeDirectory,'Documents','Montreal_Digital_Phantom_Simulation.htm'));


% --------------------------------------------------------------------
function varargout = menu_help_tutorial_Callback(h, eventdata, handles, varargin)

if 0
   brainstormHomeDirectory = getpref('BrainStorm','brainstormHomeDir');
   
   web(fullfile(brainstormHomeDirectory,'Documents','A_Tutorial_to_BrainStorm.htm'));
end
web('http://neuroimage.usc.edu/brainstorm/Tutorial.html','-browser')




% --------------------------------------------------------------------
function help_editing_bst_Callback(hObject, eventdata, handles)
% hObject    handle to help_editing_bst (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

help_editing_brainstorm;




% --------------------------------------------------------------------
function menu_help_forum_Callback(hObject, eventdata, handles)
% hObject    handle to menu_help_forum (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

web('http://neuroimage.usc.edu/brainstormforum','-browser');


% --------------------------------------------------------------------
function AboutBrainStorm_Callback(hObject, eventdata, handles)
% hObject    handle to AboutBrainStorm (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

bst_splashscreen;



% --------------------------------------------------------------------
function help_DatabaseStructure_Callback(hObject, eventdata, handles)
% hObject    handle to DatabaseStructure (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

help_database_list



% --------------------------------------------------------------------
function help_formatRAW_Callback(hObject, eventdata, handles)
% hObject    handle to formatRAW (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

help_data_raw


% ------------------  END MENU ACTION SECTION -----------------------

% ----------------- OLD BUTTONS NOW GONE -------------------
% keep this section just for bug testing of old button routines

% --------------------------------------------------------------------
function varargout = pushbutton_data_Callback(h, eventdata, handles, varargin)
% activate the data manager

data_manager



% --------------------------------------------------------------------
function varargout = pushbutton_quit_Callback(h, eventdata, handles, varargin)
% quit all of brainstorm, but not matlab

str = {'','You are about to shutdown all BrainStorm Windows!',''}; 
bst_message_window('append',str);

ButtonName = questdlg('Close the BrainStorm Session?','Message Window','Yes','No','No');

switch ButtonName
case 'Yes'
   bst_message_window('close'); % closes windows and removes application data
   set(0,'showhidden','on');
   hobj = get(0,'chil');
   delete(hobj)
   rmappdata(0,'BrainStormTaskbar'); % remove from the command window
   default_brainstorm = fileparts(which('startup')); % where is the Bst Folder
   cd(default_brainstorm); % move there
   disp(' ');
   disp('Type ''startup'' to begin another BrainStorm Session')
otherwise
   bst_message_window({'','Shutdown halted.',''})
end




% --------------------------------------------------------------------
function varargout = pushbutton_snap_Callback(h, eventdata, handles, varargin)
% quick call to snap the tiles into place, rather than call the full layout manager
% align the tiles into their correct positions

bst_layout('align');



% --------------------------------------------------------------------
function varargout = pushbutton_layout_Callback(h, eventdata, handles, varargin)
% call the layout manager

layout_manager



% --------------------------------------------------------------------
function varargout = pushbutton_view_Callback(h, eventdata, handles, varargin)
% call the dynamic view toolbar

%dummy_dynamic_viewer
dataplot_cb('create')



% --------------------------------------------------------------------
function varargout = pushbutton_info_Callback(h, eventdata, handles, varargin)
% display a tile of info on the data and results listed



% --------------------------------------------------------------------
function varargout = pushbutton_help_Callback(h, eventdata, handles, varargin)
% launch the help manager

help_manager



% --------------------------------------------------------------------
function varargout = pushbutton_editor_Callback(h, eventdata, handles, varargin)
% launch the dynamic toolbar to filter and edit the data



% --------------------------------------------------------------------
function varargout = pushbutton_msgs_Callback(h, eventdata, handles, varargin)
% enlarge the message window for easier viewing
% Make it the same size as a single field tile i.e. 1,1,1
% If already enlarged, return to normal size

% find the BrainStorm Message Window
fig = getappdata(0,'BrainStormMessageWindow');

L = getpref('BrainStorm','Layout'); % the current settings

pos = get(fig, 'Position'); % where is the message window now

% simply look at the current height of the message window.
% If it is closer to the enlarged height, then toggle it small

origHeight = L.winpos(1,4); % the original height
enlargedHeight = L.tilepos{1,1}(4); % the enlarged height

heightDiff = abs([origHeight enlargedHeight] - pos(4)); % height differences
[ignore,heightNow] = min(heightDiff); % which is the smaller difference

switch heightNow
case 1
   % the heightNow is original, so enlarge it
   % put in the lower left of the BST window, with height of one tile
   set(fig, 'Position', [L.ScreenPosition(1:2) L.tilepos{1,1}(3:4)]);
   
case 2
   % the heightNow is enlarged, so snap it back to where it should be
   set(fig,'Position',L.winpos(1,:));
end

figure(fig); % bring to the front

% --------- End Old Pushbuttons Section ---------------------------------

