%BSTSCRIPT_FORWARDINVERSE_BASIC - Basic Head Modelling and Source Imaging BrainStorm Script
%
% This script is intended to be used without the BrainStorm GUI's. 
% A basic spherical headmodel is computed based on the individual scalp envelope.
% Sources are distributed over the cortical surface or white/gray matter interface.
% A minimum-norm estimate of the distribution of source amplitudes is also computed.
% Data and Results are saved in BrainStorm's format (i.e. in Matlab archive .mat files). 
%
% For advanced options to headmodelling and source imaging, please refer to more specific
% scripts such as BST_HEADMODELER.M and BST_SOURCEIMAGING.M in the <BrainStorm>\Toolbox folder.

%<autobegin> ---------------------- 14-Jun-2004 17:09:50 -----------------------
% --------- Automatically Generated Comments Block Using AUTO_COMMENTS ---------
%
% CATEGORY: Inverse Modeling
%
% Alphabetical list of external functions (non-Matlab):
%   toolbox\bst_headmodeler.m
%   toolbox\bst_sourceimaging.m
%
% Group : Preference data and their calls in this file:
%   'BrainStorm' : 'UserDataBase'
%   'BrainStorm' : 'iUserDataBase'
%   
%   setpref('BrainStorm','UserDataBase',UserDB);
%   setpref('BrainStorm','iUserDataBase',1);
%   
%
% At Check-in: $Author: Mosher $  $Revision: 8 $  $Date: 6/14/04 3:37p $
%
% This software is part of BrainStorm Toolbox Version 2.0 (Alpha) 14-Jun-2004
% 
% Principal Investigators and Developers:
% ** Richard M. Leahy, PhD, Signal & Image Processing Institute,
%    University of Southern California, Los Angeles, CA
% ** John C. Mosher, PhD, Biophysics Group,
%    Los Alamos National Laboratory, Los Alamos, NM
% ** Sylvain Baillet, PhD, Cognitive Neuroscience & Brain Imaging Laboratory,
%    CNRS, Hopital de la Salpetriere, Paris, France
% 
% See BrainStorm website at http://neuroimage.usc.edu for further information.
% 
% Copyright (c) 2004 BrainStorm by the University of Southern California
% This software distributed  under the terms of the GNU General Public License
% as published by the Free Software Foundation. Further details on the GPL
% license can be found at http://www.gnu.org/copyleft/gpl.html .
% 
% FOR RESEARCH PURPOSES ONLY. THE SOFTWARE IS PROVIDED "AS IS," AND THE
% UNIVERSITY OF SOUTHERN CALIFORNIA AND ITS COLLABORATORS DO NOT MAKE ANY
% WARRANTY, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO WARRANTIES OF
% MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, NOR DO THEY ASSUME ANY
% LIABILITY OR RESPONSIBILITY FOR THE USE OF THIS SOFTWARE.
%<autoend> ------------------------ 14-Jun-2004 17:09:50 -----------------------


% /---Script Author--------------------------------------\
% |                                                      |
% | *** Sylvain Baillet, Ph.D.                           |
% | Cognitive Neuroscience & Brain Imaging Laboratory    |
% | CNRS UPR640 - LENA                                   | 
% | Hopital de la Salpetriere, Paris, France             |
% | sylvain.baillet@chups.jussieu.fr                     |
% |                                                      |
% \------------------------------------------------------/

% Script History----------------------------------------------------
% SB  09-Mar-2004  : Creation
% ------------------------------------------------------------------


% Set-up paths -----------------------------------------------------

% 1) Add BrainStorm path 
addpath('e:\brainstorm2001\toolbox')  % EDIT

% 2) Where is your data ? Create a database entry
% a) Anatomy (i.e. so-called SUBJECTS folder)
UserDB(1).STUDIES = 'I:\Data\Studies'; % EDIT
% b) Functional (e.g. MEG/EEG, so-called STUDIES folder)
UserDB(1).SUBJECTS = 'I:\Data\Subjects'; % EDIT
UserDB(1).FILELIST = '';

% Store this information in Matlab's preferences
setpref('BrainStorm','UserDataBase',UserDB);
setpref('BrainStorm','iUserDataBase',1);
    
   
   
   
% Forward modelling -----------------------------------------------

% Store arguments to be passed to main script in fwOPTIONS structure
StudyFile = 'I:\Data\Studies\NDiaye\S10\aud\aud-avTr17_brainstormstudy.mat'; % path to BrainStorm studyfile (i.e. database entry) % EDIT
fwOPTIONS.Method = {'meg_sphere'}; % MEG spherical head model

% Use scalp tessellation to fit sphere to head
fwOPTIONS.Scalp.FileName = 'I:\Data\Subjects\NDiaye\S10\S10_tess.mat';  % EDIT
fwOPTIONS.Scalp.iGrid = 1; % Location of head envelope in .FileName tessellation cell arrays % EDIT % 

% Use cortex or white/gray interface to distribute sphere to distribute source models
fwOPTIONS.Cortex.FileName = 'I:\Data\Subjects\NDiaye\S10\S10_tess.mat';  % EDIT
fwOPTIONS.Cortex.iGrid = 4; % WARNING : for all subjects in this study but S7 where .iGrid = 10 % EDIT % 

% Type HELP BST_HEADMODELER.M for further info on the following arguments 
fwOPTIONS.VolumeSourceGrid = 0;
fwOPTIONS.HeadModelFile = 'default';
fwOPTIONS.ImageGridFile = 'default';
fwOPTIONS.Verbose = 1;


% Call main function
[OPTIONS.HeadModelFile, tmp] = bst_headmodeler(StudyFile,fwOPTIONS);
% -> Done with Forward modelling 


% Inverse modelling ------------------------------------------------------

% Store arguments to be passed to main script in invOPTIONS structure
invOPTIONS.DataFile = {'I:\Data\Studies\NDiaye\S10\aud\aud-avTr17_data_trial_1.mat'}; % EDIT % Store MEG-EEG datafile(s) to be processed in a cell array of strings
invOPTIONS.TimeSegment = [-0.1000 0.2000]; % Time segment to be processed, in seconds
invOPTIONS.DataTypes = 1; % Process MEG (1); EEG (2) or Fusion of MEG with EEG (3)
invOPTIONS.HeadModelFile = OPTIONS.HeadModelFile;
invOPTIONS.Method = 'Minimum-Norm Imaging';
invOPTIONS.Verbose = 1;

% Call main function

[Results, tmp] = bst_sourceimaging(invOPTIONS);
% -> Done with inverse estimation






