function [x,y,xi,yi,sensors,tetep] = carto_sensors(Rcoils,v);
%CARTO_SENSORS - (Rcoils,v);
% function [x,y,xi,yi,sensors,tetep] = carto_sensors(Rcoils,v);
% Mapping of data topography on the sensors head shape 
% Rcoils - a Nx3 matrix containing the locations of the sensors
% v - a Nx1 vector data vector for mapping
%
% /---Script Author--------------------------------------\
% |                                                      |
% | *** Sylvain Baillet, Ph.D.                           |
% | Cognitive Neuroscience & Brain Imaging Laboratory    |
% | CNRS UPR640 - LENA                                   | 
% | Hopital de la Salpetriere, Paris, France             |
% | sylvain.baillet@chups.jussieu.fr                     |
% \------------------------------------------------------/
%  
% Date of creation: January 2001
% Date of modification: July 2001                  
%---------------------------------------------------------------------------------------------------------------------------

%<autobegin> ---------------------- 26-May-2004 11:29:52 -----------------------
% --------- Automatically Generated Comments Block Using AUTO_COMMENTS ---------
%
% CATEGORY: Forward Modeling
%
% At Check-in: $Author: Mosher $  $Revision: 12 $  $Date: 5/26/04 9:59a $
%
% This software is part of BrainStorm Toolbox Version 2.0 (Alpha) 24-May-2004
% 
% Principal Investigators and Developers:
% ** Richard M. Leahy, PhD, Signal & Image Processing Institute,
%    University of Southern California, Los Angeles, CA
% ** John C. Mosher, PhD, Biophysics Group,
%    Los Alamos National Laboratory, Los Alamos, NM
% ** Sylvain Baillet, PhD, Cognitive Neuroscience & Brain Imaging Laboratory,
%    CNRS, Hopital de la Salpetriere, Paris, France
% 
% See BrainStorm website at http://neuroimage.usc.edu for further information.
% 
% Copyright (c) 2004 BrainStorm by the University of Southern California
% This software distributed  under the terms of the GNU General Public License
% as published by the Free Software Foundation. Further details on the GPL
% license can be found at http://www.gnu.org/copyleft/gpl.html .
% 
% FOR RESEARCH PURPOSES ONLY. THE SOFTWARE IS PROVIDED "AS IS," AND THE
% UNIVERSITY OF SOUTHERN CALIFORNIA AND ITS COLLABORATORS DO NOT MAKE ANY
% WARRANTY, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO WARRANTIES OF
% MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, NOR DO THEY ASSUME ANY
% LIABILITY OR RESPONSIBILITY FOR THE USE OF THIS SOFTWARE.
%<autoend> ------------------------ 26-May-2004 11:29:52 -----------------------


N = 100; % Grid finesse for color interpolation

x = Rcoils(:,1);
y = Rcoils(:,2);
z = Rcoils(:,3);

[xi,yi] = meshgrid(linspace(min(x),max(x),N),linspace(min(y),max(y),N));
zi = griddata(x,y,z,xi,yi);
tri = delaunay(xi,yi);
Vp = griddata(x,y,v,xi,yi,'invdist');

XT = 1.05*[x y z];

%%% VISU DES CAPTEURS
for i = 1:length(v)
   sensors=plot3(XT(i,1),XT(i,2),XT(i,3),'o');
   set(sensors,'markerfacecolor',[.2 1 .2],'markersize',3)
   hold on  
end

maxx = max(max(Vp));
minn = min(min(Vp));

MAX = max([abs(minn),maxx]);

%%%%%%%%%%%%%%%%%%%%%%%%

tetep  = trisurf(tri,xi,yi,zi,Vp);
set(tetep,'facecolor','interp');
set(tetep,'edgecolor','none');

caxis([-max(abs(v)),max(abs(v))])


axis equal
axis off
view(0,90)




if isempty(findobj(gcf,'Tag','colormap'))
   C = [flipud(fliplr(hot(128)));hot(128)];
   if 0
      n = size(C,1);
      h = axes;
      set(h,'units','normal','position',[1/4 1/25 1/2 1/20],'ycolor','k','Tag','colormap');
      h1 = pcolor(linspace(-maxx,maxx,n),0:1,[1:n;1:n]);	
      set(h,'fontsize',7,'ycolor','k','Yticklabel',[]);
      set(h1,'Tag','colormap')
   end
   
   colormap(C)
   shading interp		
   hold off
end



