function [PChanLocs,hsens,hsph,CData,Wmat] = carto_sph(sensloc,v);
%CARTO_SPH - (sensloc,v,center)
% function [PChanLocs,hsens,hsph,CData,Wmat] = carto_sph(sensloc,v);
% function [x,y,z,xs,ys,hsens,hsph] = carto_sph(sensloc,v,center);
% Data Mapping on a sphere
% sensloc: a Nx3 matrix containing the hsens locations
% v - a Nx1 vector data vector for mapping 
% center - a 1x3 vector indicating the location of the head center (default: [0 0 0])

%<autobegin> ---------------------- 26-May-2004 11:29:52 -----------------------
% --------- Automatically Generated Comments Block Using AUTO_COMMENTS ---------
%
% CATEGORY: Utility - Numeric
%
% Alphabetical list of external functions (non-Matlab):
%   toolbox\norlig.m
%   toolbox\shepards.m
%
% At Check-in: $Author: Mosher $  $Revision: 14 $  $Date: 5/26/04 9:59a $
%
% This software is part of BrainStorm Toolbox Version 2.0 (Alpha) 24-May-2004
% 
% Principal Investigators and Developers:
% ** Richard M. Leahy, PhD, Signal & Image Processing Institute,
%    University of Southern California, Los Angeles, CA
% ** John C. Mosher, PhD, Biophysics Group,
%    Los Alamos National Laboratory, Los Alamos, NM
% ** Sylvain Baillet, PhD, Cognitive Neuroscience & Brain Imaging Laboratory,
%    CNRS, Hopital de la Salpetriere, Paris, France
% 
% See BrainStorm website at http://neuroimage.usc.edu for further information.
% 
% Copyright (c) 2004 BrainStorm by the University of Southern California
% This software distributed  under the terms of the GNU General Public License
% as published by the Free Software Foundation. Further details on the GPL
% license can be found at http://www.gnu.org/copyleft/gpl.html .
% 
% FOR RESEARCH PURPOSES ONLY. THE SOFTWARE IS PROVIDED "AS IS," AND THE
% UNIVERSITY OF SOUTHERN CALIFORNIA AND ITS COLLABORATORS DO NOT MAKE ANY
% WARRANTY, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO WARRANTIES OF
% MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, NOR DO THEY ASSUME ANY
% LIABILITY OR RESPONSIBILITY FOR THE USE OF THIS SOFTWARE.
%<autoend> ------------------------ 26-May-2004 11:29:52 -----------------------


% PChanlocs - array of channel locations projected on best-fitting sphere
% hsens - a vector of handles to pointing at the text labels of the hsens names
% hsph - handle of the patch corresponding to the hemispherical head shape 
% CData - array of interpolated data over the sphere vertices 
%
% /---Script Author--------------------------------------\
% |                                                      |
% | *** Sylvain Baillet, Ph.D.                           |
% | Cognitive Neuroscience & Brain Imaging Laboratory    |
% | CNRS UPR640 - LENA                                   | 
% | Hopital de la Salpetriere, Paris, France             |
% | sylvain.baillet@chups.jussieu.fr                     |
% \------------------------------------------------------/
%  
% Date of creation: January 1999
% Date of modification: July 2001                  
%---------------------------------------------------------------------------------------------------------------------------

% Compute best-fitting sphere to sensors
nmes = size(sensloc,1); 
mass = mean(sensloc); % center of mass of the scalp vertex locations   
R0 = mean(norlig(sensloc - ones(nmes,1)*mass)); % Average distance between the center of mass and the scalp points
vec0 = [mass,R0];

[minn,brp] = fminsearch('dist_sph',vec0,[],sensloc);
center = minn(1:end-1); 
R = minn(end); clear minn brp

[teta,phi,rr] = cart2sph(sensloc(:,1)-center(1),sensloc(:,2)-center(2),sensloc(:,3)-center(3));
angles = [teta,phi];


% Visualisation des electrodes.
phimin = min(phi);
phimax = max(phi);
tetamin = min(teta);
tetamax = max(teta);

% Project sensors on sphere 
[x y z] = sph2cart(teta,phi,R*ones(size(phi)));
[xt yt zt] = sph2cart(teta,phi,R*1.05*ones(size(phi)));

N = 20;

phi = (phimin:(pi/2 - phimin)/N:pi/2)'*ones(1,N+1);
teta= (0: 2*pi/N : 2*pi )'*ones(1,N+1);

xs = cos(teta').*cos(phi);
ys = sin(teta').*cos(phi);
zs = sin(phi);

PChanLocs(:,1) = x+center(1); PChanLocs(:,2) = y+center(2); PChanLocs(:,3) = z+center(3);
xs = xs+center(1); ys = ys+center(2); zs = zs+center(3);
xt = xt+center(1); yt = yt+center(2); zt = zt+center(3);

%%% VISU DES CAPTEURS

xso = xs; yso = ys; zso = zs;

xs = xs(:);
ys = ys(:);
zs = zs(:);


[CData, Wmat] = shepards([xs,ys,zs],PChanLocs,v,round(size(PChanLocs,1)/4)+1);
CData = reshape(CData,sqrt(length(CData)),sqrt(length(CData)));
%CData = griddata3(PChanLocs(:,1),PChanLocs(:,2),PChanLocs(:,3),v,xs,ys,zs,'nearest');


% ----------------------------------------

hsens = [];
% hsens = scatter3(xt,yt,zt,'o');
% set(hsens,'markerfacecolor',[.2 1 .2],'markersize',3,'Tag','hsens');
% hold on

hsph = surf(xso,yso,zso,...
    CData,'Visible','off','facecolor','interp','erasemode','normal','edgecolor','none');


% maxx=  max(abs(CData(:)));
% caxis([-maxx,maxx])
% 
% axis equal
% axis off
% view(0,90)

%%%%% Colormap


% if isempty(findobj(gcf,'Tag','colormap'))
%    C = [flipud(fliplr(hot(128)));hot(128)];
% end
% 
% colormap(C)

