function CrossMat = cross_mat(A);
%CROSS_MAT - Sparse cross product matrix good for matrix equivalent operation
% function CrossMat = cross_mat(A);
% A comprises three dimensional vectors (row or column, preferably column).
% Result is sparse block diagonal matrix, suitable for cross products.
%
% Let B be the same size as A and both oriented as 3 x M.
%  tmp = B(:); 
%  cross_product = reshape(full(CrossMat*tmp),3,M);
% Each column of cross_product corresponds to the cross product of the
% corresponding columns in A and B.

%<autobegin> ---------------------- 26-May-2004 11:29:55 -----------------------
% --------- Automatically Generated Comments Block Using AUTO_COMMENTS ---------
%
% CATEGORY: Utility - Numeric
%
% Alphabetical list of external functions (non-Matlab):
%   toolbox\blk_diag.m
%   toolbox\mby3check.m
%
% At Check-in: $Author: Mosher $  $Revision: 13 $  $Date: 5/26/04 9:59a $
%
% This software is part of BrainStorm Toolbox Version 2.0 (Alpha) 24-May-2004
% 
% Principal Investigators and Developers:
% ** Richard M. Leahy, PhD, Signal & Image Processing Institute,
%    University of Southern California, Los Angeles, CA
% ** John C. Mosher, PhD, Biophysics Group,
%    Los Alamos National Laboratory, Los Alamos, NM
% ** Sylvain Baillet, PhD, Cognitive Neuroscience & Brain Imaging Laboratory,
%    CNRS, Hopital de la Salpetriere, Paris, France
% 
% See BrainStorm website at http://neuroimage.usc.edu for further information.
% 
% Copyright (c) 2004 BrainStorm by the University of Southern California
% This software distributed  under the terms of the GNU General Public License
% as published by the Free Software Foundation. Further details on the GPL
% license can be found at http://www.gnu.org/copyleft/gpl.html .
% 
% FOR RESEARCH PURPOSES ONLY. THE SOFTWARE IS PROVIDED "AS IS," AND THE
% UNIVERSITY OF SOUTHERN CALIFORNIA AND ITS COLLABORATORS DO NOT MAKE ANY
% WARRANTY, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO WARRANTIES OF
% MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, NOR DO THEY ASSUME ANY
% LIABILITY OR RESPONSIBILITY FOR THE USE OF THIS SOFTWARE.
%<autoend> ------------------------ 26-May-2004 11:29:55 -----------------------

% ----------------------------- Script History ---------------------------------
% September 6, 1995 author
% JCM 19-May-2004  Comments cleaning
% ----------------------------- Script History ---------------------------------

A = mby3check(A);		% check and convert to 3 by M

mA = size(A,2); 		% how many vecs?

CrossMat = zeros(3,mA*3);	% three by three per vector
CrossMat(1,2:3:(mA*3)) = -A(3,:); % the z-component
CrossMat(1,3:3:(mA*3)) = A(2,:); % the y-component
CrossMat(2,3:3:(mA*3)) = -A(1,:); % the x-component
CrossMat = blk_diag(CrossMat,3); % make block diagonal
CrossMat = CrossMat - CrossMat'; % fill in anti-symmetric part

return
