function [P,dP1] = dlegpoly(N,x)
%DLEGPOLY - Evaluate the first N Legendre polynomials
% function [P,dP1] = dlegpoly(N,x)
%*****************************************************************************
%  function [P,dP1,dP2] = dlegpoly(N,x,flag)
%  This function evaluates the first N Legendre polynomials,the first and
%  second derivatives at the vector x.
%
%  Input:
%    N       (scalar)       last polynomial order to evaluate
%    x       (m x 1)        input vector of values to eval. the polys at
%    flag    (scalar)       if flag=1, compute dP2
%
%  Outputs:
%    P       (N x m)      = [P1(x1) P1(x2)    ...    P1(xm);
%                            P2(x1) P2(x2)    ...    P2(xm);
%                             .
%                             .
%                            PN(x1) PN(x2)    ...    PN(xm)]
% 
%    dP1      (N x m)      =  derivative w.r.t. x of P
%*****************************************************************************

%<autobegin> ---------------------- 26-May-2004 11:30:11 -----------------------
% --------- Automatically Generated Comments Block Using AUTO_COMMENTS ---------
%
% CATEGORY: Utility - Numeric
%
% At Check-in: $Author: Mosher $  $Revision: 12 $  $Date: 5/26/04 9:59a $
%
% This software is part of BrainStorm Toolbox Version 2.0 (Alpha) 24-May-2004
% 
% Principal Investigators and Developers:
% ** Richard M. Leahy, PhD, Signal & Image Processing Institute,
%    University of Southern California, Los Angeles, CA
% ** John C. Mosher, PhD, Biophysics Group,
%    Los Alamos National Laboratory, Los Alamos, NM
% ** Sylvain Baillet, PhD, Cognitive Neuroscience & Brain Imaging Laboratory,
%    CNRS, Hopital de la Salpetriere, Paris, France
% 
% See BrainStorm website at http://neuroimage.usc.edu for further information.
% 
% Copyright (c) 2004 BrainStorm by the University of Southern California
% This software distributed  under the terms of the GNU General Public License
% as published by the Free Software Foundation. Further details on the GPL
% license can be found at http://www.gnu.org/copyleft/gpl.html .
% 
% FOR RESEARCH PURPOSES ONLY. THE SOFTWARE IS PROVIDED "AS IS," AND THE
% UNIVERSITY OF SOUTHERN CALIFORNIA AND ITS COLLABORATORS DO NOT MAKE ANY
% WARRANTY, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO WARRANTIES OF
% MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, NOR DO THEY ASSUME ANY
% LIABILITY OR RESPONSIBILITY FOR THE USE OF THIS SOFTWARE.
%<autoend> ------------------------ 26-May-2004 11:30:11 -----------------------


if size(x,1)~=1, x=x'; end      % make it a row vector

m=size(x,2);  % # evaluation points

P=zeros(N,m);     % preallocate
dP1=zeros(N,m);

P(1,:)=x;              % initials of P
P(2,:)=1.5*x.^2-0.5;  
dP1(1,:)=ones(1,m);    % initial derivative

% recursively compute P,dP1
for n=3:N,
  P(n,:)=( (2*n-1).*x.*P(n-1,:)-(n-1)*P(n-2,:) )/n;
end

for n=2:N
  dP1(n,:)=x.*dP1(n-1,:)+n.*P(n-1,:);     
end
