function v_embedding=embedding(v,connectivity_mat,jmax,nbmax)
%EMBEDDING - computing the approximate embedding surface
% function v_embedding=embedding(v,connectivity_mat,jmax,nbmax)
%
%  computing the approximative embedding surface
%
%  inputs : v : vertices, connectivity_mat : result of vertices_connectivity, but in a matrix
%           jmax and nb max : number of iterations for embedding surface computation
%  output : v_embedding : approximative embedding surface
% 

%<autobegin> ---------------------- 26-May-2004 11:30:14 -----------------------
% --------- Automatically Generated Comments Block Using AUTO_COMMENTS ---------
%
% CATEGORY: Utility - Numeric
%
% At Check-in: $Author: Mosher $  $Revision: 14 $  $Date: 5/26/04 9:59a $
%
% This software is part of BrainStorm Toolbox Version 2.0 (Alpha) 24-May-2004
% 
% Principal Investigators and Developers:
% ** Richard M. Leahy, PhD, Signal & Image Processing Institute,
%    University of Southern California, Los Angeles, CA
% ** John C. Mosher, PhD, Biophysics Group,
%    Los Alamos National Laboratory, Los Alamos, NM
% ** Sylvain Baillet, PhD, Cognitive Neuroscience & Brain Imaging Laboratory,
%    CNRS, Hopital de la Salpetriere, Paris, France
% 
% See BrainStorm website at http://neuroimage.usc.edu for further information.
% 
% Copyright (c) 2004 BrainStorm by the University of Southern California
% This software distributed  under the terms of the GNU General Public License
% as published by the Free Software Foundation. Further details on the GPL
% license can be found at http://www.gnu.org/copyleft/gpl.html .
% 
% FOR RESEARCH PURPOSES ONLY. THE SOFTWARE IS PROVIDED "AS IS," AND THE
% UNIVERSITY OF SOUTHERN CALIFORNIA AND ITS COLLABORATORS DO NOT MAKE ANY
% WARRANTY, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO WARRANTIES OF
% MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, NOR DO THEY ASSUME ANY
% LIABILITY OR RESPONSIBILITY FOR THE USE OF THIS SOFTWARE.
%<autoend> ------------------------ 26-May-2004 11:30:14 -----------------------

% History ---------------------------------------
% JCM 08-Sep-2003  commenting
% -----------------------------------------------

% "blowing"of the brain
clear vsph;
vsph=[v(:,1)/max(v(:,1)) v(:,2)/max(v(:,2)) v(:,3)/max(v(:,3))];

% computing the approximative embedding surface
clear vsph_embedding;
vsph_embedding(:,:)=vsph;
stop_it=zeros(size(vsph_embedding,1),1);
clear I_nn;
I_nn=find(vsph(:,1)~=0 & vsph(:,2)~=0 & vsph(:,3)~=0);
for j=1:jmax
	maxim=zeros(size(v,1),1);
	vsph_embedding_temp=vsph_embedding;
	clear I_z;
	I_z=find(stop_it(I_nn)==0);
	d=sqrt(sum(vsph_embedding.^2,2));
	if ~isempty(I_z)
		for i=1:size(I_z,1)
			maxim(I_nn(I_z(i)))=max(max(d(connectivity_mat(I_nn(I_z(i)),2:connectivity_mat(I_nn(I_z(i)),1)+1))));
		end
		vsph_embedding(I_nn(I_z),:)=((maxim(I_nn(I_z))./d(I_nn(I_z)))*[1 1 1]).*vsph_embedding_temp(I_nn(I_z),:);
		clear vsph_embedding_dif;
		vsph_embedding_dif=abs(vsph_embedding(I_nn(I_z),:)-vsph_embedding_temp(I_nn(I_z),:));
		clear I_dif;
		I_dif=find(vsph_embedding_dif(:,1)==0 & vsph_embedding_dif(:,2)==0 & vsph_embedding_dif(:,3)==0);
		if ~isempty(I_dif)
			stop_it(I_nn(I_z(I_dif)))=1;
		end
	end
end
clear stop_it;
clear vsph_embedding_dif;
clear I_dif;
clear vsph_embedding_temp;
clear d;

% smoothing of the surface
for j=1:nbmax
	clear mean_d;
	mean_d=zeros(size(v,1),1);
   vsph_embedding_temp=vsph_embedding;
   d=sqrt(sum(vsph_embedding.^2,2));
   for i=1:size(I_nn,1)
      mean_d(I_nn(i))=sum(sum(d(connectivity_mat(I_nn(i),2:connectivity_mat(I_nn(i),1)+1))))/connectivity_mat(I_nn(i),1);
   end
   vsph_embedding(I_nn,:)=((mean_d(I_nn)./d(I_nn))*[1 1 1]).*vsph_embedding_temp(I_nn,:);
end

% "unblowing" of the surface
clear v_embedding;
v_embedding=[vsph_embedding(:,1)*max(v(:,1)) vsph_embedding(:,2)*max(v(:,2)) vsph_embedding(:,3)*max(v(:,3))];
clear vsph_embedding;
