function C = genpath2cell(P);;
%GENPATH2CELL - convert path or generated path string into cell array
% function C = genpath2cell(P);;
% Input
%  P is from "path" command, list of folders separated by pathsep
% Output
%  C is a cell array, one element per folder

%<autobegin> ---------------------- 26-May-2004 11:30:19 -----------------------
% --------- Automatically Generated Comments Block Using AUTO_COMMENTS ---------
%
% CATEGORY: Utility - General
%
% At Check-in: $Author: Mosher $  $Revision: 11 $  $Date: 5/26/04 9:59a $
%
% This software is part of BrainStorm Toolbox Version 2.0 (Alpha) 24-May-2004
% 
% Principal Investigators and Developers:
% ** Richard M. Leahy, PhD, Signal & Image Processing Institute,
%    University of Southern California, Los Angeles, CA
% ** John C. Mosher, PhD, Biophysics Group,
%    Los Alamos National Laboratory, Los Alamos, NM
% ** Sylvain Baillet, PhD, Cognitive Neuroscience & Brain Imaging Laboratory,
%    CNRS, Hopital de la Salpetriere, Paris, France
% 
% See BrainStorm website at http://neuroimage.usc.edu for further information.
% 
% Copyright (c) 2004 BrainStorm by the University of Southern California
% This software distributed  under the terms of the GNU General Public License
% as published by the Free Software Foundation. Further details on the GPL
% license can be found at http://www.gnu.org/copyleft/gpl.html .
% 
% FOR RESEARCH PURPOSES ONLY. THE SOFTWARE IS PROVIDED "AS IS," AND THE
% UNIVERSITY OF SOUTHERN CALIFORNIA AND ITS COLLABORATORS DO NOT MAKE ANY
% WARRANTY, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO WARRANTIES OF
% MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, NOR DO THEY ASSUME ANY
% LIABILITY OR RESPONSIBILITY FOR THE USE OF THIS SOFTWARE.
%<autoend> ------------------------ 26-May-2004 11:30:19 -----------------------


% BrainStorm utility function
% JCM 2/27/2002
% search algorithm based on Mathworks PATH command

ak = [0 find(P==pathsep)]; % Beginning of each path

% End of each path (ignoring trailing fileseps).
ake = ak(2:end)-(P(ak(2:end)-1)==filesep);

C = cell(1,length(ak)-1);

for i=1:(length(ak)-1)
   
   C{i} = P(ak(i)+1:ake(i)-1);
   
end
