function [Channel,varargout] = get_channel(dataFileName);
%GET_CHANNEL - Get the Channel information associated with a particular data file
% function [Channel,varargout] = get_channel(dataFileName);
% function Channel = get_channel(dataFileName);
% function [Channel,ChannelFile] = get_channel(dataFileName);
% ChannelFile is the name of the channel...file
% If dataFileName is not given, retrieve it from the static taskbar

%<autobegin> ---------------------- 26-May-2004 11:30:19 -----------------------
% --------- Automatically Generated Comments Block Using AUTO_COMMENTS ---------
%
% CATEGORY: Utility - General
%
% Alphabetical list of external functions (non-Matlab):
%   toolbox\bst_message_window.m
%   toolbox\bst_static_taskbar.m
%   toolbox\makeuswait.m
%
% At Check-in: $Author: Mosher $  $Revision: 12 $  $Date: 5/26/04 9:59a $
%
% This software is part of BrainStorm Toolbox Version 2.0 (Alpha) 24-May-2004
% 
% Principal Investigators and Developers:
% ** Richard M. Leahy, PhD, Signal & Image Processing Institute,
%    University of Southern California, Los Angeles, CA
% ** John C. Mosher, PhD, Biophysics Group,
%    Los Alamos National Laboratory, Los Alamos, NM
% ** Sylvain Baillet, PhD, Cognitive Neuroscience & Brain Imaging Laboratory,
%    CNRS, Hopital de la Salpetriere, Paris, France
% 
% See BrainStorm website at http://neuroimage.usc.edu for further information.
% 
% Copyright (c) 2004 BrainStorm by the University of Southern California
% This software distributed  under the terms of the GNU General Public License
% as published by the Free Software Foundation. Further details on the GPL
% license can be found at http://www.gnu.org/copyleft/gpl.html .
% 
% FOR RESEARCH PURPOSES ONLY. THE SOFTWARE IS PROVIDED "AS IS," AND THE
% UNIVERSITY OF SOUTHERN CALIFORNIA AND ITS COLLABORATORS DO NOT MAKE ANY
% WARRANTY, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO WARRANTIES OF
% MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, NOR DO THEY ASSUME ANY
% LIABILITY OR RESPONSIBILITY FOR THE USE OF THIS SOFTWARE.
%<autoend> ------------------------ 26-May-2004 11:30:19 -----------------------


if ~exist('dataFileName','var') | isempty(dataFileName),
    dataFileName = bst_static_taskbar('GET','DATA');
    dataFileName = dataFileName{1}; % only the first one used for reference
end

if iscell(dataFileName),
    dataFileName = dataFileName{1}; % only first cell element
end

if 0, % 29-Mar-2004, deprecated code - SB. Need to have this function stand alone and callable outside of BrainStorm
    % the database directories
    User = get_user_directory;
    
    if ~strncmp(lower(User.STUDIES),lower(dataFileName),length(User.STUDIES)),
        % referential name, make full
        dataFileName = fullfile(User.STUDIES,dataFileName);
    end
end

% the directory to the data file
dirPath = fileparts(dataFileName); 

Pwd = pwd; % where are we now

if ~isempty(dirPath)
    cd(dirPath)
end

channelFileNames = dir('*channel*.mat'); % all channel filenames

channelFileNames = {channelFileNames.name}; % just the name

if length(channelFileNames) > 1,
   bst_message_window({...
           ' ',...
           sprintf('NOTE: Multiple channel files in %s',dirPath),...
           ' '});
   errordlg({...
           ' ',...
           sprintf('Multiple channel files in %s',dirPath),...
           'Please alter this folder''s content so that it contains a single channel file.',...
           ' '},'Database needs cleaning !'...
       )
   makeuswait('stop')
   return
   
end

channelFileNames = channelFileNames{1}; % only the first

if nargout > 1
    varargout{1} = channelFileNames;
end

load(channelFileNames); % loads "Channel" into the local area and returns it
   
cd(Pwd); % back to where we were
