function cmap = grayish(cmap,minval);
%GRAYISH - % gray out the lower end of a spectrum for less severe palette
% function cmap = grayish(cmap,minval);
% assumes standard two-dimensional color map of three columns

%<autobegin> ---------------------- 26-May-2004 11:30:21 -----------------------
% --------- Automatically Generated Comments Block Using AUTO_COMMENTS ---------
%
% CATEGORY: Utility - General
%
% At Check-in: $Author: Mosher $  $Revision: 12 $  $Date: 5/26/04 9:59a $
%
% This software is part of BrainStorm Toolbox Version 2.0 (Alpha) 24-May-2004
% 
% Principal Investigators and Developers:
% ** Richard M. Leahy, PhD, Signal & Image Processing Institute,
%    University of Southern California, Los Angeles, CA
% ** John C. Mosher, PhD, Biophysics Group,
%    Los Alamos National Laboratory, Los Alamos, NM
% ** Sylvain Baillet, PhD, Cognitive Neuroscience & Brain Imaging Laboratory,
%    CNRS, Hopital de la Salpetriere, Paris, France
% 
% See BrainStorm website at http://neuroimage.usc.edu for further information.
% 
% Copyright (c) 2004 BrainStorm by the University of Southern California
% This software distributed  under the terms of the GNU General Public License
% as published by the Free Software Foundation. Further details on the GPL
% license can be found at http://www.gnu.org/copyleft/gpl.html .
% 
% FOR RESEARCH PURPOSES ONLY. THE SOFTWARE IS PROVIDED "AS IS," AND THE
% UNIVERSITY OF SOUTHERN CALIFORNIA AND ITS COLLABORATORS DO NOT MAKE ANY
% WARRANTY, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO WARRANTIES OF
% MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, NOR DO THEY ASSUME ANY
% LIABILITY OR RESPONSIBILITY FOR THE USE OF THIS SOFTWARE.
%<autoend> ------------------------ 26-May-2004 11:30:21 -----------------------

[m,n] = size(cmap);

if(length(minval) == 1),
  minval = minval + zeros(1,3);
end

for i = 1:3,
 cmap(:,i) = max(cmap(:,i),minval(i)); % set threshold
end

startndx = 0; % looking for highest index
for i = 1:3,
  startndx = max(startndx,min(find(cmap(:,1) > minval(i))));
end

% so color above this are above the minval

cmap = cmap(startndx:end,:); % only those values

% now rescale to full range by interpolating
mtrunc = size(cmap,1); % new length
ndx = [0:(mtrunc-1)]/(mtrunc-1)*(m-1); % scales to new range

cmap = interp1(ndx,cmap,[0:(m-1)]);

return
