function help_database_list;
%HELP_DATABASE_LIST - Explain the database used by BrainStorm
% function help_database_list;
% Call as a function or type 'help help_database_list' at the command line
%
% Generate this file using the development tool make_database_list
%
% See the bottom of this help for other links
%
% ======================== BRAINSTORM DATABASE LIST ============================
%
% As of 17-Jun-2004 15:59:47
%     in the Data Root C:\BrainStorm_2001\Phantom
% and the Subject Root C:\BrainStorm_2001\Phantom,
%
% the following BrainStorm Database files were identified:
%
%
%
% =========================== SUBJECT: FLAG FILE ===============================
%
% These files should match the template '*_brainstormsubject.mat'
%
% Help for this database file (help_data_bstsubject) is given as:
%
% ----------------------- Begin help_data_bstsubject ---------------------------
%   This file is a "flag file" whose presence in a folder indicates that this
%    folder contains BrainStorm information about a subject (patient).
%  
%              Anatomy : String name of the MRI data
%             Comments : String comment about this Subject
%    DateOfAcquisition : String date for human reference
%   DateOfModification : String date for human reference
%                 Name : String name of the subject
%          Tesselation : String name of the tesselation file
%  
%   Note that Anatomy and Tesselation are no longer used, instead found
%    separately by searches for *subjectimage* and *tess*
% ------------------------ End help_data_bstsubject ----------------------------
%
% Mat-files were found matching this type of file.
% The fieldnames found in these files were:
%
%                 Anatomy
%                Comments
%       DateOfAcquisition
%      DateOfModification
%                    Name
%             Tesselation
%
% The files matching this database type were:
%
% default_subject\sphere_brainstormsubject.mat
% montreal_subject\montreal_brainstormsubject.mat
% Paris\Paris_brainstormsubject.mat
% test_sphere_files\testsphere_brainstormsubject.mat
% USC_Skull\PhantomSkull_brainstormsubject.mat
%
% Loading the first mat-file as a structure yields
%
% 'sphere_brainstormsubject' has the following fields:
%                  Anatomy: char    e.g. 'default_subject\sphere_subjectimage.mat'
%                 Comments: char    e.g. 'MRI of a sphere'
%        DateOfAcquisition: char    e.g. '27-May-2004 23:36:33'
%       DateOfModification: char    e.g. '27-May-2004 23:36:33'
%                     Name: char    e.g. 'Default Spherical Subject'
%              Tesselation: empty   
%
%
%
% ===================== SUBJECT: ANATOMICAL INFORMATION ========================
%
% These files should match the template '*image*.mat'
%
% Help for this database file (help_data_image) is given as:
%
% -------------------------- Begin help_data_image -----------------------------
%  
%         Cube : is the actual image set, x, y, z, left to right, back to front,
%                bottom to top, of size M x N x P.
%    DataClass : a string describing the bit encoding of the gray levels (e.g. 'ushort')
%    Voxsize   : Size of a voxel in mm (e.g. [0.9375    0.9375    0.9375])
%    scantype  : a string label indicating the scan direction (e.g. 'Axial')
%          SCS : structure with fields:
%              FiducialName : cell array of ORDERED fiducial labels, 
%                             nasion, left and right and origin) 
%                            (e.g. 'Nasion', 'Left ear','Right ear', 'CTF Origin')
%                            (additional fiducials are stored in Landmarks below).
%            mmCubeFiducial : is 3 x n array of ORDERED coordinate fiducial points 
%                             in mm (see FiducialName) 
%                             MRI coordinates relative to 0,0,0 point.
%                    System : keyword, {'CTF','NEUROMAG'}
%                         R : 3x3 rotation matrix (cosines)
%                         T : translation 3x1 vector (units of mm)
%                     
%                             Transformation formulas are:
%                             x(SCS coordinates) = R * x(MRI coordinates) + T
%                             x(MRI) = inv(R)*(x(SCS) - T)
%  
%   Landmarks : a structure specifying locations of extra points of interests with fields:
%                  MRImmXYZ : a 3xn array of landmark locations in mm and MRI coordinate system
%                  Names    : a cell array of string used to label the landmarks
%  
%   See http://neuroimage.usc.edu/brainstorm/GUI_CoordinateSystem.htm
%  
% --------------------------- End help_data_image ------------------------------
%
% Mat-files were found matching this type of file.
% The fieldnames found in these files were:
%
%        Comment
%           Cube
%      DataClase
%      DataClass
%      Landmarks
%            PCS
%            SCS
%        Segment
%        Voxsize
%       filename
%       scantype
%
% The files matching this database type were:
%
% default_subject\sphere_subjectimage.mat
%   **(missing fields: Comment PCS Segment filename)
% montreal_subject\montreal_subjectimage.mat
%   **(missing fields: Comment DataClase PCS Segment filename)
% test_sphere_files\subjectimage.mat
%   **(missing fields: DataClase DataClass Landmarks)
% test_sphere_files\subjectimage2.mat
%   **(missing fields: Comment DataClase DataClass Landmarks PCS filename)
%
% Loading the first mat-file as a structure yields
%
% 'sphere_subjectimage' has the following fields:
%            Cube: uint8   
%       DataClase: char    e.g. 'uint8'
%       DataClass: empty   
%       Landmarks: [1x1 struct]  
%             SCS: [1x1 struct]  
%         Voxsize: [1x3 double]  
%        scantype: char    e.g. 'Axial'
%
%      Structure 'Landmarks' has the following fields:
%          MRImmXYZ: [3x2 double]  
%             Names: [1x2 cell]  
%
%      Structure 'SCS' has the following fields:
%            FiducialName: [1x4 cell]  
%                       R: [3x3 double]  
%                  System: char    e.g. 'CTF'
%                       T: [3x1 double]  
%          mmCubeFiducial: [3x4 double]  
%
%
%
% ==================== SUBJECT: TESSELATION INFORMATION ========================
%
% These files should match the template '*tess*.mat'
%
% Help for this database file (help_data_tess) is given as:
%
% -------------------------- Begin help_data_tess ------------------------------
%         Comment : Cell array, each element a descriptive string
%           Faces : Cell array, each element a m x 3 matrix of m face descriptors
%        Vertices : Cell array, each element a 3 x n matrix of the n vertex
%                   positions in Cartesian coordinates
%  
%   Note that Vertices is the transpose (3 x n) of what is expected in the "patch"
%     command (n x 3) and generally other tessellation routines.
%  
%   The ordering of the faces vertices must be such that 1 - 2 - 3 points
%   "outward" by the right-hand rule. The outward orientation of the triangle is
%   important for good visualization lighting, but it is critical for the proper
%   calculation of boundary elements.
% --------------------------- End help_data_tess -------------------------------
%
% Mat-files were found matching this type of file.
% The fieldnames found in these files were:
%
%       Clusters
%        Comment
%      Curvature
%          Faces
%       VertConn
%       Vertices
%
% The files matching this database type were:
%
% montreal_subject\montreal_3layer_tess.mat
%   **(missing fields: Clusters Curvature VertConn)
% montreal_subject\montreal_white_matter_tess.mat
%   **(missing fields: Clusters)
% Paris\paradis_tess-CTF.mat
% Paris\para_brain-CTF_tess.mat
%   **(missing fields: Clusters Curvature VertConn)
% Paris\para_brain-CTF_tess_alignedCTF.mat
%   **(missing fields: Clusters Curvature VertConn)
% Paris\para_head-CTF_tess.mat
%   **(missing fields: Clusters Curvature VertConn)
% Paris\para_head-CTF_tess_alignedCTF.mat
%   **(missing fields: Clusters Curvature VertConn)
% test_sphere_files\subjecttess.mat
%   **(missing fields: Clusters Curvature VertConn)
% USC_Skull\cortex_subjecttess.mat
%   **(missing fields: Clusters)
% USC_Skull\scalp_subjecttess.mat
%   **(missing fields: Clusters Curvature VertConn)
% USC_Skull\skull_subjecttess.mat
%   **(missing fields: Clusters Curvature VertConn)
% USC_Skull\subjecttess_vertconn.mat
%   **(missing fields: Clusters Comment Curvature Faces Vertices)
%
% Loading the first mat-file as a structure yields
%
% 'montreal_3layer_tess' has the following fields:
%        Comment: [1x3 cell]  
%          Faces: [3x1 cell]  
%       Vertices: [3x1 cell]  
%
%
%
% ================= SUBJECT: TESSELATION FACES CONNECTIVITY ====================
%
% These files should match the template '*triconn*.mat'
%
% Help for this database file (help_data_triconn) is given as:
%
% ------------------------- Begin help_data_triconn ----------------------------
%   (add help information)
% -------------------------- End help_data_triconn -----------------------------
%
%  No such files found in the database
%
%
%
% =============== SUBJECT: TESSELATION VERTICES CONNECTIVITY ===================
%
% These files should match the template '*vertconn*.mat'
%
% Help for this database file (help_data_vertconn) is given as:
%
% ------------------------ Begin help_data_vertconn ----------------------------
%   (add help information)
% ------------------------- End help_data_vertconn -----------------------------
%
% Mat-files were found matching this type of file.
% The fieldnames found in these files were:
%
%      VertConn
%
% The files matching this database type were:
%
% USC_Skull\subjecttess_vertconn.mat
%
% Loading the first mat-file as a structure yields
%
% 'subjecttess_vertconn' has the following fields:
%       VertConn: [4x1 cell]  
%
%
%
% ========================== STUDY: DATA FLAG FILE =============================
%
% These files should match the template '*_brainstormstudy.mat'
%
% Help for this database file (help_data_bststudy) is given as:
%
% ------------------------ Begin help_data_bststudy ----------------------------
%   The presence of this file in a folder signals BrainStorm that the folder
%    contains data and associated files for analysis.
%  
%          BrainStormSubject: String referential filename to the _brainstormsubject.mat
%         DateOfModification: String human reference '18-Sep-2003 09:35:20'
%                DateOfStudy: String human reference '18-Sep-2003 09:35:20'
%                       Name: String human reference 'John Doe'
%                    Session: String human reference 'Simulated Sphere Data'
% ------------------------- End help_data_bststudy -----------------------------
%
% Mat-files were found matching this type of file.
% The fieldnames found in these files were:
%
%       BrainStormSubject
%      DateOfModification
%             DateOfStudy
%                    Name
%                 Session
%                 Subject
%                  append
%
% The files matching this database type were:
%
% default_data\sphere_brainstormstudy.mat
%   **(missing fields: Subject)
% jlh_test\JLH_brainstormstudy.mat
%   **(missing fields: Subject)
% montreal_data\montreal_brainstormstudy.mat
%   **(missing fields: Subject)
% Sample_Raw\Mixed_brainstormstudy.mat
%   **(missing fields: Subject)
% simulated\sphere_brainstormstudy.mat
%   **(missing fields: append)
% test_sphere_files\testsphere_brainstormstudy.mat
%   **(missing fields: Subject)
%
% Loading the first mat-file as a structure yields
%
% 'sphere_brainstormstudy' has the following fields:
%        BrainStormSubject: char    e.g. 'montreal_subject\montreal_brainstormsubject.mat'
%       DateOfModification: char    e.g. '27-May-2004 23:36:34'
%              DateOfStudy: char    e.g. '27-May-2004 23:36:34'
%                     Name: char    e.g. 'Sample Raw'
%                  Session: char    e.g. 'Simulated Sphere Data'
%                   append: char    e.g. '-append'
%
%
%
% ==================== STUDY: SENSOR CHANNEL INFORMATION =======================
%
% These files should match the template '*channel*.mat'
%
% Help for this database file (help_data_channel) is given as:
%
% ------------------------- Begin help_data_channel ----------------------------
%  
%      Landmark : a structure specifying locations of extra points of interests with fields:
%                Loc : a 3 x n array of landmark locations in meters coordinate system
%               Name : a 1 x n cell array of string used to label the landmarks
%  
%       Channel : An array of structures. Each element in the array comprises 
%                  the following fields
%                Loc : 3 x n, one column per coil, location in meters in SCS
%             Weight : 1 x n, relative gradiometer weights, e.g. [1 -1] or [1 -2 1]
%             Orient : 3 x n, one column per coil, Cartesian orientation in SCS
%               Type : String, must be {'MEG', 'EEG', 'MEG REF','EEG REF', 'OTHER'};
%               Name : String, short label, usually machine assigned 'MEG 001'
%            Comment : See explanation below
%   
%    The Comment field is somewhat complicated, CBB.
%            Comment : Keywords or data. If TYPE is 'EEG' and data are average referenced, 
%                      then Comment must be 'AVERAGE REF', and all Loc are a single location.
%                      If EEG are data are differential, then two Loc and Weights
%                      are used, and Comment is '' (blank). 
%                      If EEG data are single ended, then Loc is one location,
%                      there can ONLY be one Type of 'EEG REF', Comment is '', and
%                      algorithms know to search for the reference channel.
%                      If MEG data, and there are reference channels, the
%                      reference channels are marked Type 'MEG REF'. Then the
%                      FIRST Channel of Type 'MEG' has a Comment field that gives
%                      the transformation matrix that builds the higher
%                      gradiometers. See notes below for calculation method.
%  
%   Obsolete
%             System : String    e.g. 'CTF 151', this field apparently not used.
%  
%   -- Notes --
%   SCS is the patient coordinate system, i.e. the coil location is with respect
%      to the subject's origin. See BrainStorm reference on coordinate systems:
%  
%      http://neuroimage.usc.edu/brainstorm/GUI_CoordinateSystem.htm
%  
%   A "channel" comprises the locations of the array's output, usually the
%      result of combining "n" different coil locations.
%  
%   The reference channels are used to form "virtual gradiometers." If there are
%    151 head channels (Type 'MEG') and 29 reference channels (Type 'MEG REF'),
%    then the reference weighting matrix is 151 x 29. The 151 originally recorded
%    data channels are modified in the machine or external to BrainStorm as Ffinal
%    = Forg - W*Fref; If Gfinal is the gain matrix for the noise-weighted gain
%    matrix (151 rows), Ghead is the gain matrix for each channel without noise
%    weighting (151 rows),  Gref is the gain matrix for each of the reference
%    channels (29 rows), and W is the reference channel weights, then:
%  
%     Gfinal = Ghead - W*Gref;
%  
%    See help_data_raw for descriptions on how to manually store this information
%    and importation. At this time, CTF weighting information is automatically
%    handled. 
%  
% -------------------------- End help_data_channel -----------------------------
%
% Mat-files were found matching this type of file.
% The fieldnames found in these files were:
%
%      Channel
%
% The files matching this database type were:
%
% default_data\sphere_channel.mat
% jlh_test\JLH_channel.mat
% montreal_data\montreal_channel.mat
% Sample_Raw\Mixed_channel.mat
% simulated\sphere_channel.mat
% test_sphere_files\testsphere_channels.mat
% USC_Skull\EEG_channel.mat
%
% Loading the first mat-file as a structure yields
%
% 'sphere_channel' has the following fields:
%       Channel: [1x138 struct]  
%
%      Structure 'Channel' has the following fields:
%          Comment: char    e.g. 'Simulated magnetometer #001'
%              Loc: [3x1 double]  
%             Name: char    e.g. 'MEG 001'
%           Orient: [3x1 double]  
%           System: char    e.g. 'ctf'
%             Type: char    e.g. 'MEG'
%           Weight: [1x1 double]  e.g. 1
%
%
%
% ============= STUDY: FORWARD PROBLEM (HEAD AND SENSOR) MODEL =================
%
% These files should match the template '*headmodel*.mat'
%
% Help for this database file (help_data_headmodel) is given as:
%
% ------------------------ Begin help_data_headmodel ---------------------------
%   For m channels of data:
%                  Gain : [1x1 cell]  
%               GridLoc : [1x1 cell]  
%              GridName : [1x1 cell]  
%         HeadModelName : char    e.g. 'meg_sphere'
%         HeadModelType : char    e.g. 'SearchGrid'
%             MEGMethod : char    e.g. 'meg_sphere'
%                 Param : [1x138 struct]  
%           SourceOrder : [1x1 double]  e.g. -1
%  
%        Structure 'Param' has the following fields:
%                    Berg : empty   
%                  Center : [3x1 double]  
%            Conductivity : empty   
%                 EEGType : empty   
%                   Order : [1x1 double]  e.g. -1
%                   Radii : [1x3 double]  
% ------------------------- End help_data_headmodel ----------------------------
%
% Mat-files were found matching this type of file.
% The fieldnames found in these files were:
%
%              EEGMethod
%               Function
%                   Gain
%              GainCovar
%          GainCovarName
%      GainCovar_ColNorm
%                GridLoc
%               GridName
%             GridOrient
%          HeadModelName
%          HeadModelType
%              MEGMethod
%                  Param
%            SourceOrder
%                  iGrid
%
% The files matching this database type were:
%
% default_data\sphere_headmodelVolGrid_CD.mat
%   **(missing fields: EEGMethod GainCovar GainCovarName GainCovar_ColNorm GridOrient iGrid)
% jlh_test\JLH_headmodelVolGrid_CD.mat
%   **(missing fields: GainCovar GainCovarName GainCovar_ColNorm GridOrient MEGMethod iGrid)
% montreal_data\montreal_headmodelSurfGrid_CD.mat
%   **(missing fields: EEGMethod)
% montreal_data\montreal_headmodelVolGrid_CD.mat
%   **(missing fields: EEGMethod GainCovar GainCovarName GainCovar_ColNorm GridOrient iGrid)
% test_sphere_files\testsphere_headmodelVolGrid_CD.mat
%   **(missing fields: EEGMethod GainCovar GainCovarName GainCovar_ColNorm GridOrient iGrid)
% test_sphere_files\testsphere_headmodelVolGrid_CD_1.mat
%   **(missing fields: EEGMethod GainCovar GainCovarName GainCovar_ColNorm GridOrient iGrid)
%
% Loading the first mat-file as a structure yields
%
% 'sphere_headmodelVolGrid_CD' has the following fields:
%            Function: [1x138 cell]  
%                Gain: [1x1 cell]  
%             GridLoc: [1x1 cell]  
%            GridName: [1x1 cell]  
%       HeadModelName: char    e.g. 'meg_sphere'
%       HeadModelType: char    e.g. 'SearchGrid'
%           MEGMethod: char    e.g. 'meg_sphere'
%               Param: [1x138 struct]  
%         SourceOrder: [1x1 double]  e.g. -1
%
%      Structure 'Param' has the following fields:
%                  Berg: empty   
%                Center: [3x1 double]  
%          Conductivity: empty   
%               EEGType: empty   
%                 Order: [1x1 double]  e.g. -1
%                 Radii: [1x3 double]  
%
%
%
% ========================= STUDY: EEG OR MEG DATA =============================
%
% These files should match the template '*data*.mat'
%
% Help for this database file (help_data_data) is given as:
%
% -------------------------- Begin help_data_data ------------------------------
%   For m channels of data over n samples of time:
%         ChannelFlag : 1 x length(Channel) of {0,1} to indicate whether or not to use
%                       Warning: when data is measured w.r.t. some reference channel(s), 
%                       ChannelFlag and F (see below) are of length of Channel. 
%                       Channel being the Channel structure stored in a companion 
%                       channel*.mat file in the same fodler as the *data*.mat file.
%             Comment : String for human reference 'Simulated Data'
%              Device : String information words e.g. 'Neuromag', 'CTF',
%                       deprecated by still in use by information displays.
%              System : String, key words {'CTF','NEUROMAG'};
%                       Establishes the coordinate system used
%                   F : The Spatio-temporal length(Channel) x n data matrix in
%                       MKS units (Telsa, Volt)
%            NoiseCov : Sqrt of the noise covariance matrix, m x m (all channels),
%                       in development
%           Projector : empty, in development
%           SourceCov : empty, in development
%                Time : 1 x n of time indices in seconds
% --------------------------- End help_data_data -------------------------------
%
% Mat-files were found matching this type of file.
% The fieldnames found in these files were:
%
%      ChannelFlag
%          Comment
%           Device
%                F
%         NoiseCov
%          Project
%        Projector
%        SourceCov
%           System
%             Time
%
% The files matching this database type were:
%
% default_data\sphere_data_363398.mat
%   **(missing fields: Project System)
% jlh_test\JLH_data.mat
%   **(missing fields: Project)
% montreal_data\montreal_data_4713.mat
%   **(missing fields: Project)
% Sample_Raw\Mixed_data.mat
%   **(missing fields: Project)
% simulated\sphere_data_054333.mat
%   **(missing fields: Project System)
% test_sphere_files\testsphere_data.mat
%   **(missing fields: System)
% USC_Skull\EEG_data6.mat
%   **(missing fields: Project)
%
% Loading the first mat-file as a structure yields
%
% 'sphere_data_363398' has the following fields:
%       ChannelFlag: [1x138 double]  
%           Comment: char    e.g. 'Simulated Data'
%            Device: char    e.g. 'Ctf_Axial'
%                 F: [138x100 double]  
%          NoiseCov: empty   
%         Projector: empty   
%         SourceCov: empty   
%              Time: [1x100 double]  
%
%
%
% ===================== STUDY: INVERSE PROBLEM RESULTS =========================
%
% These files should match the template '*results*.mat'
%
% Help for this database file (help_data_results) is given as:
%
% ------------------------- Begin help_data_results ----------------------------
%                    Center: [3x1 double]  
%                   Comment: char    e.g. 'Simulated data'
%                   DataFlag : a string specifiying the type of data the results originate from
%                            'MEG', 'EEG', 'Fusion'
%                  Fsynth: [138x100 double]  
%                 IndepTopo: [138x3 double]  
%                 SourceLoc: [1x3 cell]  
%         SourceOrientation: [1x3 cell]  
%                      Time: [1x100 double]  
%                TimeSeries: [100x3 double]  
% -------------------------- End help_data_results -----------------------------
%
% Mat-files were found matching this type of file.
% The fieldnames found in these files were:
%
%                 Center
%                Channel
%            ChannelFlag
%                Comment
%               DataFile
%               DataFlag
%                   Date
%                 Fsynth
%               Function
%                    GUI
%          HeadModelFile
%           ImageGridAmp
%          ImageGridTime
%          ImagingKernel
%              IndepTopo
%              ModelGain
%               NoiseCov
%                OPTIONS
%               PatchAmp
%               PatchNdx
%              Projector
%              Residuals
%      SourceCorrelation
%              SourceCov
%              SourceLoc
%            SourceOrder
%      SourceOrientation
%                  Study
%           StudySubject
%                Subject
%                   Time
%             TimeSeries
%
% The files matching this database type were:
%
% default_data\sphere_results_363398.mat
%   **(missing fields: Channel ChannelFlag DataFile DataFlag Date Function GUI HeadModelFile ImageGridAmp ImageGridTime ImagingKernel ModelGain NoiseCov OPTIONS PatchAmp PatchNdx Projector Residuals SourceCorrelation SourceCov SourceOrder Study StudySubject Subject)
% default_data\sphere_results_363398_1530.mat
%   **(missing fields: Center Channel DataFile HeadModelFile ImagingKernel OPTIONS Residuals)
% jlh_test\JLH_results_1011.mat
%   **(missing fields: Center Channel DataFile HeadModelFile ImagingKernel OPTIONS Residuals)
% jlh_test\JLH_results_1154.mat
%   **(missing fields: Center Channel DataFile HeadModelFile ImagingKernel OPTIONS Residuals)
% jlh_test\JLH_results_1534.mat
%   **(missing fields: Center Channel DataFile HeadModelFile ImagingKernel OPTIONS Residuals)
% jlh_test\JLH_results_1536.mat
%   **(missing fields: Center Channel DataFile HeadModelFile ImagingKernel OPTIONS Residuals)
% jlh_test\JLH_results_1629.mat
%   **(missing fields: Center Channel DataFile HeadModelFile ImagingKernel OPTIONS Residuals)
% montreal_data\montreal_results_4713_1548.mat
%   **(missing fields: Center Channel DataFile HeadModelFile ImagingKernel OPTIONS Residuals)
% montreal_data\montreal_results_4713_MNE_MEG_1550.mat
%   **(missing fields: Center DataFlag GUI IndepTopo SourceCorrelation Study StudySubject Subject)
% simulated\sphere_results_054333.mat
%   **(missing fields: Channel ChannelFlag DataFile DataFlag Date Function GUI HeadModelFile ImageGridAmp ImageGridTime ImagingKernel ModelGain NoiseCov OPTIONS PatchAmp PatchNdx Projector Residuals SourceCorrelation SourceCov SourceOrder Study StudySubject Subject)
% test_sphere_files\testsphere_results_1349.mat
%   **(missing fields: Center Channel DataFile HeadModelFile ImagingKernel OPTIONS Residuals)
%
% Loading the first mat-file as a structure yields
%
% 'sphere_results_363398' has the following fields:
%                  Center: [3x1 double]  
%                 Comment: char    e.g. 'Simulated data'
%                  Fsynth: [138x100 double]  
%               IndepTopo: [138x3 double]  
%               SourceLoc: [1x3 cell]  
%       SourceOrientation: [1x3 cell]  
%                    Time: [1x100 double]  
%              TimeSeries: [100x3 double]  
%
%
%
% See also HELP_DATA_BSTSUBJECT, HELP_DATA_IMAGE, HELP_DATA_TESS
% HELP_DATA_TRICONN, HELP_DATA_VERTCONN, HELP_DATA_BSTSTUDY
% HELP_DATA_CHANNEL, HELP_DATA_HEADMODEL, HELP_DATA_DATA
% HELP_DATA_RESULTS
%

%<autobegin> ---------------------- 17-Jun-2004 15:59:48 -----------------------
% --------- Automatically Generated Comments Block Using AUTO_COMMENTS ---------
%
% CATEGORY: Help
%
% At Check-in: $Author: Mosher $  $Revision: 11 $  $Date: 6/17/04 3:30p $
%
% This software is part of BrainStorm Toolbox Version 2.0 (Alpha) 16-Jun-2004
% 
% Principal Investigators and Developers:
% ** Richard M. Leahy, PhD, Signal & Image Processing Institute,
%    University of Southern California, Los Angeles, CA
% ** John C. Mosher, PhD, Biophysics Group,
%    Los Alamos National Laboratory, Los Alamos, NM
% ** Sylvain Baillet, PhD, Cognitive Neuroscience & Brain Imaging Laboratory,
%    CNRS, Hopital de la Salpetriere, Paris, France
% 
% See BrainStorm website at http://neuroimage.usc.edu for further information.
% 
% Copyright (c) 2004 BrainStorm by the University of Southern California
% This software distributed  under the terms of the GNU General Public License
% as published by the Free Software Foundation. Further details on the GPL
% license can be found at http://www.gnu.org/copyleft/gpl.html .
% 
% FOR RESEARCH PURPOSES ONLY. THE SOFTWARE IS PROVIDED "AS IS," AND THE
% UNIVERSITY OF SOUTHERN CALIFORNIA AND ITS COLLABORATORS DO NOT MAKE ANY
% WARRANTY, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO WARRANTIES OF
% MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, NOR DO THEY ASSUME ANY
% LIABILITY OR RESPONSIBILITY FOR THE USE OF THIS SOFTWARE.
%<autoend> ------------------------ 17-Jun-2004 15:59:48 -----------------------



% CATEGORY: Help

helptext = help(mfilename);

helpwin(mfilename);
