function MRI = load_BsTMRI(filename);
%LOAD_BSTMRI - Load BrainStorm MRI format
% function MRI = load_BsTMRI(filename);

%<autobegin> ---------------------- 26-May-2004 11:30:50 -----------------------
% --------- Automatically Generated Comments Block Using AUTO_COMMENTS ---------
%
% CATEGORY: Visualization
%
% At Check-in: $Author: Mosher $  $Revision: 10 $  $Date: 5/26/04 9:59a $
%
% This software is part of BrainStorm Toolbox Version 2.0 (Alpha) 24-May-2004
% 
% Principal Investigators and Developers:
% ** Richard M. Leahy, PhD, Signal & Image Processing Institute,
%    University of Southern California, Los Angeles, CA
% ** John C. Mosher, PhD, Biophysics Group,
%    Los Alamos National Laboratory, Los Alamos, NM
% ** Sylvain Baillet, PhD, Cognitive Neuroscience & Brain Imaging Laboratory,
%    CNRS, Hopital de la Salpetriere, Paris, France
% 
% See BrainStorm website at http://neuroimage.usc.edu for further information.
% 
% Copyright (c) 2004 BrainStorm by the University of Southern California
% This software distributed  under the terms of the GNU General Public License
% as published by the Free Software Foundation. Further details on the GPL
% license can be found at http://www.gnu.org/copyleft/gpl.html .
% 
% FOR RESEARCH PURPOSES ONLY. THE SOFTWARE IS PROVIDED "AS IS," AND THE
% UNIVERSITY OF SOUTHERN CALIFORNIA AND ITS COLLABORATORS DO NOT MAKE ANY
% WARRANTY, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO WARRANTIES OF
% MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, NOR DO THEY ASSUME ANY
% LIABILITY OR RESPONSIBILITY FOR THE USE OF THIS SOFTWARE.
%<autoend> ------------------------ 26-May-2004 11:30:50 -----------------------



% /---Script Authors-------------------------------------\
% |  *** Sylvain Baillet, Ph.D.                          |
% |  Cognitive Neuroscience & Brain Imaging Laboratory   |
% |  CNRS UPR640 - LENA                                  | 
% |  Hopital de la Salpetriere, Paris, France            |
% |  sylvain.baillet@chups.jussieu.fr                    |
% |                                                      |
% |  *** John C. Mosher, Ph.D.                           |
% |  Biophysics Group                                    |                                   |
% \------------------------------------------------------/
%  
% Script History ---------------------------------------------------------------
% SB  10-Mar-2004 Creation (BrainStorm v.1 update)
% Script History ---------------------------------------------------------------

% CBB: Has not been adapted to SCS nomenclatures, still uses PCS

MRI =load(filename);
MRI.filename = fullfile(pwd,filename);

MRI.scantype = 'Axial'; % Default for BsT format 
MRI.header = 0; 

if isfield(MRI,'PCS')% A PCS has been defined 
      set(findobj(gcbf,'Tag','ShowFiducials'),'Enable','on')
    
    if isfield(MRI,'scale_fiducials') % User uses the dummy head
        MRI.rot = MRI.scale_fiducials*MRI.PCS.R ;
    end
    
else
    set(findobj(gcbf,'Tag','ShowFiducials'),'Enable','off')
end
