function load_result = load_brainstorm_file(Filename);
%LOAD_BRAINSTORM_FILE - load or try to find and load the BrainStorm file.
% function load_result = load_brainstorm_file(Filename);
% If the Filename does not exist, break into parts and try to find it in the structure
% Returns the result identical to Matlab load command: load_result = load(Filename);

%<autobegin> ---------------------- 26-May-2004 11:30:49 -----------------------
% --------- Automatically Generated Comments Block Using AUTO_COMMENTS ---------
%
% CATEGORY: Database Management
%
% Alphabetical list of external functions (non-Matlab):
%   toolbox\find_brainstorm_files.m
%   toolbox\get_user_directory.m
%
% At Check-in: $Author: Mosher $  $Revision: 13 $  $Date: 5/26/04 9:59a $
%
% This software is part of BrainStorm Toolbox Version 2.0 (Alpha) 24-May-2004
% 
% Principal Investigators and Developers:
% ** Richard M. Leahy, PhD, Signal & Image Processing Institute,
%    University of Southern California, Los Angeles, CA
% ** John C. Mosher, PhD, Biophysics Group,
%    Los Alamos National Laboratory, Los Alamos, NM
% ** Sylvain Baillet, PhD, Cognitive Neuroscience & Brain Imaging Laboratory,
%    CNRS, Hopital de la Salpetriere, Paris, France
% 
% See BrainStorm website at http://neuroimage.usc.edu for further information.
% 
% Copyright (c) 2004 BrainStorm by the University of Southern California
% This software distributed  under the terms of the GNU General Public License
% as published by the Free Software Foundation. Further details on the GPL
% license can be found at http://www.gnu.org/copyleft/gpl.html .
% 
% FOR RESEARCH PURPOSES ONLY. THE SOFTWARE IS PROVIDED "AS IS," AND THE
% UNIVERSITY OF SOUTHERN CALIFORNIA AND ITS COLLABORATORS DO NOT MAKE ANY
% WARRANTY, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO WARRANTIES OF
% MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, NOR DO THEY ASSUME ANY
% LIABILITY OR RESPONSIBILITY FOR THE USE OF THIS SOFTWARE.
%<autoend> ------------------------ 26-May-2004 11:30:49 -----------------------

% History ---------------------------------------------
% Oct 26,1999     initial version
% 11/6/99         altered to handle referential names
% 06/27/00        UNIX/PCWIN portability
% JCM 10-Sep-2003 Commenting
% -----------------------------------------------------

switch computer
case 'PCWIN'
   Filename = strrep(Filename,'/','\');
otherwise
   Filename = strrep(Filename,'\','/');
end



% try a fully qualified name first
if(exist(Filename,'file')==2), % works as is, load it
   load_result = load(Filename);
   return
end

% try prefix of the user's search paths
User = get_user_directory; % get defaults

QualName = fullfile(User.STUDIES,Filename); % fully qualified
if(exist(QualName,'file')==2),
   load_result = load(QualName);
   return
end

% that didn't work either, repeat using the Subjects name
QualName = fullfile(User.SUBJECTS,Filename); % fully qualified
if(exist(QualName,'file')==2),
   load_result = load(QualName);
   return
end


% It doesn't exist as given, try to locate. Usually the user has altered his tree.

[path,name,ext,ver] = fileparts(Filename); % get the filename part
[DataFiles,ignore,Leader] = find_brainstorm_files(name); % find any file in the path with that name

if(~isempty(DataFiles)),
   load_result = load(fullfile(Leader,DataFiles{1})); % load only the first results of a find
   msgbox(sprintf(['Could not find your file "%s", but the file "%s" was ' ...
         'automatically detected and loaded instead. Suggest you ' ...
         'use Study/Subject editor to correct the file name'],...
      Filename,fullfile(Leader,DataFiles{1})),...
      'BrainStorm Notice','non-modal');
   
else % it is empty, no such filename in the search tree
   % not okay, aborted
   % inelegant error handling
   load_result = [];
   msgbox(sprintf(['Could not find your file "%s"'],...
      Filename),...
      'BrainStorm Error','modal');
end

return
