function [outmat,col_offset] = offset(inmat,col_offset);
%OFFSET - each column in inmat such that a plot(outmat) looks good.
% function [outmat,col_offset] = offset(inmat,col_offset);
% If col_offset is given, use it; otherwise, caculate a "good" col_offset.
% plot([outmat col_offset]) gives baselines as well

%<autobegin> ---------------------- 26-May-2004 11:31:14 -----------------------
% --------- Automatically Generated Comments Block Using AUTO_COMMENTS ---------
%
% CATEGORY: Utility - General
%
% At Check-in: $Author: Mosher $  $Revision: 12 $  $Date: 5/26/04 10:00a $
%
% This software is part of BrainStorm Toolbox Version 2.0 (Alpha) 24-May-2004
% 
% Principal Investigators and Developers:
% ** Richard M. Leahy, PhD, Signal & Image Processing Institute,
%    University of Southern California, Los Angeles, CA
% ** John C. Mosher, PhD, Biophysics Group,
%    Los Alamos National Laboratory, Los Alamos, NM
% ** Sylvain Baillet, PhD, Cognitive Neuroscience & Brain Imaging Laboratory,
%    CNRS, Hopital de la Salpetriere, Paris, France
% 
% See BrainStorm website at http://neuroimage.usc.edu for further information.
% 
% Copyright (c) 2004 BrainStorm by the University of Southern California
% This software distributed  under the terms of the GNU General Public License
% as published by the Free Software Foundation. Further details on the GPL
% license can be found at http://www.gnu.org/copyleft/gpl.html .
% 
% FOR RESEARCH PURPOSES ONLY. THE SOFTWARE IS PROVIDED "AS IS," AND THE
% UNIVERSITY OF SOUTHERN CALIFORNIA AND ITS COLLABORATORS DO NOT MAKE ANY
% WARRANTY, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO WARRANTIES OF
% MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, NOR DO THEY ASSUME ANY
% LIABILITY OR RESPONSIBILITY FOR THE USE OF THIS SOFTWARE.
%<autoend> ------------------------ 26-May-2004 11:31:14 -----------------------


% Copyright (c) 1993-98 John C. Mosher, Ph.D.
%  See Copyright.m file for information
% 12/1/93 Author
% $Revision: 12 $ $Date: 5/26/04 10:00a $

[m,n] = size(inmat);

if(exist('col_offset')~=1),		% user didn't give an col_offset
  sd = sort(abs(inmat(:)));		% sort all data
  if isempty(find(inmat(:)<0))
      col_offset = 1.2*sd(floor(m*n*.99));	% When data are all positive	
  else
      col_offset = 2*sd(floor(m*n*.99));% otherwise
  end
end
col_offset = [0:(n-1)]*col_offset;
col_offset = col_offset(ones(m,1),:); % matrix 

outmat = inmat + col_offset;	% each column now col_offset

return

