function [err,SphereSc,Radius] = overlapping_sphere_fmins(X,TrueSc,Loc,Orient,Weight,Vertices);
%OVERLAPPING_SPHERE_FMINS - for use with OVERLAPPING_SPHERE
% function [err,SphereSc,Radius] = overlapping_sphere_fmins(X,TrueSc,Loc,Orient,Weight,Vertices);
% calculate the error between true and estimated weighting scalars

%<autobegin> ---------------------- 26-May-2004 11:34:04 -----------------------
% --------- Automatically Generated Comments Block Using AUTO_COMMENTS ---------
%
% CATEGORY: Forward Modeling
%
% Alphabetical list of external functions (non-Matlab):
%   toolbox\colnorm.m
%   toolbox\weighting_scalar.m
%
% At Check-in: $Author: Mosher $  $Revision: 12 $  $Date: 5/26/04 10:02a $
%
% This software is part of BrainStorm Toolbox Version 2.0 (Alpha) 24-May-2004
% 
% Principal Investigators and Developers:
% ** Richard M. Leahy, PhD, Signal & Image Processing Institute,
%    University of Southern California, Los Angeles, CA
% ** John C. Mosher, PhD, Biophysics Group,
%    Los Alamos National Laboratory, Los Alamos, NM
% ** Sylvain Baillet, PhD, Cognitive Neuroscience & Brain Imaging Laboratory,
%    CNRS, Hopital de la Salpetriere, Paris, France
% 
% See BrainStorm website at http://neuroimage.usc.edu for further information.
% 
% Copyright (c) 2004 BrainStorm by the University of Southern California
% This software distributed  under the terms of the GNU General Public License
% as published by the Free Software Foundation. Further details on the GPL
% license can be found at http://www.gnu.org/copyleft/gpl.html .
% 
% FOR RESEARCH PURPOSES ONLY. THE SOFTWARE IS PROVIDED "AS IS," AND THE
% UNIVERSITY OF SOUTHERN CALIFORNIA AND ITS COLLABORATORS DO NOT MAKE ANY
% WARRANTY, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO WARRANTIES OF
% MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, NOR DO THEY ASSUME ANY
% LIABILITY OR RESPONSIBILITY FOR THE USE OF THIS SOFTWARE.
%<autoend> ------------------------ 26-May-2004 11:34:04 -----------------------


% John C. Mosher, Ph.D. See Copyright.m file for information
%
% $Date: 5/26/04 10:02a $ $Revision: 12 $

Center = X(1:3);
Radius = X(4);
N = size(Vertices,2); % number of vertices
OneN = ones(1,N); % convenient vector of ones

% two cases here. 'Scalar' attempts to fit the weighting scalar function between
%  the true surface and the spherical surface. The problem is a strong dependency
%  on surface normals that appears to skew the spheres. Theoretical assumption flaw
%  may be that the fictitious currents are not that similar.
%  'Weights' instead simply fits a sphere to the vertices, but uses the Scalar function 
%  to weight the least-squares fit.
%  Need to test more formally

% leave one uncommented:
%switch 'Scalar'
switch 'Weights'
  
case 'Scalar'
  
  % First synthesize the normals as vectors passing from the center through the vertices  
  [ignore,Normals] = colnorm(Vertices - Center(:,OneN)); 
  
  % then synthesize vertices as points on the sphere  
  Vertices = Radius * Normals + Center(:,OneN);
  
  % now calculate the weighting scalar to the sphere points
  SphereSc = weighting_scalar(Loc,Orient,Weight,Vertices,Normals);
  
  % now calculate the least-squares error between the two scalar sets
  err = sum((TrueSc - SphereSc).^2);
  
case 'Weights'
  
  % Scale the true scalar to be a weighting function
  Weights = abs(TrueSc)/sum(abs(TrueSc)); % don't care about sign.
  
  % extracted from sphererr.m
  b = Vertices - Center(:,OneN);  % data - estimated center
  
  % form distances to center estimate
  b = sqrt(sum(b.^2))'; % col vector of distances
  r = sum(b.*Weights); % average distance weighted by Scalar
  
  % squared error, weighted by scalars
  err = ((b-r).*Weights).^2; % squared error between distances and sphere
  % map for informative purposes
  SphereSc = err;
  err = sum(err); % sum squared error
  
  Radius = r; % overrides what the user sent
    
end

return
