function varargout = pcs_params(varargin)
%PCS_PARAMS - Application M-file to set the parameters of the patient coordinates
% function varargout = pcs_params(varargin)
%    FIG = PCS_PARAMS launch PCS_params GUI.
%    PCS_PARAMS('callback_name', ...) invoke the named callback.

%<autobegin> ---------------------- 26-May-2004 11:34:07 -----------------------
% --------- Automatically Generated Comments Block Using AUTO_COMMENTS ---------
%
% CATEGORY: GUI and Related
%
% Alphabetical list of external functions (non-Matlab):
%   toolbox\bst_color_scheme.m
%   toolbox\bst_layout.m
%   toolbox\bst_mriviewer.m
%   toolbox\modulo.m
%   toolbox\pcs_params.m  NOTE: Routine calls itself explicitly
%
% Subfunctions in this file, in order of occurrence in file:
%   varargout = create(h, eventdata, handles, varargin)
%   varargout = assign_Callback(h, eventdata, handles, varargin)
%   varargout = done_Callback(h, eventdata, handles, varargin)
%   varargout = checkboxctf_Callback(h, eventdata, handles, varargin)
%   varargout = checkboxnmag_Callback(h, eventdata, handles, varargin)
%   varargout = quit_Callback(h, eventdata, handles, varargin)
%
% Application data and their calls in this file:
%   'DefaultFiducialNames'
%   'LookUpFiducials'
%   'TileType'
%   
%   setappdata(fig,'DefaultFiducialNames',FidNames0);
%   setappdata(fig,'TileType','T')
%   setappdata(handles.pcsparams,'LookUpFiducials',ass)
%   
%   FidNames0 = getappdata(handles.pcsparams,'DefaultFiducialNames');
%   ass = getappdata(gcbf,'LookUpFiducials');
%   ass = getappdata(handles.pcsparams,'LookUpFiducials');
%
% Figure Files opened by this function:
%   mfilename
%
%   Format of strings below: Type:Style:Tag, "String", CallBack Type and Call
%   <automatic> callback is <Tag>_Callback by Matlab default
%
% Callbacks by figure pcs_params.fig
%   uicontrol:pushbutton:assign "Assign" uses Callback for <automatic>
%   uicontrol:pushbutton:Hdone "Done" uses Callback for
%     pcs_params('done_Callback',gcbo,[],guidata(gcbo))
%   uicontrol:pushbutton:Quit "Cancel" uses Callback for
%     PCS_params('quit_Callback',gcbo,[],guidata(gcbo))
%   uicontrol:radiobutton:checkboxctf "CTF / Magnes" uses Callback for <automatic>
%   uicontrol:radiobutton:checkboxnmag "Neuromag" uses Callback for <automatic>
%
% At Check-in: $Author: Mosher $  $Revision: 22 $  $Date: 5/26/04 10:02a $
%
% This software is part of BrainStorm Toolbox Version 2.0 (Alpha) 24-May-2004
% 
% Principal Investigators and Developers:
% ** Richard M. Leahy, PhD, Signal & Image Processing Institute,
%    University of Southern California, Los Angeles, CA
% ** John C. Mosher, PhD, Biophysics Group,
%    Los Alamos National Laboratory, Los Alamos, NM
% ** Sylvain Baillet, PhD, Cognitive Neuroscience & Brain Imaging Laboratory,
%    CNRS, Hopital de la Salpetriere, Paris, France
% 
% See BrainStorm website at http://neuroimage.usc.edu for further information.
% 
% Copyright (c) 2004 BrainStorm by the University of Southern California
% This software distributed  under the terms of the GNU General Public License
% as published by the Free Software Foundation. Further details on the GPL
% license can be found at http://www.gnu.org/copyleft/gpl.html .
% 
% FOR RESEARCH PURPOSES ONLY. THE SOFTWARE IS PROVIDED "AS IS," AND THE
% UNIVERSITY OF SOUTHERN CALIFORNIA AND ITS COLLABORATORS DO NOT MAKE ANY
% WARRANTY, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO WARRANTIES OF
% MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, NOR DO THEY ASSUME ANY
% LIABILITY OR RESPONSIBILITY FOR THE USE OF THIS SOFTWARE.
%<autoend> ------------------------ 26-May-2004 11:34:07 -----------------------

% Last Modified by GUIDE v2.0 19-Mar-2002 17:43:28

% /---Script Authors-------------------------------------\
% |  *** Alexei Ossadtchi, Ph.D.                         |
% |  USC - SIPI                                          |
% |                                                      |
% |  *** Sylvain Baillet, Ph.D.                          |
% |  Cognitive Neuroscience & Brain Imaging Laboratory   |
% |  CNRS UPR640 - LENA                                  | 
% |  Hopital de la Salpetriere, Paris, France            |
% |  sylvain.baillet@chups.jussieu.fr                    |
% |                                                      |
% |  John C. Mosher, Ph.D.
% \------------------------------------------------------/
%  
% Script History ---------------------------------------------------------------
% SB  10-Mar-2004  (BrainStorm v.1 update)
% JCM 26-Apr-2004  comments cleanup, particularly wrt bst_mriviewer
% Script History ---------------------------------------------------------------



if nargin == 0  % LAUNCH GUI
	
	fig = openfig(mfilename,'reuse');
	
	% Generate a structure of handles to pass to callbacks, and store it. 
	handles = guihandles(fig);
	guidata(fig, handles);
	
	if nargout > 0
		varargout{1} = fig;
	end
	
	setappdata(fig,'TileType','T')
	bst_color_scheme(fig)
	bst_layout('align',fig,2,2,2);
	set(fig,'visible','on')
	
elseif ischar(varargin{1}) % INVOKE NAMED SUBFUNCTION OR CALLBACK
	
	try
		if (nargout)
			[varargout{1:nargout}] = feval(varargin{:}); % FEVAL switchyard
		else
			feval(varargin{:}); % FEVAL switchyard
		end
	catch
		disp(lasterr);
	end
	
end


% --------------------------------------------------------------------
function varargout = create(h, eventdata, handles, varargin)

% Create figure
fig = pcs_params;
handles = guihandles(fig);

% Fill-out listboxes
set(handles.listbox1,'string',varargin{1}) % Available points
% Default fiducial names
% WARNING ! Do not change the order of the following points
% without altering DefineSCSdone_Callback in bst_mriviewer
FidNames0{1} = 'Nasion';
FidNames0{2} = 'LEFT Preauricular';
FidNames0{3} = 'RIGHT Preauricular';
%FidNames0{4} = 'Central Zenith Point';



setappdata(fig,'DefaultFiducialNames',FidNames0);
set(handles.listbox2,'string',FidNames0) % 



% --------------------------------------------------------------------
function varargout = assign_Callback(h, eventdata, handles, varargin)

% Default fiducial names
FidNames0 = getappdata(handles.pcsparams,'DefaultFiducialNames');
PointNames = get(handles.listbox1,'String');
FidNames = get(handles.listbox2,'String');

ass = getappdata(handles.pcsparams,'LookUpFiducials');
pnt = get(handles.listbox1,'Value');
fid = get(handles.listbox2,'Value');
ass(fid) = pnt;

FidNames{fid} = [FidNames0{fid} ': -> ' PointNames{pnt}];

set(handles.listbox2,'String',FidNames,...
	'value',modulo(get(handles.listbox2,'value')+1,length(FidNames)));
set(handles.listbox1,...
	'value',modulo(get(handles.listbox1,'value')+1,length(get(handles.listbox1,'String'))));

setappdata(handles.pcsparams,'LookUpFiducials',ass)



% --------------------------------------------------------------------
function varargout = done_Callback(h, eventdata, handles, varargin)

ass = getappdata(gcbf,'LookUpFiducials');
if(prod(ass)==0 | isempty(ass))
	if(strcmp(questdlg('Not all Fiducials are specified. Quit anyway?','Warning!','Yes','No','Cancel'),'Yes'));
		set(h,'Enable','off');        
	end;
else
	bst_mriviewer('DefineSCSdone_Callback','','','',ass)
	close(handles.pcsparams)      
end;



% --------------------------------------------------------------------
function varargout = checkboxctf_Callback(h, eventdata, handles, varargin)

v = get(h,'Value');
set(handles.checkboxnmag,'Value',~v);



% --------------------------------------------------------------------
function varargout = checkboxnmag_Callback(h, eventdata, handles, varargin)
v = get(h,'Value');
set(handles.checkboxctf,'Value',~v);



% --------------------------------------------------------------------
function varargout = quit_Callback(h, eventdata, handles, varargin)
delete(handles.pcsparams);

