function save_raw(fname,In);
%SAVE_RAW - Save out a matrix in BrainStorm "raw" format, based on extension
% function save_raw(fname,In);
%
% See also HELP_DATA_RAW, LOAD_RAW

%<autobegin> ---------------------- 26-May-2004 11:34:18 -----------------------
% --------- Automatically Generated Comments Block Using AUTO_COMMENTS ---------
%
% CATEGORY: Utility - General
%
% At Check-in: $Author: Mosher $  $Revision: 8 $  $Date: 5/26/04 10:02a $
%
% This software is part of BrainStorm Toolbox Version 2.0 (Alpha) 24-May-2004
% 
% Principal Investigators and Developers:
% ** Richard M. Leahy, PhD, Signal & Image Processing Institute,
%    University of Southern California, Los Angeles, CA
% ** John C. Mosher, PhD, Biophysics Group,
%    Los Alamos National Laboratory, Los Alamos, NM
% ** Sylvain Baillet, PhD, Cognitive Neuroscience & Brain Imaging Laboratory,
%    CNRS, Hopital de la Salpetriere, Paris, France
% 
% See BrainStorm website at http://neuroimage.usc.edu for further information.
% 
% Copyright (c) 2004 BrainStorm by the University of Southern California
% This software distributed  under the terms of the GNU General Public License
% as published by the Free Software Foundation. Further details on the GPL
% license can be found at http://www.gnu.org/copyleft/gpl.html .
% 
% FOR RESEARCH PURPOSES ONLY. THE SOFTWARE IS PROVIDED "AS IS," AND THE
% UNIVERSITY OF SOUTHERN CALIFORNIA AND ITS COLLABORATORS DO NOT MAKE ANY
% WARRANTY, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO WARRANTIES OF
% MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, NOR DO THEY ASSUME ANY
% LIABILITY OR RESPONSIBILITY FOR THE USE OF THIS SOFTWARE.
%<autoend> ------------------------ 26-May-2004 11:34:18 -----------------------

% Begin --------------------------- History ------------------------------------
% 19-Apr-2004 JCM Creation, may be redundant with other routines around
% End ----------------------------- History ------------------------------------

[ignore,ignore,RawType] = fileparts(fname);

switch lower(RawType),
   
   case '.txt'
      fid = fopen(fname,'wt');
      for i = 1:size(In,1),
         fprintf(fid,'%g ',In(i,:));
         fprintf(fid,'\n');
      end
      fclose(fid);
      
   case '.raw'
      fid = fopen(fname,'w');
      fwrite(fid,size(In),'single');
      fwrite(fid,In(:),'single');
      
      fclose(fid);
      
end
