function [R,s,sensnum,th,rings] = sensor_spacing(shell,spacing,coverage);
%SENSOR_SPACING - generate sites roughly evenly spaced about a hemisphere.
% function [R,s,sensnum,th,rings] = sensor_spacing(shell,spacing,coverage);
% Given a sphere of radius SHELL, and a desired separation between sites of
% distance SPACING, generate sites in matrix R with radial directions S over
% the sphere with coverage of COVERAGE radians measured from the positive
% z-axis (e.g., upper hemisphere has coverage of pi/2 radians.
% Optionally, COVERAGE may be 'half' or 'full' to indicate upperhemisphere
%  or full sphere coverage.
% 
% See SENSOR_RING for algorithm and explanation of 'sensnum'.
% 
% Output args THETA and RINGS can be used to run SENSOR_RINGS for same
% result.
%
% See also SENSOR_RING

%<autobegin> ---------------------- 26-May-2004 11:34:21 -----------------------
% --------- Automatically Generated Comments Block Using AUTO_COMMENTS ---------
%
% CATEGORY: Forward Modeling
%
% Alphabetical list of external functions (non-Matlab):
%   toolbox\sensor_ring.m
%
% At Check-in: $Author: Mosher $  $Revision: 14 $  $Date: 5/26/04 10:02a $
%
% This software is part of BrainStorm Toolbox Version 2.0 (Alpha) 24-May-2004
% 
% Principal Investigators and Developers:
% ** Richard M. Leahy, PhD, Signal & Image Processing Institute,
%    University of Southern California, Los Angeles, CA
% ** John C. Mosher, PhD, Biophysics Group,
%    Los Alamos National Laboratory, Los Alamos, NM
% ** Sylvain Baillet, PhD, Cognitive Neuroscience & Brain Imaging Laboratory,
%    CNRS, Hopital de la Salpetriere, Paris, France
% 
% See BrainStorm website at http://neuroimage.usc.edu for further information.
% 
% Copyright (c) 2004 BrainStorm by the University of Southern California
% This software distributed  under the terms of the GNU General Public License
% as published by the Free Software Foundation. Further details on the GPL
% license can be found at http://www.gnu.org/copyleft/gpl.html .
% 
% FOR RESEARCH PURPOSES ONLY. THE SOFTWARE IS PROVIDED "AS IS," AND THE
% UNIVERSITY OF SOUTHERN CALIFORNIA AND ITS COLLABORATORS DO NOT MAKE ANY
% WARRANTY, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO WARRANTIES OF
% MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, NOR DO THEY ASSUME ANY
% LIABILITY OR RESPONSIBILITY FOR THE USE OF THIS SOFTWARE.
%<autoend> ------------------------ 26-May-2004 11:34:21 -----------------------

% ----------------------------- Script History ---------------------------------
% July 27, 1994 author John C. Mosher, Ph.D.
% March 2, 1995 JCM: added 'half' and 'full' options for coverage
% March 6, 1995 Reversed shell and spacing inputs for consistency
% 19-May-2004 JCM Comments Cleaning
% ----------------------------- Script History ---------------------------------

if(spacing > shell),		% test for change in input order error
  error(...
  'Your spacing is greater than the shell radius.  Inputs probably reversed');
end

th = asin(spacing/shell); 	% angular separation of rings

if(isstr(coverage)),		% we will calculate
  rings = coverage;		% valid are 'h' and 'f'
else
  rings = round(coverage/th) + 1; % includes top point as a ring
end

[R,s,sensnum,th,rings] = sensor_ring(shell,th,rings);
% returns the actual th and rings used


return
